/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.PropertyAccessException;
import com.jgoodies.binding.beans.PropertyNotBindableException;
import com.jgoodies.binding.beans.PropertyNotFoundException;
import com.jgoodies.binding.beans.PropertyUnboundException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class BeanUtils {
    private static final Class[] PCL_PARAMS = new Class[]{class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = BeanUtils.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener};
    private static final Class[] NAMED_PCL_PARAMS = new Class[]{class$java$lang$String == null ? (class$java$lang$String = BeanUtils.class$("java.lang.String")) : class$java$lang$String, class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = BeanUtils.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener};
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$java$lang$String;

    private BeanUtils() {
    }

    public static boolean supportsBoundProperties(Class clazz) {
        return BeanUtils.getPCLAdder(clazz) != null && BeanUtils.getPCLRemover(clazz) != null;
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, String string) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!string.equals(propertyDescriptorArray[i].getName())) continue;
            return propertyDescriptorArray[i];
        }
        throw new IntrospectionException("Property '" + string + "' not found in bean " + object);
    }

    public static PropertyDescriptor getPropertyDescriptor(Object object, String string, String string2, String string3) {
        try {
            return string2 != null || string3 != null ? new PropertyDescriptor(string, object.getClass(), string2, string3) : BeanUtils.getPropertyDescriptor(object, string);
        }
        catch (IntrospectionException introspectionException) {
            throw new PropertyNotFoundException(string, object, introspectionException);
        }
    }

    public static Method getPCLAdder(Class clazz) {
        try {
            return clazz.getMethod("addPropertyChangeListener", PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getPCLRemover(Class clazz) {
        try {
            return clazz.getMethod("removePropertyChangeListener", PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getNamedPCLAdder(Class clazz) {
        try {
            return clazz.getMethod("addPropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static Method getNamedPCLRemover(Class clazz) {
        try {
            return clazz.getMethod("removePropertyChangeListener", NAMED_PCL_PARAMS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public static void addPropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        Class<?> clazz = object.getClass();
        if (!BeanUtils.supportsBoundProperties(clazz)) {
            throw new PropertyUnboundException("Bound properties unsupported by bean class=" + clazz + "\nThe Bean class must provide a pair of methods:" + "\npublic void addPropertyChangeListener(PropertyChangeListener x);" + "\npublic void removePropertyChangeListener(PropertyChangeListener x);");
        }
        Method method = BeanUtils.getPCLAdder(clazz);
        try {
            method.invoke(object, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to add a multicast PropertyChangeListener to bean: " + object, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to add a multicast PropertyChangeListener to bean: " + object, illegalAccessException);
        }
    }

    public static void addPropertyChangeListener(Object object, String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        Class<?> clazz = object.getClass();
        Method method = BeanUtils.getNamedPCLAdder(clazz);
        if (method == null) {
            throw new PropertyNotBindableException("Could not find the bean method/npublic void addPropertyChangeListener(String, PropertyChangeListener);/nin bean:" + object);
        }
        try {
            method.invoke(object, string, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to add a named PropertyChangeListener to bean: " + object, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to add a named PropertyChangeListener to bean: " + object, illegalAccessException);
        }
    }

    public static void removePropertyChangeListener(Object object, PropertyChangeListener propertyChangeListener) {
        Class<?> clazz = object.getClass();
        Method method = BeanUtils.getPCLRemover(clazz);
        if (method == null) {
            throw new PropertyUnboundException("Could not find the method:\npublic void removePropertyChangeListener(String, PropertyChangeListener x);\nfor bean:" + object);
        }
        try {
            method.invoke(object, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to remove a multicast PropertyChangeListener from bean: " + object, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to remove a multicast PropertyChangeListener from bean: " + object, illegalAccessException);
        }
    }

    public static void removePropertyChangeListener(Object object, String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (propertyChangeListener == null) {
            throw new NullPointerException("The listener must not be null.");
        }
        Class<?> clazz = object.getClass();
        Method method = BeanUtils.getNamedPCLRemover(clazz);
        if (method == null) {
            throw new PropertyNotBindableException("Could not find the bean method/npublic void removePropertyChangeListener(String, PropertyChangeListener);/nin bean:" + object);
        }
        try {
            method.invoke(object, string, propertyChangeListener);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new PropertyNotBindableException("Due to an InvocationTargetException we failed to remove a named PropertyChangeListener from bean: " + object, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PropertyNotBindableException("Due to an IllegalAccessException we failed to remove a named PropertyChangeListener from bean: " + object, illegalAccessException);
        }
    }

    public static Object getValue(Object object, PropertyDescriptor propertyDescriptor) {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method == null) {
            throw new UnsupportedOperationException("The property '" + propertyDescriptor.getName() + "' is write-only.");
        }
        try {
            return method.invoke(object, (Object[])null);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw PropertyAccessException.createReadAccessException(object, propertyDescriptor, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw PropertyAccessException.createReadAccessException(object, propertyDescriptor, illegalAccessException);
        }
    }

    public static void setValue(Object object, PropertyDescriptor propertyDescriptor, Object object2) {
        if (object == null) {
            throw new NullPointerException("The bean must not be null.");
        }
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            throw new UnsupportedOperationException("The property '" + propertyDescriptor.getName() + "' is read-only.");
        }
        try {
            method.invoke(object, object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw PropertyAccessException.createWriteAccessException(object, object2, propertyDescriptor, invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw PropertyAccessException.createWriteAccessException(object, object2, propertyDescriptor, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw PropertyAccessException.createWriteAccessException(object, object2, propertyDescriptor, illegalArgumentException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

