/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyChangeSupport;

public final class ExtendedPropertyChangeSupport
extends PropertyChangeSupport {
    private final Object source;
    private final boolean checkIdentityDefault;

    public ExtendedPropertyChangeSupport(Object object) {
        this(object, false);
    }

    public ExtendedPropertyChangeSupport(Object object, boolean bl) {
        super(object);
        this.source = object;
        this.checkIdentityDefault = bl;
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.firePropertyChange(propertyChangeEvent, this.checkIdentityDefault);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        this.firePropertyChange(string, object, object2, this.checkIdentityDefault);
    }

    public void firePropertyChange(PropertyChangeEvent propertyChangeEvent, boolean bl) {
        Object object = propertyChangeEvent.getOldValue();
        Object object2 = propertyChangeEvent.getNewValue();
        if (object != null && object == object2) {
            return;
        }
        if (bl) {
            this.fireUnchecked(propertyChangeEvent);
        } else {
            super.firePropertyChange(propertyChangeEvent);
        }
    }

    public void firePropertyChange(String string, Object object, Object object2, boolean bl) {
        if (object != null && object == object2) {
            return;
        }
        if (bl) {
            this.fireUnchecked(new PropertyChangeEvent(this.source, string, object, object2));
        } else {
            super.firePropertyChange(string, object, object2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireUnchecked(PropertyChangeEvent propertyChangeEvent) {
        ExtendedPropertyChangeSupport extendedPropertyChangeSupport = this;
        synchronized (extendedPropertyChangeSupport) {
            PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeListeners();
            for (int i = 0; i < propertyChangeListenerArray.length && !(propertyChangeListenerArray[i] instanceof PropertyChangeListenerProxy); ++i) {
                propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string == null) {
                return;
            }
            propertyChangeListenerArray = this.getPropertyChangeListeners(string);
            for (int i = 0; i < propertyChangeListenerArray.length; ++i) {
                propertyChangeListenerArray[i].propertyChange(propertyChangeEvent);
            }
        }
    }
}

