/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class IndirectPropertyChangeSupport {
    private final ValueModel beanChannel;
    private final List listenerList;
    private final Map namedListeners;

    public IndirectPropertyChangeSupport() {
        this(new ValueHolder(null, true));
    }

    public IndirectPropertyChangeSupport(Object object) {
        this(new ValueHolder(object, true));
    }

    public IndirectPropertyChangeSupport(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The bean channel must not be null.");
        }
        this.beanChannel = valueModel;
        this.listenerList = new LinkedList();
        this.namedListeners = new HashMap();
        valueModel.addValueChangeListener(new BeanChangeHandler());
    }

    public Object getBean() {
        return this.beanChannel.getValue();
    }

    public void setBean(Object object) {
        this.beanChannel.setValue(object);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.listenerList.add(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.addPropertyChangeListener(object, propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        this.listenerList.remove(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.removePropertyChangeListener(object, propertyChangeListener);
        }
    }

    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        LinkedList<PropertyChangeListener> linkedList = (LinkedList<PropertyChangeListener>)this.namedListeners.get(string);
        if (linkedList == null) {
            linkedList = new LinkedList<PropertyChangeListener>();
            this.namedListeners.put(string, linkedList);
        }
        linkedList.add(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.addPropertyChangeListener(object, string, propertyChangeListener);
        }
    }

    public synchronized void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            return;
        }
        List list = (List)this.namedListeners.get(string);
        if (list == null) {
            return;
        }
        list.remove(propertyChangeListener);
        Object object = this.getBean();
        if (object != null) {
            BeanUtils.removePropertyChangeListener(object, string, propertyChangeListener);
        }
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.listenerList.isEmpty()) {
            return new PropertyChangeListener[0];
        }
        return this.listenerList.toArray(new PropertyChangeListener[this.listenerList.size()]);
    }

    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String string) {
        List list = (List)this.namedListeners.get(string);
        if (list == null || list.isEmpty()) {
            return new PropertyChangeListener[0];
        }
        return list.toArray(new PropertyChangeListener[list.size()]);
    }

    public void removeAll() {
        this.removeAllListenersFrom(this.getBean());
    }

    private void setBean0(Object object, Object object2) {
        this.removeAllListenersFrom(object);
        this.addAllListenersTo(object2);
    }

    private void addAllListenersTo(Object object) {
        Object object2;
        if (object == null) {
            return;
        }
        Iterator<Object> iterator = this.listenerList.iterator();
        while (iterator.hasNext()) {
            object2 = (PropertyChangeListener)iterator.next();
            BeanUtils.addPropertyChangeListener(object, (PropertyChangeListener)object2);
        }
        iterator = this.namedListeners.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            String string = (String)object2.getKey();
            List list = (List)object2.getValue();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator2.next();
                BeanUtils.addPropertyChangeListener(object, string, propertyChangeListener);
            }
        }
    }

    private void removeAllListenersFrom(Object object) {
        Object object2;
        if (object == null) {
            return;
        }
        Iterator<Object> iterator = this.listenerList.iterator();
        while (iterator.hasNext()) {
            object2 = (PropertyChangeListener)iterator.next();
            BeanUtils.removePropertyChangeListener(object, (PropertyChangeListener)object2);
        }
        iterator = this.namedListeners.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            String string = (String)object2.getKey();
            List list = (List)object2.getValue();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                PropertyChangeListener propertyChangeListener = (PropertyChangeListener)iterator2.next();
                BeanUtils.removePropertyChangeListener(object, string, propertyChangeListener);
            }
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            IndirectPropertyChangeSupport.this.setBean0(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

