/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;

public class PropertyAdapter
extends AbstractValueModel {
    public static final String PROPERTYNAME_BEFORE_BEAN = "beforeBean";
    public static final String PROPERTYNAME_BEAN = "bean";
    public static final String PROPERTYNAME_AFTER_BEAN = "afterBean";
    public static final String PROPERTYNAME_CHANGED = "changed";
    private final ValueModel beanChannel;
    private final String propertyName;
    private final String getterName;
    private final String setterName;
    private final boolean observeChanges;
    private Object storedOldBean;
    private boolean changed = false;
    private PropertyChangeListener propertyChangeHandler;
    private PropertyDescriptor cachedPropertyDescriptor;
    private Class cachedBeanClass;

    public PropertyAdapter(Object object, String string) {
        this(object, string, false);
    }

    public PropertyAdapter(Object object, String string, boolean bl) {
        this(object, string, null, null, bl);
    }

    public PropertyAdapter(Object object, String string, String string2, String string3) {
        this(object, string, string2, string3, false);
    }

    public PropertyAdapter(Object object, String string, String string2, String string3, boolean bl) {
        this(new ValueHolder(object), string, string2, string3, bl);
    }

    public PropertyAdapter(ValueModel valueModel, String string) {
        this(valueModel, string, false);
    }

    public PropertyAdapter(ValueModel valueModel, String string, boolean bl) {
        this(valueModel, string, null, null, bl);
    }

    public PropertyAdapter(ValueModel valueModel, String string, String string2, String string3) {
        this(valueModel, string, string2, string3, false);
    }

    public PropertyAdapter(ValueModel valueModel, String string, String string2, String string3, boolean bl) {
        this.beanChannel = valueModel != null ? valueModel : new ValueHolder();
        this.propertyName = string;
        this.getterName = string2;
        this.setterName = string3;
        this.observeChanges = bl;
        if (string == null) {
            throw new NullPointerException("The property name must not be null.");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("The property name must not be empty.");
        }
        this.beanChannel.addValueChangeListener(new BeanChangeHandler());
        Object object = this.getBean();
        if (object != null) {
            this.getPropertyDescriptor(object);
            this.observe(object);
        }
        this.storedOldBean = object;
    }

    public Object getBean() {
        return this.beanChannel.getValue();
    }

    public void setBean(Object object) {
        this.beanChannel.setValue(object);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean getObserveChanges() {
        return this.observeChanges;
    }

    public Object getValue() {
        Object object = this.getBean();
        if (object == null) {
            return null;
        }
        return this.getValue0(object);
    }

    public void setValue(Object object) {
        this.setValue0(this.getBean(), object);
    }

    public boolean isChanged() {
        return this.changed;
    }

    public void resetChanged() {
        this.setChanged(false);
    }

    private void setChanged(boolean bl) {
        boolean bl2 = this.isChanged();
        this.changed = bl;
        this.firePropertyChange(PROPERTYNAME_CHANGED, bl2, bl);
    }

    public void release() {
        this.retractInterestFor(this.getBean());
    }

    private void setBean0(Object object, Object object2) {
        this.firePropertyChange(PROPERTYNAME_BEFORE_BEAN, object, object2);
        this.retractInterestFor(object);
        this.forwardAdaptedValueChanged(object, object2);
        this.resetChanged();
        this.observe(object2);
        this.firePropertyChange(PROPERTYNAME_BEAN, object, object2);
        this.firePropertyChange(PROPERTYNAME_AFTER_BEAN, object, object2);
    }

    private void forwardAdaptedValueChanged(Object object, Object object2) {
        Object object3;
        Object object4 = object == null || this.isWriteOnlyProperty(object) ? null : this.getValue0(object);
        Object object5 = object3 = object2 == null || this.isWriteOnlyProperty(object2) ? null : this.getValue0(object2);
        if (object4 != null || object3 != null) {
            this.fireValueChange(object4, object3, true);
        }
    }

    private void forwardAdaptedValueChanged(Object object) {
        Object object2 = object == null || this.isWriteOnlyProperty(object) ? null : this.getValue0(object);
        this.fireValueChange(null, object2);
    }

    private void observe(Object object) {
        if (!this.observeChanges || object == null) {
            return;
        }
        this.propertyChangeHandler = new PropertyChangeHandler();
        BeanUtils.addPropertyChangeListener(object, this.propertyChangeHandler);
    }

    private void retractInterestFor(Object object) {
        if (!this.observeChanges || object == null) {
            return;
        }
        BeanUtils.removePropertyChangeListener(object, this.propertyChangeHandler);
        this.propertyChangeHandler = null;
    }

    private Object getValue0(Object object) {
        return object == null ? null : BeanUtils.getValue(object, this.getPropertyDescriptor(object));
    }

    private void setValue0(Object object, Object object2) {
        if (object != null) {
            BeanUtils.setValue(object, this.getPropertyDescriptor(object), object2);
        }
    }

    private PropertyDescriptor getPropertyDescriptor(Object object) {
        if (this.cachedPropertyDescriptor == null || object.getClass() != this.cachedBeanClass) {
            this.cachedPropertyDescriptor = BeanUtils.getPropertyDescriptor(object, this.getPropertyName(), this.getterName, this.setterName);
            this.cachedBeanClass = object.getClass();
        }
        return this.cachedPropertyDescriptor;
    }

    private boolean isWriteOnlyProperty(Object object) {
        return null == this.getPropertyDescriptor(object).getReadMethod();
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            PropertyAdapter.this.setChanged(true);
            if (propertyChangeEvent.getPropertyName() == null) {
                PropertyAdapter.this.forwardAdaptedValueChanged(PropertyAdapter.this.getBean());
            } else if (propertyChangeEvent.getPropertyName().equals(PropertyAdapter.this.getPropertyName())) {
                PropertyAdapter.this.fireValueChange(propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), true);
            }
        }
    }

    private class BeanChangeHandler
    implements PropertyChangeListener {
        private BeanChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getNewValue();
            PropertyAdapter.this.setBean0(PropertyAdapter.this.storedOldBean, object);
            PropertyAdapter.this.storedOldBean = object;
        }
    }
}

