/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import com.jgoodies.binding.beans.BeanUtils;
import com.jgoodies.binding.beans.PropertyNotFoundException;
import java.beans.IntrospectionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;

public final class PropertyConnector {
    private final Object bean1;
    private final Object bean2;
    private final String property1Name;
    private final String property2Name;
    private final PropertyChangeListener property1ChangeHandler;
    private final PropertyChangeListener property2ChangeHandler;
    private final PropertyDescriptor property1Descriptor;
    private final PropertyDescriptor property2Descriptor;

    public PropertyConnector(Object object, String string, Object object2, String string2) {
        boolean bl;
        if (object == null) {
            throw new NullPointerException("Bean1 must not be null.");
        }
        if (object2 == null) {
            throw new NullPointerException("Bean2 must not be null.");
        }
        if (string == null) {
            throw new NullPointerException("PropertyName1 must not be null.");
        }
        if (string2 == null) {
            throw new NullPointerException("PropertyName2 must not be null.");
        }
        if (object == object2 && string.equals(string2)) {
            throw new IllegalArgumentException("Cannot connect a bean property to itself on the same bean.");
        }
        this.bean1 = object;
        this.bean2 = object2;
        this.property1Name = string;
        this.property2Name = string2;
        this.property1Descriptor = PropertyConnector.getPropertyDescriptor(object, string);
        this.property2Descriptor = PropertyConnector.getPropertyDescriptor(object2, string2);
        boolean bl2 = this.property1Descriptor.getWriteMethod() != null;
        boolean bl3 = bl = this.property2Descriptor.getWriteMethod() != null;
        if (!bl2 && !bl) {
            throw new IllegalArgumentException("Cannot connect two read-only properties.");
        }
        this.property1ChangeHandler = new PropertyChangeHandler(object, this.property1Descriptor, object2, this.property2Descriptor);
        this.property2ChangeHandler = new PropertyChangeHandler(object2, this.property2Descriptor, object, this.property1Descriptor);
        if (bl) {
            PropertyConnector.addPropertyChangeHandler(object, this.property1ChangeHandler);
        }
        if (bl2) {
            PropertyConnector.addPropertyChangeHandler(object2, this.property2ChangeHandler);
        }
    }

    public static void connect(Object object, String string, Object object2, String string2) {
        new PropertyConnector(object, string, object2, string2);
    }

    public Object getBean1() {
        return this.bean1;
    }

    public Object getBean2() {
        return this.bean2;
    }

    public String getProperty1Name() {
        return this.property1Name;
    }

    public String getProperty2Name() {
        return this.property2Name;
    }

    public void updateProperty1() {
        Object object = BeanUtils.getValue(this.bean2, this.property2Descriptor);
        this.setValueSilently(this.bean1, this.property1Descriptor, object);
    }

    public void updateProperty2() {
        Object object = BeanUtils.getValue(this.bean1, this.property1Descriptor);
        this.setValueSilently(this.bean2, this.property2Descriptor, object);
    }

    public void release() {
        PropertyConnector.removePropertyChangeHandler(this.bean1, this.property1ChangeHandler);
        PropertyConnector.removePropertyChangeHandler(this.bean2, this.property2ChangeHandler);
    }

    private static void addPropertyChangeHandler(Object object, PropertyChangeListener propertyChangeListener) {
        if (object != null) {
            BeanUtils.addPropertyChangeListener(object, propertyChangeListener);
        }
    }

    private static void removePropertyChangeHandler(Object object, PropertyChangeListener propertyChangeListener) {
        if (object != null) {
            BeanUtils.removePropertyChangeListener(object, propertyChangeListener);
        }
    }

    private void setValueSilently(Object object, PropertyDescriptor propertyDescriptor, Object object2) {
        PropertyConnector.removePropertyChangeHandler(this.bean1, this.property1ChangeHandler);
        PropertyConnector.removePropertyChangeHandler(this.bean2, this.property2ChangeHandler);
        BeanUtils.setValue(object, propertyDescriptor, object2);
        PropertyConnector.addPropertyChangeHandler(this.bean1, this.property1ChangeHandler);
        PropertyConnector.addPropertyChangeHandler(this.bean2, this.property2ChangeHandler);
    }

    private static PropertyDescriptor getPropertyDescriptor(Object object, String string) {
        try {
            return BeanUtils.getPropertyDescriptor(object, string);
        }
        catch (IntrospectionException introspectionException) {
            throw new PropertyNotFoundException(string, object, introspectionException);
        }
    }

    private final class PropertyChangeHandler
    implements PropertyChangeListener {
        private final Object sourceBean;
        private final PropertyDescriptor sourcePropertyDescriptor;
        private final Object targetBean;
        private final PropertyDescriptor targetPropertyDescriptor;

        private PropertyChangeHandler(Object object, PropertyDescriptor propertyDescriptor, Object object2, PropertyDescriptor propertyDescriptor2) {
            this.sourceBean = object;
            this.sourcePropertyDescriptor = propertyDescriptor;
            this.targetBean = object2;
            this.targetPropertyDescriptor = propertyDescriptor2;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = this.sourcePropertyDescriptor.getName();
            if (propertyChangeEvent.getPropertyName() == null || propertyChangeEvent.getPropertyName().equals(string)) {
                Object object = propertyChangeEvent.getNewValue();
                if (object == null) {
                    object = BeanUtils.getValue(this.sourceBean, this.sourcePropertyDescriptor);
                }
                PropertyConnector.this.setValueSilently(this.targetBean, this.targetPropertyDescriptor, object);
            }
        }
    }
}

