/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ObservableList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class LinkedListModel
extends LinkedList
implements ObservableList {
    private static final long serialVersionUID = 5753378113505707237L;
    private EventListenerList listenerList;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public LinkedListModel() {
    }

    public LinkedListModel(Collection collection) {
        super(collection);
    }

    public void add(int n, Object object) {
        super.add(n, object);
        this.fireIntervalAdded(n, n);
    }

    public boolean add(Object object) {
        int n = this.size();
        super.add(object);
        this.fireIntervalAdded(n, n);
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = super.addAll(n, collection);
        if (bl) {
            int n2 = n + collection.size() - 1;
            this.fireIntervalAdded(n, n2);
        }
        return bl;
    }

    public void addFirst(Object object) {
        super.addFirst(object);
        this.fireIntervalAdded(0, 0);
    }

    public void addLast(Object object) {
        int n = this.size();
        super.addLast(object);
        this.fireIntervalAdded(n, n);
    }

    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        int n = this.size() - 1;
        super.clear();
        this.fireIntervalRemoved(0, n);
    }

    public Object remove(int n) {
        Object e = super.remove(n);
        this.fireIntervalRemoved(n, n);
        return e;
    }

    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    public Object removeFirst() {
        Object e = super.removeFirst();
        this.fireIntervalRemoved(0, 0);
        return e;
    }

    public Object removeLast() {
        int n = this.size() - 1;
        Object e = super.removeLast();
        this.fireIntervalRemoved(n, n);
        return e;
    }

    protected void removeRange(int n, int n2) {
        super.removeRange(n, n2);
        this.fireIntervalRemoved(n, n2 - 1);
    }

    public Object set(int n, Object object) {
        Object object2 = super.set(n, object);
        this.fireContentsChanged(n, n);
        return object2;
    }

    public ListIterator listIterator(int n) {
        return new ReportingListIterator(super.listIterator(n));
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.getEventListenerList().add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = LinkedListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.getEventListenerList().remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = LinkedListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public Object getElementAt(int n) {
        return this.get(n);
    }

    public int getSize() {
        return this.size();
    }

    public void fireContentsChanged(int n) {
        this.fireContentsChanged(n, n);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.getEventListenerList().getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = LinkedListModel.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
    }

    private void fireContentsChanged(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? LinkedListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    private void fireIntervalAdded(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? LinkedListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 1, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
        }
    }

    private void fireIntervalRemoved(int n, int n2) {
        Object[] objectArray = this.getEventListenerList().getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? LinkedListModel.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 2, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
        }
    }

    private EventListenerList getEventListenerList() {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        return this.listenerList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ReportingListIterator
    implements ListIterator {
        private final ListIterator delegate;
        private int lastReturnedIndex;

        ReportingListIterator(ListIterator listIterator) {
            this.delegate = listIterator;
            this.lastReturnedIndex = -1;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            this.lastReturnedIndex = this.nextIndex();
            return this.delegate.next();
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        public Object previous() {
            this.lastReturnedIndex = this.previousIndex();
            return this.delegate.previous();
        }

        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        public void remove() {
            int n = LinkedListModel.this.size();
            this.delegate.remove();
            int n2 = LinkedListModel.this.size();
            if (n2 < n) {
                LinkedListModel.this.fireIntervalRemoved(this.lastReturnedIndex, this.lastReturnedIndex);
            }
        }

        public void set(Object object) {
            this.delegate.set(object);
        }

        public void add(Object object) {
            this.delegate.add(object);
            int n = this.previousIndex();
            LinkedListModel.this.fireIntervalAdded(n, n);
            this.lastReturnedIndex = -1;
        }
    }
}

