/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class SelectionInList
extends AbstractValueModel
implements ListModel {
    public static final String PROPERTYNAME_LIST = "list";
    public static final String PROPERTYNAME_LIST_HOLDER = "listHolder";
    public static final String PROPERTYNAME_SELECTION = "selection";
    public static final String PROPERTYNAME_SELECTION_EMPTY = "selectionEmpty";
    public static final String PROPERTYNAME_SELECTION_HOLDER = "selectionHolder";
    public static final String PROPERTYNAME_SELECTION_INDEX = "selectionIndex";
    public static final String PROPERTYNAME_SELECTION_INDEX_HOLDER = "selectionIndexHolder";
    private static final int NO_SELECTION_INDEX = -1;
    private static final ListModel EMPTY_LIST_MODEL = new EmptyListModel();
    private ValueModel listHolder;
    private Object list;
    private ValueModel selectionHolder;
    private ValueModel selectionIndexHolder;
    private final PropertyChangeListener listChangeHandler;
    private final ListDataListener listDataChangeHandler;
    private final PropertyChangeListener selectionChangeHandler;
    private final PropertyChangeListener selectionIndexChangeHandler;
    private final EventListenerList listenerList = new EventListenerList();
    private Object oldSelection;
    private int oldSelectionIndex;
    static /* synthetic */ Class class$javax$swing$event$ListDataListener;

    public SelectionInList() {
        this(new ArrayListModel());
    }

    public SelectionInList(Object[] objectArray) {
        this(Arrays.asList(objectArray));
    }

    public SelectionInList(Object[] objectArray, ValueModel valueModel) {
        this(Arrays.asList(objectArray), valueModel);
    }

    public SelectionInList(Object[] objectArray, ValueModel valueModel, ValueModel valueModel2) {
        this(Arrays.asList(objectArray), valueModel, valueModel2);
    }

    public SelectionInList(List list) {
        this(new ValueHolder(list, true));
    }

    public SelectionInList(List list, ValueModel valueModel) {
        this(new ValueHolder(list, true), valueModel);
    }

    public SelectionInList(List list, ValueModel valueModel, ValueModel valueModel2) {
        this(new ValueHolder(list, true), valueModel, valueModel2);
    }

    public SelectionInList(ListModel listModel) {
        this(new ValueHolder(listModel, true));
    }

    public SelectionInList(ListModel listModel, ValueModel valueModel) {
        this(new ValueHolder(listModel, true), valueModel);
    }

    public SelectionInList(ListModel listModel, ValueModel valueModel, ValueModel valueModel2) {
        this(new ValueHolder(listModel, true), valueModel, valueModel2);
    }

    public SelectionInList(ValueModel valueModel) {
        this(valueModel, (ValueModel)new ValueHolder());
    }

    public SelectionInList(ValueModel valueModel, ValueModel valueModel2) {
        this(valueModel, valueModel2, (ValueModel)new ValueHolder(new Integer(-1)));
    }

    public SelectionInList(ValueModel valueModel, ValueModel valueModel2, ValueModel valueModel3) {
        if (valueModel == null) {
            throw new NullPointerException("The list holder must not be null.");
        }
        if (valueModel2 == null) {
            throw new NullPointerException("The selection holder must not be null.");
        }
        if (valueModel3 == null) {
            throw new NullPointerException("The selection index holder must not be null.");
        }
        this.listChangeHandler = new ListChangeHandler();
        this.listDataChangeHandler = new ListDataChangeHandler();
        this.selectionChangeHandler = new SelectionChangeHandler();
        this.selectionIndexChangeHandler = new SelectionIndexChangeHandler();
        this.listHolder = valueModel;
        this.selectionHolder = valueModel2;
        this.selectionIndexHolder = valueModel3;
        this.initializeSelectionIndex();
        this.listHolder.addValueChangeListener(this.listChangeHandler);
        this.selectionHolder.addValueChangeListener(this.selectionChangeHandler);
        this.selectionIndexHolder.addValueChangeListener(this.selectionIndexChangeHandler);
        this.list = valueModel.getValue();
        if (this.list != null && this.list instanceof ListModel) {
            ((ListModel)this.list).addListDataListener(this.listDataChangeHandler);
        }
    }

    public int getSize() {
        return this.getSize(this.getListHolder().getValue());
    }

    private int getSize(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof ListModel) {
            return ((ListModel)object).getSize();
        }
        return ((List)object).size();
    }

    public Object getElementAt(int n) {
        return this.getElementAt(this.getListHolder().getValue(), n);
    }

    private Object getElementAt(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("The list contents is null.");
        }
        if (object instanceof ListModel) {
            return ((ListModel)object).getElementAt(n);
        }
        return ((List)object).get(n);
    }

    private Object getSafeElementAt(int n) {
        return n < 0 || n >= this.getSize() ? null : this.getElementAt(n);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listenerList.add(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = SelectionInList.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listenerList.remove(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = SelectionInList.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener, listDataListener);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.listenerList.getListeners(class$javax$swing$event$ListDataListener == null ? (class$javax$swing$event$ListDataListener = SelectionInList.class$("javax.swing.event.ListDataListener")) : class$javax$swing$event$ListDataListener);
    }

    private void fireContentsChanged(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? SelectionInList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 0, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).contentsChanged(listDataEvent);
        }
    }

    private void fireIntervalAdded(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? SelectionInList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 1, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalAdded(listDataEvent);
        }
    }

    private void fireIntervalRemoved(int n, int n2) {
        Object[] objectArray = this.listenerList.getListenerList();
        ListDataEvent listDataEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$javax$swing$event$ListDataListener == null ? SelectionInList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (listDataEvent == null) {
                listDataEvent = new ListDataEvent(this, 2, n, n2);
            }
            ((ListDataListener)objectArray[i + 1]).intervalRemoved(listDataEvent);
        }
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public ListModel getListModel() {
        Object object = this.getListHolder().getValue();
        if (object == null) {
            return EMPTY_LIST_MODEL;
        }
        if (object instanceof ListModel) {
            return (ListModel)object;
        }
        return new ListModelAdapter((List)object);
    }

    public void setListModel(ListModel listModel) {
        this.getListHolder().setValue(listModel);
    }

    public void setList(List list) {
        this.getListHolder().setValue(list);
    }

    public Object getSelection() {
        return this.getSafeElementAt(this.getSelectionIndex());
    }

    public void setSelection(Object object) {
        if (!this.isEmpty()) {
            this.setSelectionIndex(this.indexOf(object));
        }
    }

    public boolean hasSelection() {
        return this.getSelectionIndex() != -1;
    }

    public boolean isSelectionEmpty() {
        return !this.hasSelection();
    }

    public void clearSelection() {
        this.setSelectionIndex(-1);
    }

    public int getSelectionIndex() {
        Integer n;
        ValueModel valueModel = this.getSelectionIndexHolder();
        if (valueModel != null && (n = (Integer)valueModel.getValue()) != null) {
            return n;
        }
        return -1;
    }

    public void setSelectionIndex(int n) {
        if (n < -1 || n > this.getSize()) {
            throw new IndexOutOfBoundsException("The selection index must be between -1 and " + this.getSize());
        }
        this.oldSelectionIndex = this.getSelectionIndex();
        if (this.oldSelectionIndex == n) {
            return;
        }
        this.getSelectionIndexHolder().setValue(new Integer(n));
    }

    public ValueModel getListHolder() {
        return this.listHolder;
    }

    public void setListHolder(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The new list holder must not be null.");
        }
        ValueModel valueModel2 = this.getListHolder();
        if (this.equals(valueModel2, valueModel)) {
            return;
        }
        Object object = this.list;
        Object object2 = valueModel.getValue();
        valueModel2.removeValueChangeListener(this.listChangeHandler);
        this.listHolder = valueModel;
        valueModel.addValueChangeListener(this.listChangeHandler);
        this.updateList(object, object2);
        this.firePropertyChange(PROPERTYNAME_LIST_HOLDER, valueModel2, valueModel);
    }

    public ValueModel getSelectionHolder() {
        return this.selectionHolder;
    }

    public void setSelectionHolder(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The new selection holder must not be null.");
        }
        ValueModel valueModel2 = this.getSelectionHolder();
        if (this.equals(valueModel2, valueModel)) {
            return;
        }
        valueModel2.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionHolder = valueModel;
        this.oldSelection = valueModel.getValue();
        valueModel.addValueChangeListener(this.selectionChangeHandler);
        this.firePropertyChange(PROPERTYNAME_SELECTION_HOLDER, valueModel2, valueModel);
    }

    public ValueModel getSelectionIndexHolder() {
        return this.selectionIndexHolder;
    }

    public void setSelectionIndexHolder(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The new selection index holder must not be null.");
        }
        if (valueModel.getValue() == null) {
            throw new IllegalArgumentException("The value of the new selection index holder must not be null.");
        }
        ValueModel valueModel2 = this.getSelectionIndexHolder();
        if (this.equals(valueModel2, valueModel)) {
            return;
        }
        valueModel2.removeValueChangeListener(this.selectionIndexChangeHandler);
        this.selectionIndexHolder = valueModel;
        valueModel.addValueChangeListener(this.selectionIndexChangeHandler);
        this.oldSelectionIndex = this.getSelectionIndex();
        this.oldSelection = this.getSafeElementAt(this.oldSelectionIndex);
        this.firePropertyChange(PROPERTYNAME_SELECTION_INDEX_HOLDER, valueModel2, valueModel);
    }

    public Object getValue() {
        return this.getSelection();
    }

    public void setValue(Object object) {
        this.setSelection(object);
    }

    protected int indexOf(Object object) {
        return this.indexOf(this.getListHolder().getValue(), object);
    }

    private int indexOf(Object object, Object object2) {
        if (object2 == null) {
            return -1;
        }
        if (this.getSize(object) == 0) {
            return -1;
        }
        if (object instanceof List) {
            return ((List)object).indexOf(object2);
        }
        ListModel listModel = (ListModel)object;
        int n = listModel.getSize();
        for (int i = 0; i < n; ++i) {
            if (!object2.equals(listModel.getElementAt(i))) continue;
            return i;
        }
        return -1;
    }

    private void initializeSelectionIndex() {
        Object object = this.selectionHolder.getValue();
        if (object != null) {
            this.setSelectionIndex(this.indexOf(object));
        }
        this.oldSelection = object;
        this.oldSelectionIndex = this.getSelectionIndex();
    }

    private void updateSelectionIndex(Object object) {
        if (!this.hasSelection()) {
            return;
        }
        Object object2 = this.getSelectionHolder().getValue();
        this.setSelectionIndex(this.indexOf(object, object2));
    }

    private void updateList(Object object, Object object2) {
        if (object != null && object instanceof ListModel) {
            ((ListModel)object).removeListDataListener(this.listDataChangeHandler);
        }
        if (object2 != null && object2 instanceof ListModel) {
            ((ListModel)object2).addListDataListener(this.listDataChangeHandler);
        }
        this.list = object2;
        this.updateSelectionIndex(object2);
        this.firePropertyChange(PROPERTYNAME_LIST, object, object2);
        this.fireContentsChanged(0, Integer.MAX_VALUE);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SelectionIndexChangeHandler
    implements PropertyChangeListener {
        private SelectionIndexChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            int n = SelectionInList.this.getSelectionIndex();
            Object object2 = SelectionInList.this.oldSelection;
            if (!SelectionInList.this.equals(object2, object = SelectionInList.this.getSafeElementAt(n))) {
                SelectionInList.this.selectionHolder.removeValueChangeListener(SelectionInList.this.selectionChangeHandler);
                SelectionInList.this.selectionHolder.setValue(object);
                SelectionInList.this.selectionHolder.addValueChangeListener(SelectionInList.this.selectionChangeHandler);
            }
            int n2 = SelectionInList.this.oldSelectionIndex;
            SelectionInList.this.oldSelectionIndex = n;
            SelectionInList.this.oldSelection = object;
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_INDEX, n2, n);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_EMPTY, n2 == -1, n == -1);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION, object2, object);
            SelectionInList.this.fireValueChange(object2, object);
        }
    }

    private class SelectionChangeHandler
    implements PropertyChangeListener {
        private SelectionChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getOldValue();
            Object object2 = propertyChangeEvent.getNewValue();
            int n = SelectionInList.this.indexOf(object2);
            if (n != SelectionInList.this.oldSelectionIndex) {
                SelectionInList.this.selectionIndexHolder.removeValueChangeListener(SelectionInList.this.selectionIndexChangeHandler);
                SelectionInList.this.selectionIndexHolder.setValue(new Integer(n));
                SelectionInList.this.selectionIndexHolder.addValueChangeListener(SelectionInList.this.selectionIndexChangeHandler);
            }
            int n2 = SelectionInList.this.oldSelectionIndex;
            SelectionInList.this.oldSelectionIndex = n;
            SelectionInList.this.oldSelection = object2;
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_INDEX, n2, n);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_EMPTY, n2 == -1, n == -1);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION, object, object2);
            SelectionInList.this.fireValueChange(object, object2);
        }
    }

    private class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalAdded(n, n2);
            if (n3 >= n) {
                SelectionInList.this.setSelectionIndex(n3 + (n2 - n + 1));
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalRemoved(n, n2);
            if (n3 >= n) {
                if (n3 <= n2) {
                    SelectionInList.this.setSelectionIndex(-1);
                } else {
                    SelectionInList.this.setSelectionIndex(n3 - (n2 - n + 1));
                }
            }
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            SelectionInList.this.fireContentsChanged(listDataEvent.getIndex0(), listDataEvent.getIndex1());
            this.updateSelectionContentsChanged(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        private void updateSelectionContentsChanged(int n, int n2) {
            if (n < 0) {
                return;
            }
            int n3 = SelectionInList.this.getSelectionIndex();
            if (n <= n3 && n3 <= n2) {
                SelectionInList.this.getSelectionHolder().setValue(SelectionInList.this.getElementAt(n3));
            }
        }
    }

    private class ListChangeHandler
    implements PropertyChangeListener {
        private ListChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = SelectionInList.this.list;
            Object object2 = propertyChangeEvent.getNewValue();
            SelectionInList.this.updateList(object, object2);
        }
    }

    private static class ListModelAdapter
    extends AbstractListModel {
        private final List aList;

        ListModelAdapter(List list) {
            this.aList = list;
        }

        public int getSize() {
            return this.aList.size();
        }

        public Object getElementAt(int n) {
            return this.aList.get(n);
        }
    }

    private static final class EmptyListModel
    extends AbstractListModel {
        private EmptyListModel() {
        }

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int n) {
            return null;
        }
    }
}

