/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public final class BufferedValueModel
extends AbstractValueModel {
    public static final String PROPERTYNAME_BUFFERING = "buffering";
    public static final String PROPERTYNAME_SUBJECT = "subject";
    public static final String PROPERTYNAME_TRIGGER_CHANNEL = "triggerChannel";
    private ValueModel subject;
    private ValueModel triggerChannel;
    private Object bufferedValue;
    private boolean valueAssigned;
    private final ValueChangeHandler valueChangeHandler = new ValueChangeHandler();
    private final TriggerChangeHandler triggerChangeHandler = new TriggerChangeHandler();

    public BufferedValueModel(ValueModel valueModel, ValueModel valueModel2) {
        this.setSubject(valueModel);
        this.setTriggerChannel(valueModel2);
        this.setBuffering(false);
    }

    public ValueModel getSubject() {
        return this.subject;
    }

    public void setSubject(ValueModel valueModel) {
        ValueModel valueModel2 = this.getSubject();
        ReadAccessResult readAccessResult = this.readSubjectValue();
        Object object = readAccessResult.value;
        if (valueModel2 != null) {
            valueModel2.removeValueChangeListener(this.valueChangeHandler);
        }
        this.subject = valueModel;
        if (valueModel != null) {
            valueModel.addValueChangeListener(this.valueChangeHandler);
        }
        this.firePropertyChange(PROPERTYNAME_SUBJECT, valueModel2, valueModel);
        if (this.isBuffering()) {
            return;
        }
        ReadAccessResult readAccessResult2 = this.readSubjectValue();
        Object object2 = readAccessResult2.value;
        if (object != null || object2 != null) {
            this.fireValueChange(object, object2, true);
        }
    }

    public ValueModel getTriggerChannel() {
        return this.triggerChannel;
    }

    public void setTriggerChannel(ValueModel valueModel) {
        if (valueModel == null) {
            throw new NullPointerException("The trigger channel must not be null.");
        }
        ValueModel valueModel2 = this.getTriggerChannel();
        if (valueModel2 != null) {
            valueModel2.removeValueChangeListener(this.triggerChangeHandler);
        }
        this.triggerChannel = valueModel;
        valueModel.addValueChangeListener(this.triggerChangeHandler);
        this.firePropertyChange(PROPERTYNAME_TRIGGER_CHANNEL, valueModel2, valueModel);
    }

    public Object getValue() {
        if (this.subject == null) {
            throw new NullPointerException("The subject must not be null when reading a value from a BufferedValueModel.");
        }
        return this.isBuffering() ? this.bufferedValue : this.subject.getValue();
    }

    public void setValue(Object object) {
        if (this.subject == null) {
            throw new NullPointerException("The subject must not be null when setting a value to a BufferedValueModel.");
        }
        ReadAccessResult readAccessResult = this.readSubjectValue();
        Object object2 = readAccessResult.value;
        this.bufferedValue = object;
        this.setBuffering(true);
        if (readAccessResult.readable && object2 == object) {
            return;
        }
        this.fireValueChange(object2, object, true);
    }

    private ReadAccessResult readSubjectValue() {
        try {
            Object object = this.getValue();
            return new ReadAccessResult(object, true);
        }
        catch (Exception exception) {
            return new ReadAccessResult(null, false);
        }
    }

    public void release() {
        ValueModel valueModel;
        ValueModel valueModel2 = this.getSubject();
        if (valueModel2 != null) {
            valueModel2.removeValueChangeListener(this.valueChangeHandler);
        }
        if ((valueModel = this.getTriggerChannel()) != null) {
            valueModel.removeValueChangeListener(this.triggerChangeHandler);
        }
    }

    public boolean isBuffering() {
        return this.valueAssigned;
    }

    private void setBuffering(boolean bl) {
        boolean bl2 = this.isBuffering();
        this.valueAssigned = bl;
        this.firePropertyChange(PROPERTYNAME_BUFFERING, bl2, bl);
    }

    private void commit() {
        if (this.isBuffering()) {
            this.setBuffering(false);
            this.valueChangeHandler.oldValue = this.bufferedValue;
            this.subject.setValue(this.bufferedValue);
            this.valueChangeHandler.oldValue = null;
        } else if (this.subject == null) {
            throw new NullPointerException("The subject must not be null while commiting a value in a BufferedValueModel.");
        }
    }

    private void flush() {
        Object object = this.getValue();
        this.setBuffering(false);
        Object object2 = this.getValue();
        this.fireValueChange(object, object2, true);
    }

    private class TriggerChangeHandler
    implements PropertyChangeListener {
        private TriggerChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
                BufferedValueModel.this.commit();
            } else if (Boolean.FALSE.equals(propertyChangeEvent.getNewValue())) {
                BufferedValueModel.this.flush();
            }
        }
    }

    private class ValueChangeHandler
    implements PropertyChangeListener {
        private Object oldValue;

        private ValueChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!BufferedValueModel.this.isBuffering()) {
                BufferedValueModel.this.fireValueChange(this.oldValue != null ? this.oldValue : propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue(), true);
            }
        }
    }

    private static final class ReadAccessResult {
        private final Object value;
        private final boolean readable;

        private ReadAccessResult(Object object, boolean bl) {
            this.value = object;
            this.readable = bl;
        }
    }
}

