/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.Animation;
import com.jgoodies.animation.AnimationEvent;
import com.jgoodies.animation.AnimationListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractAnimation
implements Animation {
    private final long duration;
    private final boolean freezed;
    private final List listenerList = new LinkedList();
    private boolean active = false;

    protected AbstractAnimation(long l) {
        this(l, false);
    }

    protected AbstractAnimation(long l, boolean bl) {
        this.duration = l;
        this.freezed = bl;
    }

    public final long duration() {
        return this.duration;
    }

    public final boolean isFreezed() {
        return this.freezed;
    }

    protected abstract void applyEffect(long var1);

    public void animate(long l) {
        if (l >= this.duration) {
            if (this.active) {
                this.applyEffect(this.isFreezed() ? this.duration - 1L : 0L);
                this.fireAnimationStopped(l);
                this.active = false;
            }
            return;
        }
        if (!this.active) {
            this.active = true;
            this.fireAnimationStarted(l);
        }
        this.applyEffect(l);
    }

    public final void addAnimationListener(AnimationListener animationListener) {
        this.listenerList.add(animationListener);
    }

    public final void removeAnimationListener(AnimationListener animationListener) {
        this.listenerList.remove(animationListener);
    }

    protected final void fireAnimationStarted(long l) {
        AnimationEvent animationEvent = new AnimationEvent(this, AnimationEvent.STARTED, l);
        Iterator iterator = this.listenerList.iterator();
        while (iterator.hasNext()) {
            AnimationListener animationListener = (AnimationListener)iterator.next();
            animationListener.animationStarted(animationEvent);
        }
    }

    protected final void fireAnimationStopped(long l) {
        AnimationEvent animationEvent = new AnimationEvent(this, AnimationEvent.STOPPED, l);
        Iterator iterator = this.listenerList.iterator();
        while (iterator.hasNext()) {
            AnimationListener animationListener = (AnimationListener)iterator.next();
            animationListener.animationStopped(animationEvent);
        }
    }

    public String toString() {
        return "[" + this.getClass().getName() + "; duration=" + this.duration + "; active=" + this.active + 93;
    }
}

