/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.AbstractAnimationFunction;
import com.jgoodies.animation.AnimationFunction;
import java.awt.Color;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public final class AnimationFunctions {
    public static final AnimationFunction ONE = AnimationFunctions.constant(Integer.MAX_VALUE, new Float(1.0f));
    public static final AnimationFunction ZERO = AnimationFunctions.constant(Integer.MAX_VALUE, new Float(0.0f));

    private AnimationFunctions() {
    }

    public static AnimationFunction alphaColor(AnimationFunction animationFunction, Color color) {
        return new AlphaColorAnimationFunction(animationFunction, color);
    }

    public static FloatFunction asFloat(AnimationFunction animationFunction) {
        return new FloatFunction(animationFunction);
    }

    public static AnimationFunction concat(AnimationFunction animationFunction, AnimationFunction animationFunction2) {
        LinkedList<AnimationFunction> linkedList = new LinkedList<AnimationFunction>();
        linkedList.add(animationFunction);
        linkedList.add(animationFunction2);
        return new SequencedAnimationFunction(linkedList);
    }

    public static AnimationFunction constant(long l, Object object) {
        return AnimationFunctions.discrete(l, new Object[]{object});
    }

    public static AnimationFunction discrete(long l, Object[] objectArray) {
        return AnimationFunctions.discrete(l, objectArray, null);
    }

    public static AnimationFunction discrete(long l, Object[] objectArray, float[] fArray) {
        return new InterpolatedAnimationFunction(l, objectArray, fArray, 1);
    }

    public static AnimationFunction fromBy(long l, float f, float f2) {
        return AnimationFunctions.fromTo(l, f, f + f2);
    }

    public static AnimationFunction fromTo(long l, float f, float f2) {
        return AnimationFunctions.linear(l, new Float[]{new Float(f), new Float(f2)});
    }

    public static AnimationFunction linear(long l, Object[] objectArray) {
        return AnimationFunctions.linear(l, objectArray, null);
    }

    public static AnimationFunction linear(long l, Object[] objectArray, float[] fArray) {
        return new InterpolatedAnimationFunction(l, objectArray, fArray, 2);
    }

    public static AnimationFunction linearColors(long l, Color[] colorArray, float[] fArray) {
        return new ColorFunction(l, colorArray, fArray);
    }

    public static AnimationFunction random(int n, int n2, float f) {
        return new RandomAnimationFunction(n, n2, f);
    }

    public static AnimationFunction repeat(AnimationFunction animationFunction, long l) {
        return new RepeatedAnimationFunction(animationFunction, l);
    }

    public static AnimationFunction reverse(AnimationFunction animationFunction) {
        return new ReversedAnimationFunction(animationFunction);
    }

    private static class SequencedAnimationFunction
    implements AnimationFunction {
        private final List functions;

        private SequencedAnimationFunction(List list) {
            this.functions = Collections.unmodifiableList(list);
            if (this.functions.isEmpty()) {
                throw new IllegalArgumentException("The list of functions must not be empty.");
            }
        }

        public long duration() {
            long l = 0L;
            Iterator iterator = this.functions.iterator();
            while (iterator.hasNext()) {
                AnimationFunction animationFunction = (AnimationFunction)iterator.next();
                l += animationFunction.duration();
            }
            return l;
        }

        public Object valueAt(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException("The time must be positive.");
            }
            long l2 = 0L;
            Iterator iterator = this.functions.iterator();
            while (iterator.hasNext()) {
                AnimationFunction animationFunction = (AnimationFunction)iterator.next();
                long l3 = l2 + animationFunction.duration();
                if (l < l3) {
                    return animationFunction.valueAt(l - l2);
                }
                l2 = l3;
            }
            throw new IllegalArgumentException("The time must be smaller than the total duration.");
        }
    }

    private static class ReversedAnimationFunction
    extends AbstractAnimationFunction {
        private final AnimationFunction f;

        private ReversedAnimationFunction(AnimationFunction animationFunction) {
            super(animationFunction.duration());
            this.f = animationFunction;
        }

        public Object valueAt(long l) {
            return this.f.valueAt(this.duration() - l);
        }
    }

    private static class RepeatedAnimationFunction
    extends AbstractAnimationFunction {
        private final AnimationFunction f;
        private final long simpleDuration;

        private RepeatedAnimationFunction(AnimationFunction animationFunction, long l) {
            super(l);
            this.f = animationFunction;
            this.simpleDuration = animationFunction.duration();
        }

        public Object valueAt(long l) {
            return this.f.valueAt(l % this.simpleDuration);
        }
    }

    private static class RandomAnimationFunction
    implements AnimationFunction {
        private final float changeProbability;
        private final int max;
        private final int min;
        private final Random random = new Random();
        private Object value;

        private RandomAnimationFunction(int n, int n2, float f) {
            this.min = n;
            this.max = n2;
            this.changeProbability = f;
        }

        public long duration() {
            return Integer.MAX_VALUE;
        }

        public Object valueAt(long l) {
            if (this.value == null || this.random.nextFloat() < this.changeProbability) {
                this.value = new Integer(this.min + this.random.nextInt(this.max - this.min));
            }
            return this.value;
        }
    }

    private static class InterpolatedAnimationFunction
    extends AbstractAnimationFunction {
        static final int MODE_DISCRETE = 1;
        static final int MODE_LINEAR = 2;
        private final float[] keyTimes;
        private final int mode;
        private final Object[] values;

        private InterpolatedAnimationFunction(long l, Object[] objectArray, float[] fArray, int n) {
            super(l);
            this.values = objectArray;
            this.keyTimes = fArray;
            this.mode = n;
            this.checkValidKeyTimes(objectArray.length, fArray);
        }

        private void checkValidKeyTimes(int n, float[] fArray) {
            if (fArray == null) {
                return;
            }
            if (n < 2 || n != fArray.length) {
                throw new IllegalArgumentException("The values and key times arrays must be non-empty and must have equal length.");
            }
            for (int i = 0; i < fArray.length - 2; ++i) {
                if (!(fArray[i] >= fArray[i + 1])) continue;
                throw new IllegalArgumentException("The key times must be increasing.");
            }
        }

        private Object discreteValueAt(long l) {
            return this.values[this.indexAt(l, this.values.length)];
        }

        private int indexAt(long l, int n) {
            long l2 = this.duration();
            if (this.keyTimes == null) {
                return (int)(l * (long)n / l2);
            }
            for (int i = this.keyTimes.length - 1; i > 0; --i) {
                if (!((float)l > (float)l2 * this.keyTimes[i])) continue;
                return i;
            }
            return 0;
        }

        private Object interpolateLinear(Object object, Object object2, long l, long l2) {
            float f = ((Number)object).floatValue();
            float f2 = ((Number)object2).floatValue();
            float f3 = f + (f2 - f) * (float)l / (float)l2;
            return new Float(f3);
        }

        private Object linearValueAt(long l) {
            int n = this.values.length - 1;
            int n2 = this.indexAt(l, n);
            int n3 = n2 + 1;
            long l2 = this.duration() - 1L;
            long l3 = this.keyTimes == null ? (long)n2 * l2 / (long)n : (long)(this.keyTimes[n2] * (float)l2);
            long l4 = this.keyTimes == null ? (long)n3 * l2 / (long)n : (long)(this.keyTimes[n3] * (float)l2);
            return this.interpolateLinear(this.values[n2], this.values[n3], l - l3, l4 - l3);
        }

        public Object valueAt(long l) {
            this.checkTimeRange(l);
            switch (this.mode) {
                case 1: {
                    return this.discreteValueAt(l);
                }
                case 2: {
                    return this.linearValueAt(l);
                }
            }
            throw new IllegalStateException("Unsupported interpolation mode.");
        }
    }

    public static class FloatFunction {
        private final AnimationFunction f;

        FloatFunction(AnimationFunction animationFunction) {
            this.f = animationFunction;
        }

        public long duration() {
            return this.f.duration();
        }

        public float valueAt(long l) {
            return ((Number)this.f.valueAt(l)).floatValue();
        }
    }

    private static class ColorFunction
    extends AbstractAnimationFunction {
        private final FloatFunction redFunction;
        private final FloatFunction greenFunction;
        private final FloatFunction blueFunction;
        private final FloatFunction alphaFunction;

        private ColorFunction(long l, Color[] colorArray, float[] fArray) {
            super(l);
            Object[] objectArray = new Float[colorArray.length];
            Object[] objectArray2 = new Float[colorArray.length];
            Object[] objectArray3 = new Float[colorArray.length];
            Object[] objectArray4 = new Float[colorArray.length];
            for (int i = 0; i < colorArray.length; ++i) {
                objectArray[i] = new Float(colorArray[i].getRed());
                objectArray2[i] = new Float(colorArray[i].getGreen());
                objectArray3[i] = new Float(colorArray[i].getBlue());
                objectArray4[i] = new Float(colorArray[i].getAlpha());
            }
            this.redFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(l, objectArray, fArray));
            this.greenFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(l, objectArray2, fArray));
            this.blueFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(l, objectArray3, fArray));
            this.alphaFunction = AnimationFunctions.asFloat(AnimationFunctions.linear(l, objectArray4, fArray));
        }

        public Object valueAt(long l) {
            return this.colorValueAt(l);
        }

        private Color colorValueAt(long l) {
            this.checkTimeRange(l);
            return new Color((int)this.redFunction.valueAt(l), (int)this.greenFunction.valueAt(l), (int)this.blueFunction.valueAt(l), (int)this.alphaFunction.valueAt(l));
        }
    }

    private static class AlphaColorAnimationFunction
    implements AnimationFunction {
        private final Color baseColor;
        private final AnimationFunction fAlpha;

        private AlphaColorAnimationFunction(AnimationFunction animationFunction, Color color) {
            this.fAlpha = animationFunction;
            this.baseColor = color;
        }

        public long duration() {
            return this.fAlpha.duration();
        }

        public Object valueAt(long l) {
            return new Color(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), ((Float)this.fAlpha.valueAt(l)).intValue());
        }
    }
}

