/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.Animation;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class Animations {
    private Animations() {
    }

    public static Animation offset(long l, Animation animation) {
        return new OffsetAnimation(l, animation);
    }

    public static Animation parallel(List list) {
        return new ParallelAnimation(list);
    }

    public static Animation parallel(Animation animation, Animation animation2) {
        LinkedList<Animation> linkedList = new LinkedList<Animation>();
        linkedList.add(animation);
        linkedList.add(animation2);
        return Animations.parallel(linkedList);
    }

    public static Animation pause(long l) {
        return new PauseAnimation(l);
    }

    public static Animation repeat(float f, Animation animation) {
        long l = (long)((float)animation.duration() * f);
        return new RepeatedAnimation(l, animation);
    }

    public static Animation reverse(Animation animation) {
        return new ReversedAnimation(animation);
    }

    public static Animation sequential(List list) {
        return new SequencedAnimation(list);
    }

    public static Animation sequential(Animation[] animationArray) {
        return Animations.sequential(Arrays.asList(animationArray));
    }

    public static Animation sequential(Animation animation, Animation animation2) {
        LinkedList<Animation> linkedList = new LinkedList<Animation>();
        linkedList.add(animation);
        linkedList.add(animation2);
        return Animations.sequential(linkedList);
    }

    private static class SequencedAnimation
    extends AbstractAnimation {
        private final List animations;

        private SequencedAnimation(List list) {
            super(SequencedAnimation.cumulatedDuration(list), true);
            this.animations = Collections.unmodifiableList(list);
            if (this.animations.isEmpty()) {
                throw new IllegalArgumentException("The list of animations must not be empty.");
            }
        }

        private static long cumulatedDuration(List list) {
            long l = 0L;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Animation animation = (Animation)iterator.next();
                l += animation.duration();
            }
            return l;
        }

        protected void applyEffect(long l) {
            long l2 = 0L;
            Iterator iterator = this.animations.iterator();
            while (iterator.hasNext()) {
                Animation animation = (Animation)iterator.next();
                long l3 = l - l2;
                if (l3 > 0L) {
                    animation.animate(l3);
                }
                l2 += animation.duration();
            }
        }
    }

    private static class ReversedAnimation
    extends AbstractAnimation {
        private final Animation animation;

        private ReversedAnimation(Animation animation) {
            super(animation.duration(), true);
            this.animation = animation;
        }

        protected void applyEffect(long l) {
            long l2 = this.duration() - l;
            if (l2 < 0L) {
                throw new IllegalArgumentException("The time is outside the valid time interval.");
            }
            this.animation.animate(l2);
        }
    }

    private static class RepeatedAnimation
    extends AbstractAnimation {
        private final Animation animation;
        private final long simpleDuration;

        private RepeatedAnimation(long l, Animation animation) {
            super(l, true);
            this.animation = animation;
            this.simpleDuration = animation.duration();
        }

        protected void applyEffect(long l) {
            this.animation.animate(l % this.simpleDuration);
        }
    }

    private static class PauseAnimation
    extends AbstractAnimation {
        PauseAnimation(long l) {
            super(l, true);
        }

        protected void applyEffect(long l) {
        }
    }

    private static class ParallelAnimation
    extends AbstractAnimation {
        private final List animations;

        private ParallelAnimation(List list) {
            super(ParallelAnimation.maxDuration(list), true);
            this.animations = list;
        }

        private static long maxDuration(List list) {
            long l = 0L;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Animation animation = (Animation)iterator.next();
                long l2 = animation.duration();
                if (l2 <= l) continue;
                l = l2;
            }
            return l;
        }

        protected void applyEffect(long l) {
            Iterator iterator = this.animations.iterator();
            while (iterator.hasNext()) {
                Animation animation = (Animation)iterator.next();
                animation.animate(l);
            }
        }
    }

    public static abstract class OneTimeAnimation
    extends AbstractAnimation {
        private boolean effectApplied = false;

        public OneTimeAnimation() {
            super(0L, true);
        }

        public void animate(long l) {
            if (this.effectApplied) {
                return;
            }
            this.fireAnimationStarted(l);
            this.applyEffect(l);
            this.fireAnimationStopped(l);
            this.effectApplied = true;
        }
    }

    private static class OffsetAnimation
    extends AbstractAnimation {
        private final Animation animation;
        private final long beginTime;

        private OffsetAnimation(long l, Animation animation) {
            super(l + animation.duration(), true);
            this.animation = animation;
            this.beginTime = l;
        }

        protected void applyEffect(long l) {
            long l2 = l - this.beginTime;
            if (l2 >= 0L) {
                this.animation.animate(l2);
            }
        }
    }
}

