/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation;

import com.jgoodies.animation.Animation;
import com.jgoodies.animation.AnimationAdapter;
import com.jgoodies.animation.AnimationEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public final class Animator
implements ActionListener {
    private final Animation animation;
    private final Timer timer;
    private final int framesPerSecond;
    private long startTime;
    private long elapsedTime = 0L;

    public Animator(Animation animation, int n) {
        if (animation == null) {
            throw new NullPointerException("The animation must not be null.");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("The frame rate must be positive.");
        }
        this.animation = animation;
        this.framesPerSecond = n;
        this.timer = this.createTimer(n);
    }

    public Animation animation() {
        return this.animation;
    }

    public int framesPerSecond() {
        return this.framesPerSecond;
    }

    public long elapsedTime() {
        return this.timer.isRunning() ? System.currentTimeMillis() - this.startTime + this.elapsedTime : this.elapsedTime;
    }

    public void start() {
        if (!this.timer.isRunning()) {
            this.registerStopListener();
            this.startTime = System.currentTimeMillis();
            this.timer.start();
        }
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.elapsedTime = this.elapsedTime();
            this.timer.stop();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.animation.animate(this.elapsedTime());
    }

    public String toString() {
        return "elapsedTime=" + this.elapsedTime() + "; fps=" + this.framesPerSecond;
    }

    private Timer createTimer(int n) {
        int n2 = 1000 / n;
        Timer timer = new Timer(n2, this);
        timer.setInitialDelay(0);
        timer.setCoalesce(true);
        return timer;
    }

    private void registerStopListener() {
        this.animation.addAnimationListener(new AnimationAdapter(){

            public void animationStopped(AnimationEvent animationEvent) {
                Animator.this.stop();
            }
        });
    }
}

