/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.animations;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.components.BasicTextLabel;
import java.awt.Color;

public final class BasicTextAnimation
extends AbstractAnimation {
    private final BasicTextLabel label;
    private final String text;
    private final AnimationFunction colorFunction;
    private final AnimationFunctions.FloatFunction offsetFunction;
    private final AnimationFunctions.FloatFunction scaleXFunction;
    private final AnimationFunctions.FloatFunction scaleYFunction;
    private final AnimationFunctions.FloatFunction spaceFunction;
    private boolean offsetEnabled = false;

    public BasicTextAnimation(BasicTextLabel basicTextLabel, long l, String string, AnimationFunction animationFunction, AnimationFunction animationFunction2, AnimationFunction animationFunction3, AnimationFunction animationFunction4) {
        super(l);
        this.label = basicTextLabel;
        this.text = string;
        this.colorFunction = animationFunction != null ? animationFunction : BasicTextAnimation.defaultFadeColorFunction(l, Color.darkGray);
        this.scaleXFunction = AnimationFunctions.asFloat(animationFunction2 != null ? animationFunction2 : AnimationFunctions.ONE);
        this.scaleYFunction = AnimationFunctions.asFloat(animationFunction3 != null ? animationFunction3 : AnimationFunctions.ONE);
        this.spaceFunction = AnimationFunctions.asFloat(animationFunction4 != null ? animationFunction4 : AnimationFunctions.ZERO);
        this.offsetFunction = AnimationFunctions.asFloat(BasicTextAnimation.defaultOffsetFunction());
    }

    public static BasicTextAnimation defaultFade(BasicTextLabel basicTextLabel, long l, String string, Color color) {
        return new BasicTextAnimation(basicTextLabel, l, string, BasicTextAnimation.cinemaFadeColorFunction(l, color), null, null, null);
    }

    public static BasicTextAnimation defaultScale(BasicTextLabel basicTextLabel, long l, String string, Color color) {
        return new BasicTextAnimation(basicTextLabel, l, string, BasicTextAnimation.defaultScaleColorFunction(l, color), BasicTextAnimation.defaultScaleFunction(l), BasicTextAnimation.defaultScaleFunction(l), null);
    }

    public static BasicTextAnimation defaultSpace(BasicTextLabel basicTextLabel, long l, String string, Color color) {
        return new BasicTextAnimation(basicTextLabel, l, string, BasicTextAnimation.defaultSpaceColorFunction(l, color), null, null, BasicTextAnimation.defaultSpaceFunction(l));
    }

    public static AnimationFunction defaultFadeColorFunction(long l, Color color) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(l, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.3f, 0.7f, 1.0f}), color);
    }

    public static AnimationFunction cinemaFadeColorFunction(long l, Color color) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(l, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.3f, 0.85f, 1.0f}), color);
    }

    public static AnimationFunction defaultScaleColorFunction(long l, Color color) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(l, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.2f, 0.85f, 1.0f}), color);
    }

    public static AnimationFunction defaultSpaceColorFunction(long l, Color color) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(l, new Integer[]{new Integer(0), new Integer(255), new Integer(255), new Integer(0)}, new float[]{0.0f, 0.2f, 0.8f, 1.0f}), color);
    }

    public static AnimationFunction defaultOffsetFunction() {
        return AnimationFunctions.random(-2, 2, 0.5f);
    }

    public static AnimationFunction defaultScaleFunction(long l) {
        return AnimationFunctions.linear(l, new Float[]{new Float(1.0f), new Float(1.0f), new Float(1.8f)}, new float[]{0.0f, 0.85f, 1.0f});
    }

    public static AnimationFunction defaultSpaceFunction(long l) {
        return AnimationFunctions.fromTo(l, 0.0f, 10.0f);
    }

    protected void applyEffect(long l) {
        this.label.setText(l == 0L ? " " : this.text);
        this.label.setColor((Color)this.colorFunction.valueAt(l));
        this.label.setScaleX(this.scaleXFunction.valueAt(l));
        this.label.setScaleY(this.scaleYFunction.valueAt(l));
        this.label.setSpace(this.spaceFunction.valueAt(l));
        if (this.isOffsetEnabled()) {
            this.label.setOffsetX(this.offsetFunction.valueAt(l));
            this.label.setOffsetY(this.offsetFunction.valueAt(l));
        }
    }

    public boolean isOffsetEnabled() {
        return this.offsetEnabled;
    }

    public void setOffsetEnabled(boolean bl) {
        this.offsetEnabled = bl;
    }
}

