/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.animations;

import com.jgoodies.animation.Animation;
import com.jgoodies.animation.AnimationUtils;
import com.jgoodies.animation.Animations;
import com.jgoodies.animation.animations.BasicTextAnimation;
import com.jgoodies.animation.components.BasicTextLabel;
import java.awt.Color;
import java.util.LinkedList;

public final class BasicTextAnimations {
    private static final int FADE_TYPE = 0;
    private static final int SCALE_TYPE = 1;
    private static final int SPACE_TYPE = 2;

    private BasicTextAnimations() {
    }

    public static Animation defaultFade(BasicTextLabel basicTextLabel, BasicTextLabel basicTextLabel2, long l, long l2, String string, Color color) {
        return BasicTextAnimations.createTextSequence(basicTextLabel, basicTextLabel2, l, l2, string, color, 0);
    }

    public static Animation defaultScale(BasicTextLabel basicTextLabel, BasicTextLabel basicTextLabel2, long l, long l2, String string, Color color) {
        return BasicTextAnimations.createTextSequence(basicTextLabel, basicTextLabel2, l, l2, string, color, 1);
    }

    public static Animation defaultSpace(BasicTextLabel basicTextLabel, BasicTextLabel basicTextLabel2, long l, long l2, String string, Color color) {
        return BasicTextAnimations.createTextSequence(basicTextLabel, basicTextLabel2, l, l2, string, color, 2);
    }

    private static Animation createTextSequence(BasicTextLabel basicTextLabel, BasicTextLabel basicTextLabel2, long l, long l2, String string, Color color, int n) {
        String[] stringArray = AnimationUtils.splitTexts(string);
        LinkedList<Animation> linkedList = new LinkedList<Animation>();
        long l3 = 0L;
        BasicTextLabel basicTextLabel3 = basicTextLabel;
        for (int i = 0; i < stringArray.length; ++i) {
            basicTextLabel3 = i % 2 == 0 ? basicTextLabel : basicTextLabel2;
            Animation animation = BasicTextAnimations.animation(basicTextLabel3, l, stringArray[i], color, n);
            linkedList.add(Animations.offset(l3, animation));
            l3 += l + l2;
        }
        return Animations.parallel(linkedList);
    }

    private static Animation animation(BasicTextLabel basicTextLabel, long l, String string, Color color, int n) {
        switch (n) {
            case 0: {
                return BasicTextAnimation.defaultFade(basicTextLabel, l, string, color);
            }
            case 1: {
                return BasicTextAnimation.defaultScale(basicTextLabel, l, string, color);
            }
            case 2: {
                return BasicTextAnimation.defaultSpace(basicTextLabel, l, string, color);
            }
        }
        return null;
    }
}

