/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.animations;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.components.FanComponent;

public final class FanAnimation
extends AbstractAnimation {
    public static final double DEFAULT_CLOCKWISE_ROTATION = 0.01;
    public static final double DEFAULT_ANTICLOCKWISE_ROTATION = -0.02;
    private final FanComponent fan;
    private final AnimationFunctions.FloatFunction rotationFunction;

    public FanAnimation(FanComponent fanComponent, long l, AnimationFunction animationFunction) {
        super(l);
        this.fan = fanComponent;
        this.rotationFunction = AnimationFunctions.asFloat(animationFunction != null ? animationFunction : FanAnimation.defaultRotationFunction(l));
    }

    public static FanAnimation defaultFan(FanComponent fanComponent, long l) {
        return new FanAnimation(fanComponent, l, null);
    }

    public static AnimationFunction defaultRotationFunction(long l) {
        return AnimationFunctions.fromTo(l, 0.0f, (float)Math.PI * 2);
    }

    protected void applyEffect(long l) {
        this.fan.setRotation(this.rotationFunction.valueAt(l));
    }
}

