/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import com.jgoodies.animation.AbstractAnimation;
import com.jgoodies.animation.Animation;
import com.jgoodies.animation.AnimationAdapter;
import com.jgoodies.animation.AnimationEvent;
import com.jgoodies.animation.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.RenderingHints;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.FontUIResource;

public final class AnimatedLabel
extends JPanel {
    public static final int RIGHT = 4;
    public static final int CENTER = 0;
    public static final int LEFT = 2;
    public static final Color DEFAULT_BASE_COLOR = new Color(64, 64, 64);
    public static final int DEFAULT_FONT_EXTRA_SIZE = 8;
    private static final int DEFAULT_DURATION = 300;
    private static final int DEFAULT_ANIMATION_FPS = 30;
    private JLabel[] labels;
    private int foreground = 0;
    private int background = 1;
    private Color baseColor;
    private boolean animationEnabled;
    private int orientation;
    private long duration;
    private int fps;
    private Animation animation;

    public AnimatedLabel(Color color, int n, String string, int n2, int n3, int n4) {
        this.baseColor = color;
        this.orientation = n2;
        this.duration = n3;
        this.fps = n4;
        this.animationEnabled = true;
        this.initComponents(n);
        this.build();
        this.setTextImmediately(string);
    }

    public AnimatedLabel(Color color, int n, String string, int n2) {
        this(color, n, string, n2, 300, 30);
    }

    public AnimatedLabel(Color color, int n, String string) {
        this(color, n, string, 2);
    }

    public AnimatedLabel() {
        this(DEFAULT_BASE_COLOR, 8, "");
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean bl) {
        boolean bl2 = this.animationEnabled;
        this.animationEnabled = bl;
        this.firePropertyChange("animationEnabled", bl2, bl);
    }

    public Color getForeground() {
        return this.baseColor;
    }

    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        this.baseColor = color;
        this.firePropertyChange("foreground", color2, color);
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(int n) {
        long l = this.duration;
        this.duration = n;
        this.animation = null;
        this.firePropertyChange("duration", l, (long)n);
    }

    public synchronized String getText() {
        return this.labels[this.foreground].getText();
    }

    public synchronized void setText(String string) {
        if (!this.isAnimationEnabled()) {
            this.setTextImmediately(string);
            return;
        }
        String string2 = this.getText();
        this.labels[this.background].setText(string);
        this.foreground = 1 - this.foreground;
        this.background = 1 - this.background;
        new Animator(this.animation(), this.fps).start();
        this.firePropertyChange("text", string2, string);
    }

    public void setTextImmediately(String string) {
        String string2 = this.getText();
        this.labels[this.background].setText(string);
        this.foreground = 1 - this.foreground;
        this.background = 1 - this.background;
        this.setAlpha(255, 0);
        this.firePropertyChange("text", string2, string);
    }

    private Animation animation() {
        if (this.animation == null) {
            this.animation = new BlendOverAnimation(this.duration);
            this.animation.addAnimationListener(new AnimationAdapter(){

                public void animationStopped(AnimationEvent animationEvent) {
                    AnimatedLabel.this.setAlpha(255, 0);
                }
            });
        }
        return this.animation;
    }

    private void initComponents(int n) {
        this.labels = new JLabel[2];
        this.labels[this.foreground] = this.createBoldLabel(n, this.getTranslucentColor(255));
        this.labels[this.background] = this.createBoldLabel(n, this.getTranslucentColor(255));
    }

    private void build() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = this.anchor();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.labels[this.foreground], gridBagConstraints);
        this.add((Component)this.labels[this.background], gridBagConstraints);
    }

    private int anchor() {
        if (this.orientation == 4) {
            return 13;
        }
        if (this.orientation == 0) {
            return 10;
        }
        return 17;
    }

    private JLabel createBoldLabel(int n, Color color) {
        AntiAliasedLabel antiAliasedLabel = new AntiAliasedLabel("", 1, n);
        antiAliasedLabel.setForeground(color);
        return antiAliasedLabel;
    }

    private Color getTranslucentColor(int n) {
        return new Color(this.baseColor.getRed(), this.baseColor.getGreen(), this.baseColor.getBlue(), n);
    }

    private void setAlpha0(int n, int n2) {
        this.labels[this.foreground].setForeground(this.getTranslucentColor(n));
        this.labels[this.background].setForeground(this.getTranslucentColor(n2));
    }

    private void setAlpha(final int n, final int n2) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.setAlpha0(n, n2);
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                AnimatedLabel.this.setAlpha0(n, n2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private static class AntiAliasedLabel
    extends JLabel {
        private final int fontExtraSize;
        private final int fontStyle;

        private AntiAliasedLabel(String string, int n, int n2) {
            super(string);
            this.fontStyle = n;
            this.fontExtraSize = n2;
            this.updateUI();
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            super.paint(graphics2D);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        }

        public void updateUI() {
            super.updateUI();
            Font font = this.getFont();
            if (0 == this.fontExtraSize) {
                if (font.getStyle() != this.fontStyle) {
                    this.setFont(new FontUIResource(font.deriveFont(this.fontStyle)));
                }
            } else {
                this.setFont(new FontUIResource(new Font(font.getName(), this.fontStyle, font.getSize() + this.fontExtraSize)));
            }
        }
    }

    private class BlendOverAnimation
    extends AbstractAnimation {
        public BlendOverAnimation(long l) {
            super(l, true);
        }

        protected void applyEffect(long l) {
            int n = (int)(255L * l / this.duration());
            int n2 = 255 - n;
            AnimatedLabel.this.setAlpha(n, n2);
        }
    }
}

