/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import com.jgoodies.animation.renderer.BasicTextRenderer;
import com.jgoodies.animation.renderer.HeightMode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class BasicTextLabel
extends JComponent {
    private final BasicTextRenderer renderer;

    public BasicTextLabel(String string) {
        this.renderer = new BasicTextRenderer(string);
    }

    public Color getColor() {
        return this.renderer.getColor();
    }

    public HeightMode getHeightMode() {
        return this.renderer.getHeightMode();
    }

    public float getScaleX() {
        return this.renderer.getScaleX();
    }

    public float getScaleY() {
        return this.renderer.getScaleY();
    }

    public float getSpace() {
        return this.renderer.getSpace();
    }

    public float getOffsetX() {
        return this.renderer.getOffsetX();
    }

    public float getOffsetY() {
        return this.renderer.getOffsetY();
    }

    public String getText() {
        return this.renderer.getText();
    }

    public void setColor(Color color) {
        this.renderer.setColor(color);
        this.repaint();
    }

    public void setHeightMode(HeightMode heightMode) {
        this.renderer.setHeightMode(heightMode);
    }

    public void setScale(float f) {
        this.renderer.setScaleX(f);
        this.renderer.setScaleY(f);
        this.repaint();
    }

    public void setScaleX(float f) {
        this.renderer.setScaleX(f);
        this.repaint();
    }

    public void setScaleY(float f) {
        this.renderer.setScaleY(f);
        this.repaint();
    }

    public void setSpace(float f) {
        this.renderer.setSpace(f);
        this.repaint();
    }

    public void setOffsetX(float f) {
        this.renderer.setOffsetX(f);
        this.repaint();
    }

    public void setOffsetY(float f) {
        this.renderer.setOffsetY(f);
        this.repaint();
    }

    public void setText(String string) {
        this.renderer.setText(string);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.renderer.setFont(this.getFont());
        this.renderer.render(graphics2D, this.getWidth(), this.getHeight());
    }
}

