/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class CircleComponent
extends JComponent {
    private Point center = new Point(0, 0);
    private int radius = 30;
    private Color color = Color.black;

    public void setCenter(Point point) {
        this.center = point;
    }

    public void setRadius(int n) {
        this.radius = n;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.setCenter(new Point(n + n3 / 2, n2 + n4 / 2));
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.radius * 2;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.color);
        graphics2D.setStroke(new BasicStroke(4.0f));
        graphics2D.drawOval(this.center.x - this.radius, this.center.y - this.radius, n, n);
    }
}

