/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import com.jgoodies.animation.renderer.FanRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JComponent;

public final class FanComponent
extends JComponent {
    private final FanRenderer renderer;

    public FanComponent(int n, Color color) {
        this.renderer = new FanRenderer(n, color);
    }

    public Point2D getOrigin() {
        return this.renderer.getOrigin();
    }

    public double getRotation() {
        return this.renderer.getRotation();
    }

    public void setOrigin(Point2D point2D) {
        this.renderer.setOrigin(point2D);
        this.repaint();
    }

    public void setRotation(double d) {
        this.renderer.setRotation(d);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = this.getWidth() - n - insets.right;
        int n4 = this.getHeight() - n2 - insets.bottom;
        graphics2D.translate(n, n2);
        this.renderer.render(graphics2D, n3, n4);
        graphics2D.translate(-n, -n2);
    }
}

