/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.components;

import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.renderer.GlyphRenderer;
import com.jgoodies.animation.renderer.HeightMode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public final class GlyphLabel
extends JComponent {
    private final GlyphRenderer renderer;

    public GlyphLabel(String string, long l, long l2) {
        this(string, l, l2, Color.darkGray);
    }

    public GlyphLabel(String string, long l, long l2, Color color) {
        this.renderer = new GlyphRenderer(string, GlyphLabel.defaultScaleFunction(l), AnimationFunctions.ZERO, GlyphLabel.defaultColorFunction(l, color), l2);
    }

    public static AnimationFunction defaultScaleFunction(long l) {
        return AnimationFunctions.linear(l, new Float[]{new Float(5.0f), new Float(0.8f), new Float(1.0f), new Float(1.0f)}, new float[]{0.0f, 0.1f, 0.12f, 1.0f});
    }

    public static AnimationFunction defaultColorFunction(long l, Color color) {
        return AnimationFunctions.alphaColor(AnimationFunctions.linear(l, new Integer[]{new Integer(0), new Integer(255), new Integer(255)}, new float[]{0.0f, 0.15f, 1.0f}), color);
    }

    public HeightMode getHeightMode() {
        return this.renderer.getHeightMode();
    }

    public String getText() {
        return this.renderer.getText();
    }

    public void setHeightMode(HeightMode heightMode) {
        this.renderer.setHeightMode(heightMode);
    }

    public void setText(String string) {
        this.renderer.setText(string);
        this.repaint();
    }

    public void setTime(long l) {
        this.renderer.setTime(l);
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.renderer.setFont(this.getFont());
        this.renderer.render(graphics2D, this.getWidth(), this.getHeight());
    }
}

