/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.old;

import com.jgoodies.animation.old.Animation;
import com.jgoodies.animation.old.Startable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JPanel;

public final class AnimatedPanel
extends JPanel
implements Runnable,
Startable {
    public static final int DEFAULT_FRAMES_PER_SECOND = 30;
    private final Animation animation;
    private final boolean repeat;
    private int fps_period;
    private long startTime;
    private Thread thread;
    private boolean listenersRegistered = false;
    private boolean wasRunningBeforeIconify;

    public AnimatedPanel(Animation animation, boolean bl) {
        super(null);
        this.animation = animation;
        this.repeat = bl;
        this.setFramesPerSecond(AnimatedPanel.getDefaultFramesPerSecond());
        this.setElapsedTime(-200L);
        this.setOpaque(false);
    }

    private static int getDefaultFramesPerSecond() {
        try {
            return Integer.parseInt(System.getProperty("animation.fps"));
        }
        catch (NumberFormatException numberFormatException) {
            return 30;
        }
    }

    public long getElapsedTime() {
        return System.currentTimeMillis() - this.startTime;
    }

    public void setElapsedTime(long l) {
        this.startTime = System.currentTimeMillis() - l;
    }

    private static Window getWindowAncestor(Component component) {
        if (component instanceof Window) {
            return (Window)component;
        }
        Container container = component.getParent();
        while (component != null) {
            if (container instanceof Window) {
                return (Window)container;
            }
            container = container.getParent();
        }
        return null;
    }

    public void paintChildren(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        this.animation.render(graphics2D, this.getWidth(), this.getHeight(), this.getElapsedTime());
    }

    private void initEventHandling() {
        this.listenersRegistered = true;
        Window window = AnimatedPanel.getWindowAncestor(this);
        window.addWindowListener(new WindowAdapter(){

            public void windowIconified(WindowEvent windowEvent) {
                AnimatedPanel.this.wasRunningBeforeIconify = AnimatedPanel.this.thread != null;
                if (AnimatedPanel.this.wasRunningBeforeIconify) {
                    AnimatedPanel.this.stop();
                }
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                if (AnimatedPanel.this.wasRunningBeforeIconify) {
                    AnimatedPanel.this.start();
                }
            }

            public void windowClosing(WindowEvent windowEvent) {
                AnimatedPanel.this.stop();
            }
        });
    }

    public void release() {
        this.animation.release();
    }

    public void reset() {
        this.startTime = System.currentTimeMillis();
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.thread == thread && !this.isShowing() || this.getSize().width == 0) {
            this.sleep(200L);
        }
        if (!this.listenersRegistered) {
            this.initEventHandling();
        }
        if (this.getElapsedTime() < 0L) {
            this.reset();
        }
        while (this.thread == thread && (this.repeat || this.getElapsedTime() < this.animation.getLength())) {
            long l = this.animation.getPause(this.getElapsedTime());
            if (l > 0L) {
                this.repaint();
                this.sleep(l);
            }
            long l2 = System.currentTimeMillis();
            this.repaint();
            long l3 = (long)this.fps_period - System.currentTimeMillis() + l2;
            if (l3 > 0L) {
                this.sleep(l3);
            }
            if (!this.repeat || this.getElapsedTime() <= this.animation.getLength()) continue;
            this.reset();
        }
        this.thread = null;
    }

    public void setFramesPerSecond(int n) {
        if (n == 0) {
            throw new IllegalArgumentException("Frames per second must be greater than 0.");
        }
        this.fps_period = 1000 / n;
    }

    private void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void start() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.setName("Animated Panel");
            this.thread.start();
        }
    }

    public synchronized void stop() {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.thread = null;
        this.notifyAll();
    }

    public ComponentListener createStartStopListener() {
        return new ComponentAdapter(){

            public void componentHidden(ComponentEvent componentEvent) {
                AnimatedPanel.this.stop();
            }

            public void componentShown(ComponentEvent componentEvent) {
                AnimatedPanel.this.start();
            }
        };
    }
}

