/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.old;

import com.jgoodies.animation.old.LinearTimeFunction;
import com.jgoodies.animation.old.TimeFunction;

public final class FunctionFactory {
    public static final long DEFAULT_LENGTH = 4500L;
    public static final String DEFAULT = "default";
    public static final String NONE = "none";
    public static final String BLEND_IN = "blend in";
    public static final String BLEND_OUT = "blend out";
    public static final String LIGHT = "light";
    public static final String LIGHT_OUT = "light out";
    public static final String FAST = "fast";
    public static final String EXTRA_FAST = "extra fast";
    public static final String WIDE = "wide";
    public static final String EXTRA_WIDE = "extra wide";
    public static final String CONDENSED = "condensed";
    public static final String REVERSED = "reversed";
    public static final String FAST_REVERSED = "fast reversed";
    public static final String EXPLODE = "explode";
    public static final String TO_FRONT = "toFront";
    public static final String TO_BACK = "toBack";
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    public static final String RIGHT = "right";
    public static final String SWING_LEFT = "swing left";
    public static final String SWING_CENTER = "swing center";
    public static final String SWING_RIGHT = "swing right";
    public static final float BRIGHTNESS_LIGHT = 0.7f;
    public static final float KERNING_START_DEFAULT = 0.0f;
    public static final float KERNING_STOP_DEFAULT = 6.0f;
    public static final float KERNING_START_CONDENSED = 0.0f;
    public static final float KERNING_STOP_CONDENSED = 3.5f;
    public static final float KERNING_START_WIDE = 2.0f;
    public static final float KERNING_STOP_WIDE = 9.0f;
    public static final float KERNING_START_WIDE_X = 5.0f;
    public static final float KERNING_STOP_WIDE_X = 15.0f;
    public static final float KERNING_START_FAST = 0.0f;
    public static final float KERNING_STOP_FAST = 9.0f;
    public static final float KERNING_START_FAST_X = 0.0f;
    public static final float KERNING_STOP_FAST_X = 13.0f;
    public static final float SCALE_START_DEFAULT = 0.8f;
    public static final float SCALE_STOP_DEFAULT = 1.15f;
    public static final float SCALE_START_TO_FRONT = 0.2f;
    public static final float SCALE_STOP_TO_FRONT = 1.0f;

    private FunctionFactory() {
    }

    public static float attenuation(long l) {
        return 1.0f / (1.0f + (float)(l * l) / 800000.0f);
    }

    public static TimeFunction createAlignmentDefault(long l, String string) {
        if (LEFT.equals(string)) {
            return LinearTimeFunction.createConstant(l, 0.0f);
        }
        if (RIGHT.equals(string)) {
            return LinearTimeFunction.createConstant(l, 1.0f);
        }
        if (SWING_LEFT.equals(string)) {
            return new OscillatingTimeFunction(l, 0.0f, 1.0f, 0.0f);
        }
        if (SWING_CENTER.equals(string)) {
            return new OscillatingTimeFunction(l, 0.0f, 1.0f, 0.5f);
        }
        if (SWING_RIGHT.equals(string)) {
            return new OscillatingTimeFunction(l, 0.0f, 1.0f, 1.0f);
        }
        return LinearTimeFunction.createConstant(l, 0.5f);
    }

    public static TimeFunction createBrightnessDefault() {
        return FunctionFactory.createBrightnessDefault(4500L, DEFAULT);
    }

    public static TimeFunction createBrightnessDefault(long l, String string) {
        if (NONE.equals(string)) {
            return LinearTimeFunction.createConstant(l, 0.0f);
        }
        if (LIGHT.equals(string)) {
            return LinearTimeFunction.createConstant(l, 0.7f);
        }
        if (BLEND_IN.equals(string)) {
            return new LinearTimeFunction(l, l, l, 1.0f, 0.0f, 0.0f);
        }
        if (BLEND_OUT.equals(string)) {
            return new LinearTimeFunction(l, l, l, 0.0f, 1.0f, 1.0f);
        }
        if (LIGHT_OUT.equals(string)) {
            return new LinearTimeFunction(l, l, l, 0.7f, 1.0f, 1.0f);
        }
        return new LinearTimeFunction(l / 2L, l * 3L / 4L, l, 1.0f, 0.0f, 1.0f);
    }

    public static TimeFunction createKerningDefault() {
        return FunctionFactory.createKerningDefault(4500L, DEFAULT);
    }

    public static LinearTimeFunction createKerningDefault(long l, String string) {
        if (NONE.equals(string)) {
            return LinearTimeFunction.createConstant(l, 0.0f);
        }
        if (CONDENSED.equals(string)) {
            return new LinearTimeFunction(l, l, 0.0f, 3.5f);
        }
        if (FAST.equals(string)) {
            return new LinearTimeFunction(l, l, 0.0f, 9.0f);
        }
        if (EXTRA_FAST.equals(string)) {
            return new LinearTimeFunction(l, l, 0.0f, 13.0f);
        }
        if (WIDE.equals(string)) {
            return new LinearTimeFunction(l, l, 2.0f, 9.0f);
        }
        if (EXTRA_WIDE.equals(string)) {
            return new LinearTimeFunction(l, l, 5.0f, 15.0f);
        }
        if (REVERSED.equals(string)) {
            return new LinearTimeFunction(l, l, 6.0f, 0.0f);
        }
        if (FAST_REVERSED.equals(string)) {
            return new LinearTimeFunction(l, l, 9.0f, 0.0f);
        }
        if (EXPLODE.equals(string)) {
            return new LinearTimeFunction(l * 2L / 3L, l * 2L / 3L, l, 0.0f, 0.0f, 13.0f);
        }
        return new LinearTimeFunction(l, l, 0.0f, 6.0f);
    }

    public static TimeFunction createScaleDefault() {
        return FunctionFactory.createScaleDefault(4500L, DEFAULT);
    }

    public static LinearTimeFunction createScaleDefault(long l, String string) {
        if (NONE.equals(string)) {
            return LinearTimeFunction.createConstant(l, 1.0f);
        }
        if (TO_FRONT.equals(string)) {
            return new LinearTimeFunction(l, l, 0.2f, 1.0f);
        }
        if (TO_BACK.equals(string)) {
            return new LinearTimeFunction(l, l, 1.0f, 0.2f);
        }
        return new LinearTimeFunction(l, l, 0.8f, 1.15f);
    }

    public static float sawTooth(long l, float f, float f2) {
        float f3 = 1000.0f;
        float f4 = 2.0f * f3;
        return Math.abs(((float)l * f + f2 * f4) % f4 - f3) / f3;
    }

    public static float sinus(long l, float f, float f2) {
        return (1.0f + (float)Math.sin(((float)l * f / 1000.0f + f2) * ((float)Math.PI * 2))) / 2.0f;
    }

    private static class OscillatingTimeFunction
    implements TimeFunction {
        public static final float DEFAULT_FREQUENCY = 1.0f;
        public static final float DEFAULT_PHASE_OFFSET = 0.25f;
        public static final float DEFAULT_ATTENUATION_FACTOR = 2.0f;
        private final long length;
        private final float min;
        private final float max;
        private final float positionOffset;
        private final float frequency;
        private final float phaseOffset;
        private final float attenuationFactor;

        OscillatingTimeFunction(long l, float f, float f2, float f3) {
            this(l, f, f2, f3, 1.0f, 0.25f, 2.0f);
        }

        private OscillatingTimeFunction(long l, float f, float f2, float f3, float f4, float f5, float f6) {
            this.length = l;
            this.min = f;
            this.max = f2;
            this.positionOffset = f3;
            this.frequency = f4;
            this.phaseOffset = f5;
            this.attenuationFactor = f6;
        }

        public long getLength() {
            return this.length;
        }

        public float getValue(long l) {
            float f = FunctionFactory.sinus(l, this.frequency, this.phaseOffset);
            float f2 = FunctionFactory.attenuation((long)((float)l * this.attenuationFactor));
            float f3 = f * f2 + this.positionOffset * (1.0f - f2);
            return this.min + (this.max - this.min) * f3;
        }
    }
}

