/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.old;

import com.jgoodies.animation.old.Animation;
import com.jgoodies.animation.old.FunctionFactory;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Random;

public final class MovingCurtains
implements Animation {
    public static final int SAW_TOOTH = 0;
    public static final int SINUS = 1;
    private final int numOfShapes;
    private final float speedFactor;
    private final Random random = new Random(System.currentTimeMillis());
    private int[] widths;
    private boolean hasValidCache = false;
    private int oscillationMode = 0;
    private float[] speeds;
    private float[] offsets;
    private int[] alphas;

    public MovingCurtains(int n, float f) {
        this.numOfShapes = n;
        this.speedFactor = f;
        this.initializeWidths(20, 100);
    }

    private void initializeWidths(int n, int n2) {
        this.widths = new int[this.numOfShapes];
        for (int i = 0; i < this.numOfShapes; ++i) {
            this.widths[i] = n + this.random.nextInt(n2 - n);
        }
    }

    private void ensureValidCache() {
        if (this.hasValidCache) {
            return;
        }
        this.initialize();
        this.hasValidCache = true;
    }

    private Color getBaseColor() {
        return this.getUIBaseColor();
    }

    private Color getDrawColor(int n) {
        Color color = this.getBaseColor();
        int n2 = Math.min(255, this.alphas[n] + 48);
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), n2);
    }

    private Color getFillColor(int n) {
        Color color = this.getBaseColor();
        return new Color(color.getRed(), color.getGreen(), color.getBlue(), this.alphas[n]);
    }

    public long getLength() {
        return -1L;
    }

    private float getOscillation(long l, float f, float f2) {
        return this.oscillationMode == 0 ? FunctionFactory.sawTooth(l, f, f2) : FunctionFactory.sinus(l, f, f2);
    }

    public long getPause(long l) {
        return -1L;
    }

    private Shape getShape(int n, int n2, int n3, long l) {
        int n4 = this.widths[n];
        float f = this.getOscillation(l, this.speeds[n] * this.speedFactor, this.offsets[n]) * (float)(n2 - 1 - n4);
        return new Rectangle2D.Float(f, -1.0f, n4, (float)n3 + 1.0f);
    }

    private Color getUIBaseColor() {
        return new Color(241, 159, 60);
    }

    private void initialize() {
        int n;
        this.speeds = new float[this.numOfShapes];
        this.offsets = new float[this.numOfShapes];
        for (n = 0; n < this.numOfShapes; ++n) {
            this.speeds[n] = 0.05f + 0.3f * this.random.nextFloat();
            this.offsets[n] = this.random.nextFloat();
        }
        this.alphas = new int[this.numOfShapes];
        for (n = 0; n < this.numOfShapes; ++n) {
            this.alphas[n] = 16 + this.random.nextInt(128);
        }
    }

    public void release() {
        this.hasValidCache = false;
        this.speeds = null;
        this.offsets = null;
        this.alphas = null;
    }

    public void render(Graphics2D graphics2D, int n, int n2, long l) {
        this.ensureValidCache();
        for (int i = 0; i < this.numOfShapes; ++i) {
            this.renderShape(graphics2D, i, n, n2, l);
        }
    }

    private void renderShape(Graphics2D graphics2D, int n, int n2, int n3, long l) {
        Shape shape = this.getShape(n, n2, n3, l);
        graphics2D.setColor(this.getFillColor(n));
        graphics2D.fill(shape);
        graphics2D.setColor(this.getDrawColor(n));
        graphics2D.draw(shape);
    }

    public void setOscillationMode(int n) {
        this.oscillationMode = n;
    }
}

