/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.old;

import com.jgoodies.animation.old.Animation;
import com.jgoodies.animation.old.FunctionFactory;
import com.jgoodies.animation.old.Pause;
import com.jgoodies.animation.old.TextSpacing;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class OverlayedAnimation
implements Animation {
    private final List allSequences = new ArrayList();
    private long length = 0L;

    private void add(Animation animation, long l) {
        OverlayedSequence overlayedSequence = new OverlayedSequence(animation, l);
        this.allSequences.add(overlayedSequence);
    }

    public void append(Animation animation, long l) {
        long l2 = this.length + l;
        this.add(animation, l2);
        if (l >= 0L && animation.getLength() != -1L) {
            this.length += l + animation.getLength();
        }
    }

    public static OverlayedAnimation createDefault(String[][] stringArray) {
        OverlayedAnimation overlayedAnimation = new OverlayedAnimation();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            String string = stringArray2[0];
            int n = OverlayedAnimation.stringToInt(stringArray2[1], 16);
            long l = OverlayedAnimation.stringToLong(stringArray2[2], 4500L);
            long l2 = OverlayedAnimation.stringToLong(stringArray2[3], 0L);
            String string2 = stringArray2[4];
            String string3 = stringArray2[5];
            String string4 = stringArray2[6];
            String string5 = stringArray2[7];
            String string6 = stringArray2[8];
            TextSpacing textSpacing = TextSpacing.createDefault(string, n, l, string2, string3, string4, string5, string6);
            overlayedAnimation.append(textSpacing, l2);
        }
        return overlayedAnimation;
    }

    public static OverlayedAnimation createDefault(String[] stringArray, int n, long l, long l2, String string, String string2, String string3, String string4) {
        Font font = new Font("dialog", 1, n);
        OverlayedAnimation overlayedAnimation = new OverlayedAnimation();
        for (int i = 0; i < stringArray.length; ++i) {
            TextSpacing textSpacing = new TextSpacing(stringArray[i], font, FunctionFactory.createBrightnessDefault(l, string), FunctionFactory.createKerningDefault(l, string2), FunctionFactory.createScaleDefault(l, string3), FunctionFactory.createAlignmentDefault(l, string4), true);
            if (i > 0 && l2 > 100L) {
                overlayedAnimation.append(textSpacing, 50L);
                overlayedAnimation.append(new Pause(l2 - 50L), l2 - 50L);
                continue;
            }
            overlayedAnimation.append(textSpacing, l2);
        }
        return overlayedAnimation;
    }

    public long getLength() {
        return this.length;
    }

    public long getPause(long l) {
        return -1L;
    }

    public void release() {
        Iterator iterator = this.allSequences.iterator();
        while (iterator.hasNext()) {
            OverlayedSequence overlayedSequence = (OverlayedSequence)iterator.next();
            overlayedSequence.getAnimation().release();
        }
    }

    public void render(Graphics2D graphics2D, int n, int n2, long l) {
        int n3 = this.allSequences.size();
        for (int i = n3 - 1; i >= 0; --i) {
            OverlayedSequence overlayedSequence = (OverlayedSequence)this.allSequences.get(i);
            Animation animation = overlayedSequence.getAnimation();
            long l2 = overlayedSequence.getStartTime();
            long l3 = l - l2;
            long l4 = animation.getLength();
            if (l4 != -1L && (0L > l3 || l3 >= l4)) continue;
            animation.render(graphics2D, n, n2, l3);
        }
    }

    public void setLength(long l) {
        this.length = l;
    }

    private static int stringToInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    private static long stringToLong(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    private static class OverlayedSequence {
        private final Animation animation;
        private final long startTime;

        OverlayedSequence(Animation animation, long l) {
            this.animation = animation;
            this.startTime = l;
        }

        Animation getAnimation() {
            return this.animation;
        }

        long getStartTime() {
            return this.startTime;
        }
    }
}

