/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.old;

import com.jgoodies.animation.old.Animation;
import com.jgoodies.animation.old.FunctionFactory;
import com.jgoodies.animation.old.TimeFunction;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;

public final class TextSpacing
implements Animation {
    private static final boolean SCALING_ENABLED = TextSpacing.getScalingEnabled();
    private final String text;
    private final Font font;
    private final TimeFunction brightnessFunction;
    private final TimeFunction kerningFunction;
    private final TimeFunction scaleFunction;
    private final TimeFunction alignmentFunction;
    private final boolean fillShape;
    private boolean hasValidCache = false;
    private Shape[][] glyphShapes;
    private float[][] glyphPositions;
    private float[] originalWidths;
    private float[] originalHeights;
    private float totalHeight;

    public TextSpacing(String string, Font font, TimeFunction timeFunction, TimeFunction timeFunction2, TimeFunction timeFunction3, TimeFunction timeFunction4, boolean bl) {
        this.text = string;
        this.font = font;
        this.brightnessFunction = timeFunction;
        this.kerningFunction = timeFunction2;
        this.scaleFunction = timeFunction3;
        this.alignmentFunction = timeFunction4;
        this.fillShape = bl;
    }

    public static TextSpacing createDefault(String string, int n, long l, String string2, String string3, String string4, String string5, String string6) {
        return new TextSpacing(string, new Font("dialog", 1, n), FunctionFactory.createBrightnessDefault(l, string2), FunctionFactory.createKerningDefault(l, string3), FunctionFactory.createScaleDefault(l, string4), FunctionFactory.createAlignmentDefault(l, string5), !string6.equalsIgnoreCase("draw"));
    }

    private void ensureValidCache(Graphics2D graphics2D) {
        if (this.hasValidCache) {
            return;
        }
        this.validateCache(graphics2D);
    }

    private Color getColor(long l) {
        return new Color(0.4f, 0.4f, 0.4f, 1.0f - this.brightnessFunction.getValue(l));
    }

    public long getLength() {
        return this.brightnessFunction.getLength();
    }

    public long getPause(long l) {
        return -1L;
    }

    private static boolean getScalingEnabled() {
        boolean bl;
        boolean bl2 = bl = !"false".equalsIgnoreCase(System.getProperty("animation.scalingEnabled"));
        if (!bl) {
            System.out.println("Animation scaling " + (bl ? "enabled." : "disabled."));
        }
        return bl;
    }

    public void release() {
        this.hasValidCache = false;
        this.glyphShapes = null;
        this.glyphPositions = null;
        this.originalWidths = null;
        this.originalHeights = null;
    }

    public void render(Graphics2D graphics2D, int n, int n2, long l) {
        this.ensureValidCache(graphics2D);
        graphics2D.setColor(this.getColor(l));
        float f = this.alignmentFunction.getValue(l);
        float f2 = this.kerningFunction.getValue(l);
        float f3 = SCALING_ENABLED && null != this.scaleFunction ? this.scaleFunction.getValue(l) : 1.0f;
        int n3 = this.glyphShapes.length;
        float f4 = 4.0f;
        float f5 = (this.totalHeight + (float)(n3 - 1) * f4) * f3;
        float f6 = ((float)n2 - f5) / 2.0f;
        graphics2D.translate(0.0, f6);
        for (int i = 0; i < n3; ++i) {
            float f7 = this.originalHeights[i] * f3;
            graphics2D.translate(0.0, f7 + (i == 0 ? 0.0f : f4));
            this.renderLine(i, graphics2D, n, n2, f, f2, f3);
        }
        graphics2D.translate(0.0, -f6 - f5);
    }

    private void renderLine(int n, Graphics2D graphics2D, int n2, int n3, float f, float f2, float f3) {
        int n4 = this.glyphShapes[n].length;
        float f4 = f2 * (float)(n4 - 1);
        float f5 = (this.originalWidths[n] + f4) * f3;
        float f6 = (float)(n3 / 2) + f * ((float)n2 - f5 - (float)n3);
        graphics2D.translate(f6, 0.0);
        if (f3 != 1.0f) {
            graphics2D.scale(f3, f3);
        }
        for (int i = 0; i < n4; ++i) {
            float f7 = (float)i * f2;
            graphics2D.translate(f7, 0.0);
            if (this.fillShape) {
                graphics2D.fill(this.glyphShapes[n][i]);
            } else {
                graphics2D.draw(this.glyphShapes[n][i]);
            }
            graphics2D.translate(-f7, 0.0);
        }
        if (f3 != 1.0f) {
            graphics2D.scale(1.0f / f3, 1.0f / f3);
        }
        graphics2D.translate(-f6, 0.0);
    }

    private void setText(Graphics2D graphics2D, String string) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = stringTokenizer.countTokens();
        this.glyphShapes = new Shape[n][];
        this.glyphPositions = new float[n][];
        this.originalWidths = new float[n];
        this.originalHeights = new float[n];
        this.totalHeight = 0.0f;
        for (int i = 0; i < n; ++i) {
            this.setTextLine(i, this.font.createGlyphVector(fontRenderContext, stringTokenizer.nextToken()));
        }
    }

    private void setTextLine(int n, GlyphVector glyphVector) {
        int n2 = glyphVector.getNumGlyphs();
        Rectangle2D rectangle2D = glyphVector.getVisualBounds();
        this.glyphPositions[n] = glyphVector.getGlyphPositions(0, n2, null);
        this.originalWidths[n] = (float)rectangle2D.getWidth();
        this.originalHeights[n] = (float)rectangle2D.getHeight();
        this.totalHeight += (float)rectangle2D.getHeight();
        this.glyphShapes[n] = new Shape[n2];
        for (int i = 0; i < n2; ++i) {
            this.glyphShapes[n][i] = glyphVector.getGlyphOutline(i);
        }
    }

    private synchronized void validateCache(Graphics2D graphics2D) {
        this.setText(graphics2D, this.text);
        this.hasValidCache = true;
    }
}

