/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.renderer;

import com.jgoodies.animation.AnimationRenderer;
import com.jgoodies.animation.renderer.HeightMode;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.Rectangle2D;

public abstract class AbstractTextRenderer
implements AnimationRenderer {
    private String text;
    private Font font;
    private Color color;
    private HeightMode heightMode = HeightMode.CAPITAL_ASCENT;
    protected GlyphVector cachedGlyphVector;
    protected Shape[] cachedGlyphShapes;
    protected float cachedTextWidth;
    protected float cachedTextAscent;
    protected float cachedTextHeight;
    protected float capitalMAscent = -1.0f;
    private boolean cacheValid = false;

    AbstractTextRenderer(String string) {
        this(string, null);
    }

    AbstractTextRenderer(String string, Font font) {
        this.text = string == null ? "Karsten Lentzsch" : string;
        this.font = font == null ? AbstractTextRenderer.createDefaultFont() : font;
    }

    private static Font createDefaultFont() {
        return new Font("dialog", 1, 12);
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        return this.text;
    }

    public HeightMode getHeightMode() {
        return this.heightMode;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setHeightMode(HeightMode heightMode) {
        this.heightMode = heightMode;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new NullPointerException("The font must not be null.");
        }
        if (font.equals(this.font)) {
            return;
        }
        this.font = font;
        this.invalidateCache();
    }

    public void setText(String string) {
        if (string == null) {
            throw new NullPointerException("The text must not be null.");
        }
        if (string.equals(this.text)) {
            return;
        }
        this.text = string;
        this.invalidateCache();
    }

    protected float getAdjustedAscent() {
        if (this.heightMode == HeightMode.CAPITAL_ASCENT) {
            return this.capitalMAscent;
        }
        if (this.heightMode == HeightMode.TEXT_ASCENT) {
            return this.cachedTextAscent;
        }
        return this.cachedTextHeight;
    }

    protected float getAdjustedDescent() {
        if (this.heightMode == HeightMode.CAPITAL_ASCENT) {
            return 0.0f;
        }
        if (this.heightMode == HeightMode.TEXT_ASCENT) {
            return 0.0f;
        }
        return this.cachedTextHeight - this.cachedTextAscent;
    }

    protected boolean isCacheValid() {
        return this.cacheValid;
    }

    protected void setCacheValid(boolean bl) {
        this.cacheValid = bl;
    }

    protected void ensureValidCache(Graphics2D graphics2D) {
        if (!this.isCacheValid()) {
            this.validateCache(graphics2D);
        }
    }

    protected void validateCache(Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        this.ensureCapitalMAscentComputed(fontRenderContext);
        this.cachedGlyphVector = this.font.createGlyphVector(fontRenderContext, this.text);
        Rectangle2D rectangle2D = this.cachedGlyphVector.getVisualBounds();
        this.cachedTextWidth = (float)rectangle2D.getWidth();
        this.cachedTextAscent = (float)(-rectangle2D.getY());
        this.cachedTextHeight = (float)rectangle2D.getHeight();
        int n = this.cachedGlyphVector.getNumGlyphs();
        this.cachedGlyphShapes = new Shape[n];
        for (int i = 0; i < n; ++i) {
            this.cachedGlyphShapes[i] = this.cachedGlyphVector.getGlyphOutline(i);
        }
        this.setCacheValid(true);
    }

    private void ensureCapitalMAscentComputed(FontRenderContext fontRenderContext) {
        if (this.capitalMAscent > 0.0f) {
            return;
        }
        GlyphVector glyphVector = this.font.createGlyphVector(fontRenderContext, "M");
        this.capitalMAscent = (float)(-glyphVector.getVisualBounds().getY());
    }

    protected void invalidateCache() {
        this.setCacheValid(false);
        this.cachedGlyphVector = null;
        this.cachedGlyphShapes = null;
    }
}

