/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.renderer;

import com.jgoodies.animation.renderer.AbstractTextRenderer;
import java.awt.Graphics2D;

public final class BasicTextRenderer
extends AbstractTextRenderer {
    private float offsetX = 0.0f;
    private float offsetY = 0.0f;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float space = 0.0f;

    public BasicTextRenderer(String string) {
        super(string);
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public float getSpace() {
        return this.space;
    }

    public void setOffsetX(float f) {
        this.offsetX = f;
    }

    public void setOffsetY(float f) {
        this.offsetY = f;
    }

    public void setSpace(float f) {
        this.space = f;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleX(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("scaleX must be positive.");
        }
        this.scaleX = f;
    }

    public void setScaleY(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("scaleY must be positive.");
        }
        this.scaleY = f;
    }

    public void render(Graphics2D graphics2D, int n, int n2) {
        this.ensureValidCache(graphics2D);
        int n3 = this.cachedGlyphShapes.length;
        float f = (float)(n3 - 1) * this.space;
        float f2 = this.cachedTextWidth + f;
        float f3 = this.getAdjustedAscent();
        float f4 = this.getOffsetX() + ((float)n - f2 * this.scaleX) / 2.0f;
        float f5 = this.getOffsetY() + ((float)n2 + f3 * this.scaleY) / 2.0f - this.getAdjustedDescent();
        graphics2D.setColor(this.getColor());
        graphics2D.translate(f4, f5);
        graphics2D.scale(this.scaleX, this.scaleY);
        for (int i = 0; i < n3; ++i) {
            graphics2D.fill(this.cachedGlyphShapes[i]);
            graphics2D.translate(this.space, 0.0);
        }
        graphics2D.scale(1.0f / this.scaleX, 1.0f / this.scaleY);
        graphics2D.translate(-f - f4, -f5);
    }
}

