/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.renderer;

import com.jgoodies.animation.AnimationRenderer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Random;

public final class FanRenderer
implements AnimationRenderer {
    private static final Random random = new Random(System.currentTimeMillis());
    private final Triangle[] triangles;
    private Point2D origin;
    private double rotation;

    public FanRenderer(Triangle[] triangleArray) {
        this.triangles = triangleArray;
    }

    public FanRenderer(int n, Color color) {
        this(FanRenderer.createSectors(n, color));
    }

    public static Triangle[] createSectors(int n, Color color) {
        Triangle[] triangleArray = new Triangle[n];
        double d = Math.PI * 2 / (double)n;
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * d + ((double)random.nextFloat() - 0.5) * Math.PI / 10.0;
            double d3 = d * (0.2 + (double)random.nextFloat() * 0.4);
            triangleArray[i] = new Triangle(d2, d3, FanRenderer.nextColor(color));
        }
        return triangleArray;
    }

    private static Color nextColor(Color color) {
        float[] fArray = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), fArray);
        float f = 0.8f + random.nextFloat() * 0.2f;
        return Color.getHSBColor(fArray[0], fArray[1], f);
    }

    public Point2D getOrigin() {
        return this.origin;
    }

    public void setOrigin(Point2D point2D) {
        this.origin = point2D;
    }

    public double getRotation() {
        return this.rotation;
    }

    public void setRotation(double d) {
        this.rotation = d;
    }

    public void render(Graphics2D graphics2D, int n, int n2) {
        double d = Math.sqrt(n * n + n2 * n2);
        Point2D point2D = this.getOrigin() != null ? this.getOrigin() : this.getDefaultOrigin(n, n2);
        graphics2D.translate(point2D.getX(), point2D.getY());
        graphics2D.rotate(this.rotation);
        for (int i = 0; i < this.triangles.length; ++i) {
            this.triangles[i].render(graphics2D, d);
        }
        graphics2D.rotate(-this.rotation);
        graphics2D.translate(-point2D.getX(), -point2D.getY());
    }

    private Point2D getDefaultOrigin(int n, int n2) {
        return new Point2D.Double((double)n * 0.75, (double)n2 * 0.75);
    }

    private static class Triangle {
        private final double aRotation;
        private final double angle;
        private final Color color;

        private Triangle(double d, double d2, Color color) {
            this.aRotation = d;
            this.angle = d2;
            this.color = color;
        }

        private static Shape createPolygon(double d, double d2, double d3) {
            double d4 = d - d2 / 2.0;
            double d5 = d4 + d2;
            double d6 = d3 / Math.cos(d2 / 2.0);
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = (float)((double)f - d6 * Math.cos(d4));
            float f4 = (float)((double)f2 - d6 * Math.sin(d4));
            float f5 = (float)((double)f - d6 * Math.cos(d5));
            float f6 = (float)((double)f2 - d6 * Math.sin(d5));
            GeneralPath generalPath = new GeneralPath(0, 3);
            generalPath.moveTo(f, f2);
            generalPath.lineTo(f3, f4);
            generalPath.lineTo(f5, f6);
            generalPath.closePath();
            return generalPath;
        }

        void render(Graphics2D graphics2D, double d) {
            graphics2D.setColor(this.color);
            graphics2D.fill(Triangle.createPolygon(this.aRotation, this.angle, d));
        }
    }
}

