/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.animation.renderer;

import com.jgoodies.animation.AnimationFunction;
import com.jgoodies.animation.AnimationFunctions;
import com.jgoodies.animation.renderer.AbstractTextRenderer;
import java.awt.Color;
import java.awt.Graphics2D;

public final class GlyphRenderer
extends AbstractTextRenderer {
    private final AnimationFunction colorFunction;
    private final AnimationFunctions.FloatFunction scaleFunction;
    private final long glyphDelay;
    private long time;

    public GlyphRenderer(String string, AnimationFunction animationFunction, AnimationFunction animationFunction2, AnimationFunction animationFunction3, long l) {
        super(string);
        this.scaleFunction = AnimationFunctions.asFloat(animationFunction);
        this.colorFunction = animationFunction3;
        this.glyphDelay = l;
        this.time = 0L;
    }

    public void setTime(long l) {
        this.time = l;
    }

    private long relativeTime(int n) {
        return Math.max(0L, this.time - this.glyphDelay * (long)n);
    }

    private float scaleAt(int n) {
        return this.scaleFunction.valueAt(this.relativeTime(n));
    }

    private Color colorAt(int n) {
        return (Color)this.colorFunction.valueAt(this.relativeTime(n));
    }

    public void render(Graphics2D graphics2D, int n, int n2) {
        this.ensureValidCache(graphics2D);
        int n3 = this.cachedGlyphShapes.length;
        float f = ((float)n - this.cachedTextWidth) / 2.0f;
        float f2 = ((float)n2 + this.cachedTextHeight) / 2.0f - this.getAdjustedDescent();
        graphics2D.translate(f, f2);
        for (int i = n3 - 1; i >= 0; --i) {
            float f3 = this.scaleAt(i);
            graphics2D.setColor(this.colorAt(i));
            double d = this.cachedGlyphVector.getGlyphPosition(i).getX();
            double d2 = this.cachedGlyphVector.getGlyphVisualBounds(i).getBounds2D().getHeight();
            double d3 = -d * (double)(f3 - 1.0f);
            double d4 = d2 * (double)(f3 - 1.0f) / 2.0;
            graphics2D.translate(d3, d4);
            graphics2D.scale(f3, f3);
            graphics2D.fill(this.cachedGlyphShapes[i]);
            graphics2D.scale(1.0f / f3, 1.0f / f3);
            graphics2D.translate(-d3, -d4);
        }
        graphics2D.translate(-f, -f2);
    }
}

