/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationMessage;
import com.jgoodies.validation.message.SimpleValidationMessage;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class ValidationResult
implements Serializable {
    public static final ValidationResult EMPTY = new ValidationResult(Collections.EMPTY_LIST);
    private final List messageList;

    public ValidationResult() {
        this(new LinkedList());
    }

    private ValidationResult(List list) {
        this.messageList = list;
    }

    public void add(ValidationMessage validationMessage) {
        if (validationMessage == null) {
            throw new NullPointerException("The validation message must not be null.");
        }
        this.messageList.add(validationMessage);
    }

    public void addError(String string) {
        if (string == null) {
            throw new NullPointerException("The message text must not be null.");
        }
        this.messageList.add(new SimpleValidationMessage(string, Severity.ERROR));
    }

    public void addWarning(String string) {
        if (string == null) {
            throw new NullPointerException("The message text must not be null.");
        }
        this.messageList.add(new SimpleValidationMessage(string));
    }

    public void addAll(List list) {
        if (list == null) {
            throw new NullPointerException("The messages list must not be null.");
        }
        this.messageList.addAll(list);
    }

    public void addAllFrom(ValidationResult validationResult) {
        if (validationResult == null) {
            throw new NullPointerException("The validation result to add must not be null.");
        }
        this.addAll(validationResult.getMessages());
    }

    public boolean isEmpty() {
        return this.messageList.isEmpty();
    }

    public int size() {
        return this.messageList.size();
    }

    public boolean contains(ValidationMessage validationMessage) {
        return this.messageList.contains(validationMessage);
    }

    public ValidationResult subResult(int n, int n2) {
        ValidationResult validationResult = new ValidationResult();
        validationResult.addAll(this.messageList.subList(n, n2));
        return validationResult;
    }

    public ValidationResult subResult(Object object) {
        if (object == null) {
            return EMPTY;
        }
        ValidationResult validationResult = new ValidationResult();
        Iterator iterator = this.messageList.iterator();
        while (iterator.hasNext()) {
            ValidationMessage validationMessage = (ValidationMessage)iterator.next();
            if (!object.equals(validationMessage.key())) continue;
            validationResult.add(validationMessage);
        }
        return validationResult;
    }

    public Map keyMap() {
        HashMap<Object, ValidationResult> hashMap = new HashMap<Object, ValidationResult>();
        Iterator iterator = this.messageList.iterator();
        while (iterator.hasNext()) {
            ValidationMessage validationMessage = (ValidationMessage)iterator.next();
            Object object = validationMessage.key();
            ValidationResult validationResult = (ValidationResult)hashMap.get(object);
            if (validationResult == null) {
                validationResult = new ValidationResult();
                hashMap.put(object, validationResult);
            }
            validationResult.add(validationMessage);
        }
        return hashMap;
    }

    public Severity getSeverity() {
        return ValidationResult.getSeverity(this.getMessages());
    }

    public boolean hasMessages() {
        return !this.isEmpty();
    }

    public boolean hasErrors() {
        return ValidationResult.hasSeverity(this.getMessages(), Severity.ERROR);
    }

    public boolean hasWarnings() {
        return ValidationResult.hasSeverity(this.getMessages(), Severity.WARNING);
    }

    public List getMessages() {
        return Collections.unmodifiableList(this.messageList);
    }

    public List getErrors() {
        return ValidationResult.getMessagesWithSeverity(this.getMessages(), Severity.ERROR);
    }

    public List getWarnings() {
        return ValidationResult.getMessagesWithSeverity(this.getMessages(), Severity.WARNING);
    }

    public String getMessagesText() {
        return ValidationResult.getMessagesText(this.getMessages());
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty ValidationResult";
        }
        StringBuffer stringBuffer = new StringBuffer("ValidationResult:");
        Iterator iterator = this.messageList.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("\n\t").append(iterator.next());
        }
        return stringBuffer.toString();
    }

    private static Severity getSeverity(List list) {
        if (list.isEmpty()) {
            return Severity.OK;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValidationMessage validationMessage = (ValidationMessage)iterator.next();
            if (validationMessage.severity() != Severity.ERROR) continue;
            return Severity.ERROR;
        }
        return Severity.WARNING;
    }

    private static boolean hasSeverity(List list, Severity severity) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValidationMessage validationMessage = (ValidationMessage)iterator.next();
            if (validationMessage.severity() != severity) continue;
            return true;
        }
        return false;
    }

    private static List getMessagesWithSeverity(List list, Severity severity) {
        LinkedList<ValidationMessage> linkedList = new LinkedList<ValidationMessage>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValidationMessage validationMessage = (ValidationMessage)iterator.next();
            if (validationMessage.severity() != severity) continue;
            linkedList.add(validationMessage);
        }
        return Collections.unmodifiableList(linkedList);
    }

    private static String getMessagesText(List list) {
        if (list.isEmpty()) {
            return "OK";
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ValidationMessage validationMessage = (ValidationMessage)iterator.next();
            if (stringBuffer.length() > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(validationMessage.formattedText());
        }
        return stringBuffer.toString();
    }
}

