/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.formatter;

import com.jgoodies.validation.formatter.EmptyDateFormatter;
import com.jgoodies.validation.util.ValidationUtils;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RelativeDateFormatter
extends EmptyDateFormatter {
    public static final String KEY_YESTERDAY = "RelativeDate.yesterday";
    public static final String KEY_TODAY = "RelativeDate.today";
    public static final String KEY_TOMORROW = "RelativeDate.tomorrow";
    private static ResourceBundle defaultResourceBundle = new DefaultResources();
    private final boolean useOutputShortcuts;
    private final boolean allowRelativeInput;
    private ResourceBundle resourceBundle;

    public RelativeDateFormatter() {
        this(true, true);
    }

    public RelativeDateFormatter(DateFormat dateFormat) {
        this(dateFormat, true, true);
    }

    public RelativeDateFormatter(boolean bl, boolean bl2) {
        this.useOutputShortcuts = bl;
        this.allowRelativeInput = bl2;
    }

    public RelativeDateFormatter(DateFormat dateFormat, boolean bl, boolean bl2) {
        super(dateFormat);
        this.useOutputShortcuts = bl;
        this.allowRelativeInput = bl2;
    }

    public Object stringToValue(String string) throws ParseException {
        if (!this.allowRelativeInput) {
            return super.stringToValue(string);
        }
        if (string.startsWith("+")) {
            string = string.substring(1);
        }
        try {
            int n = Integer.parseInt(string);
            return ValidationUtils.getRelativeDate(n);
        }
        catch (NumberFormatException numberFormatException) {
            return super.stringToValue(string);
        }
    }

    public String valueToString(Object object) throws ParseException {
        if (object == null || !this.useOutputShortcuts || !(object instanceof Date)) {
            return super.valueToString(object);
        }
        Date date = (Date)object;
        if (ValidationUtils.isYesterday(date)) {
            return this.getString(KEY_YESTERDAY);
        }
        if (ValidationUtils.isToday(date)) {
            return this.getString(KEY_TODAY);
        }
        if (ValidationUtils.isTomorrow(date)) {
            return this.getString(KEY_TOMORROW);
        }
        return super.valueToString(object);
    }

    public static ResourceBundle getDefaultResourceBundle() {
        return defaultResourceBundle;
    }

    public static void setDefaultResourceBundle(ResourceBundle resourceBundle) {
        defaultResourceBundle = resourceBundle;
    }

    public final ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public final void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    private String getString(String string) {
        ResourceBundle resourceBundle = this.getResourceBundle();
        if (resourceBundle == null) {
            resourceBundle = RelativeDateFormatter.getDefaultResourceBundle();
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "RelativeDateFormatter", missingResourceException);
            return "";
        }
    }

    private static class DefaultResources
    extends ListResourceBundle {
        private static final Object[][] CONTENTS = new Object[][]{{"RelativeDate.yesterday", "Yesterday"}, {"RelativeDate.today", "Today"}, {"RelativeDate.tomorrow", "Tomorrow"}};

        private DefaultResources() {
        }

        public Object[][] getContents() {
            return CONTENTS;
        }
    }
}

