/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static boolean equals(Object object, Object object2) {
        return object != null && object2 != null && object.equals(object2) || object == null && object2 == null;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isBlank(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean hasMinimumLength(String string, int n) {
        int n2 = string == null ? 0 : string.trim().length();
        return n <= n2;
    }

    public static boolean hasMaximumLength(String string, int n) {
        int n2 = string == null ? 0 : string.trim().length();
        return n2 <= n;
    }

    public static boolean hasBoundedLength(String string, int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("The minimum length must be less than or equal to the maximum length.");
        }
        int n3 = string == null ? 0 : string.trim().length();
        return n <= n3 && n3 <= n2;
    }

    public static boolean isDigit(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetter(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isLetter(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLetterOrDigit(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPastDay(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        Calendar calendar = ValidationUtils.getRelativeCalendar(0);
        return gregorianCalendar.before(calendar);
    }

    public static boolean isYesterday(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        Calendar calendar = ValidationUtils.getRelativeCalendar(-1);
        Calendar calendar2 = ValidationUtils.getRelativeCalendar(0);
        return !gregorianCalendar.before(calendar) && gregorianCalendar.before(calendar2);
    }

    public static boolean isToday(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        Calendar calendar = ValidationUtils.getRelativeCalendar(0);
        Calendar calendar2 = ValidationUtils.getRelativeCalendar(1);
        return !gregorianCalendar.before(calendar) && gregorianCalendar.before(calendar2);
    }

    public static boolean isTomorrow(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        Calendar calendar = ValidationUtils.getRelativeCalendar(1);
        Calendar calendar2 = ValidationUtils.getRelativeCalendar(2);
        return !gregorianCalendar.before(calendar) && gregorianCalendar.before(calendar2);
    }

    public static boolean isFutureDay(Date date) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        Calendar calendar = ValidationUtils.getRelativeCalendar(1);
        return !gregorianCalendar.before(calendar);
    }

    public static Date getRelativeDate(int n) {
        return ValidationUtils.getRelativeCalendar(n).getTime();
    }

    public static Calendar getRelativeCalendar(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return ValidationUtils.getRelativeCalendar(gregorianCalendar, n);
    }

    public static Calendar getRelativeCalendar(Calendar calendar, int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        ((Calendar)gregorianCalendar).add(5, n);
        return gregorianCalendar;
    }
}

