/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.validation.view;

import com.jgoodies.validation.Severity;
import com.jgoodies.validation.ValidationResult;
import com.jgoodies.validation.util.ValidationUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.JTextComponent;

public final class ValidationComponentUtils {
    private static final Color MANDATORY_FOREGROUND = new Color(70, 70, 210);
    private static final Color MANDATORY_BACKGROUND = new Color(235, 235, 255);
    private static final Color ERROR_BACKGROUND = new Color(255, 215, 215);
    private static final Color WARNING_BACKGROUND = new Color(255, 235, 205);
    private static final String MANDATORY_KEY = "validation.isMandatory";
    private static final String MESSAGE_KEY = "validation.messageKey";
    private static final String INPUT_HINT_KEY = "validation.inputHint";
    private static final String SEVERITY_KEY = "validation.severity";
    private static final String STORED_BACKGROUND_KEY = "validation.storedBackground";
    private static Border mandatoryBorder;
    private static final Map PROTOTYPE_COMPONENTS;

    private ValidationComponentUtils() {
    }

    public static boolean isMandatory(JComponent jComponent) {
        return Boolean.TRUE.equals(jComponent.getClientProperty(MANDATORY_KEY));
    }

    public static boolean isMandatoryAndBlank(JComponent jComponent) {
        if (!(jComponent instanceof JTextComponent)) {
            return false;
        }
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        return ValidationComponentUtils.isMandatory(jTextComponent) && ValidationUtils.isBlank(jTextComponent.getText());
    }

    public static void setMandatory(JComponent jComponent, boolean bl) {
        boolean bl2 = ValidationComponentUtils.isMandatory(jComponent);
        if (bl2 != bl) {
            jComponent.putClientProperty(MANDATORY_KEY, bl);
        }
    }

    public static Severity getSeverity(JComponent jComponent) {
        return (Severity)jComponent.getClientProperty(SEVERITY_KEY);
    }

    public static void setSeverity(JComponent jComponent, Severity severity) {
        jComponent.putClientProperty(SEVERITY_KEY, severity);
    }

    public static Object getMessageKey(JComponent jComponent) {
        return jComponent.getClientProperty(MESSAGE_KEY);
    }

    public static void setMessageKey(JComponent jComponent, Object object) {
        jComponent.putClientProperty(MESSAGE_KEY, object);
    }

    public static Object getInputHint(JComponent jComponent) {
        return jComponent.getClientProperty(INPUT_HINT_KEY);
    }

    public static void setInputHint(JComponent jComponent, Object object) {
        jComponent.putClientProperty(INPUT_HINT_KEY, object);
    }

    public static boolean hasError(JComponent jComponent, ValidationResult validationResult) {
        return validationResult.subResult(ValidationComponentUtils.getMessageKey(jComponent)).hasErrors();
    }

    public static boolean hasWarning(JComponent jComponent, ValidationResult validationResult) {
        return validationResult.subResult(ValidationComponentUtils.getMessageKey(jComponent)).hasWarnings();
    }

    public static Color getMandatoryBackground() {
        return MANDATORY_BACKGROUND;
    }

    public static Color getMandatoryForeground() {
        return MANDATORY_FOREGROUND;
    }

    public static void setMandatoryBackground(JTextComponent jTextComponent) {
        ValidationComponentUtils.ensureBackgroundStored(jTextComponent);
        jTextComponent.setBackground(MANDATORY_BACKGROUND);
    }

    public static Color getErrorBackground() {
        return ERROR_BACKGROUND;
    }

    public static void setErrorBackground(JTextComponent jTextComponent) {
        ValidationComponentUtils.ensureBackgroundStored(jTextComponent);
        jTextComponent.setBackground(ERROR_BACKGROUND);
    }

    public static Color getWarningBackground() {
        return WARNING_BACKGROUND;
    }

    public static void setWarningBackground(JTextComponent jTextComponent) {
        ValidationComponentUtils.ensureBackgroundStored(jTextComponent);
        jTextComponent.setBackground(WARNING_BACKGROUND);
    }

    public static void setMandatoryBorder(JTextComponent jTextComponent) {
        Container container;
        Container container2 = jTextComponent.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            ((JScrollPane)container).setBorder(ValidationComponentUtils.getMandatoryBorder());
            return;
        }
        jTextComponent.setBorder(ValidationComponentUtils.getMandatoryBorder());
    }

    public static Border getMandatoryBorder() {
        if (mandatoryBorder == null) {
            mandatoryBorder = new CompoundBorder(new LineBorder(ValidationComponentUtils.getMandatoryForeground()), new BasicBorders.MarginBorder());
        }
        return mandatoryBorder;
    }

    public static void updateComponentTreeMandatoryBackground(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryBackgroundVisitor());
    }

    public static void updateComponentTreeMandatoryAndBlankBackground(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryAndBlankBackgroundVisitor());
    }

    public static void updateComponentTreeMandatoryBorder(Container container) {
        ValidationComponentUtils.visitComponentTree(container, null, new MandatoryBorderVisitor());
    }

    public static void updateComponentTreeValidationBackground(Container container, ValidationResult validationResult) {
        ValidationComponentUtils.visitComponentTree(container, validationResult.keyMap(), new MandatoryAndBlankOrSeverityBackgroundVisitor());
    }

    public static void updateComponentTreeSeverityBackground(Container container, ValidationResult validationResult) {
        ValidationComponentUtils.visitComponentTree(container, validationResult.keyMap(), new SeverityBackgroundVisitor());
    }

    public static void updateComponentTreeSeverity(Container container, ValidationResult validationResult) {
        ValidationComponentUtils.visitComponentTree(container, validationResult.keyMap(), new SeverityVisitor());
    }

    public static void visitComponentTree(Container container, Map map, Visitor visitor) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JTextComponent) {
                JComponent jComponent = (JComponent)component;
                visitor.visit(jComponent, map);
                continue;
            }
            if (!(component instanceof Container)) continue;
            ValidationComponentUtils.visitComponentTree((Container)component, map, visitor);
        }
    }

    private static ValidationResult getAssociatedResult(JComponent jComponent, Map map) {
        Object object = ValidationComponentUtils.getMessageKey(jComponent);
        if (object == null || map == null) {
            return null;
        }
        ValidationResult validationResult = (ValidationResult)map.get(object);
        return validationResult == null ? ValidationResult.EMPTY : validationResult;
    }

    private static Color getDefaultBackground(JTextComponent jTextComponent) {
        JTextComponent jTextComponent2 = ValidationComponentUtils.getPrototypeFor(jTextComponent.getClass());
        jTextComponent2.setEnabled(jTextComponent.isEnabled());
        jTextComponent2.setEditable(jTextComponent.isEditable());
        return jTextComponent2.getBackground();
    }

    private static JTextComponent getPrototypeFor(Class clazz) {
        JTextComponent jTextComponent = (JTextComponent)PROTOTYPE_COMPONENTS.get(clazz);
        if (jTextComponent == null) {
            try {
                jTextComponent = (JTextComponent)clazz.newInstance();
            }
            catch (Exception exception) {
                jTextComponent = new JTextField();
            }
            PROTOTYPE_COMPONENTS.put(clazz, jTextComponent);
        }
        return jTextComponent;
    }

    private static Color getStoredBackground(JTextComponent jTextComponent) {
        return (Color)jTextComponent.getClientProperty(STORED_BACKGROUND_KEY);
    }

    private static void ensureBackgroundStored(JTextComponent jTextComponent) {
        if (ValidationComponentUtils.getStoredBackground(jTextComponent) != null) {
            return;
        }
        jTextComponent.putClientProperty(STORED_BACKGROUND_KEY, jTextComponent.getBackground());
    }

    private static void restoreBackground(JTextComponent jTextComponent) {
        Color color = ValidationComponentUtils.getStoredBackground(jTextComponent);
        jTextComponent.setBackground(color == null ? ValidationComponentUtils.getDefaultBackground(jTextComponent) : color);
    }

    static {
        PROTOTYPE_COMPONENTS = new HashMap();
    }

    private static final class SeverityVisitor
    implements Visitor {
        private SeverityVisitor() {
        }

        public void visit(JComponent jComponent, Map map) {
            ValidationResult validationResult = ValidationComponentUtils.getAssociatedResult(jComponent, map);
            Severity severity = validationResult == null ? null : validationResult.getSeverity();
            ValidationComponentUtils.setSeverity(jComponent, severity);
        }
    }

    private static final class SeverityBackgroundVisitor
    implements Visitor {
        private SeverityBackgroundVisitor() {
        }

        public void visit(JComponent jComponent, Map map) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            ValidationResult validationResult = ValidationComponentUtils.getAssociatedResult(jComponent, map);
            if (validationResult == null || validationResult.isEmpty()) {
                ValidationComponentUtils.restoreBackground(jTextComponent);
            } else if (validationResult.hasErrors()) {
                ValidationComponentUtils.setErrorBackground(jTextComponent);
            } else if (validationResult.hasWarnings()) {
                ValidationComponentUtils.setWarningBackground(jTextComponent);
            }
        }
    }

    private static final class MandatoryBorderVisitor
    implements Visitor {
        private MandatoryBorderVisitor() {
        }

        public void visit(JComponent jComponent, Map map) {
            if (jComponent instanceof JTextComponent && ValidationComponentUtils.isMandatory(jComponent)) {
                ValidationComponentUtils.setMandatoryBorder((JTextComponent)jComponent);
            }
        }
    }

    private static final class MandatoryAndBlankOrSeverityBackgroundVisitor
    implements Visitor {
        private MandatoryAndBlankOrSeverityBackgroundVisitor() {
        }

        public void visit(JComponent jComponent, Map map) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            ValidationResult validationResult = ValidationComponentUtils.getAssociatedResult(jComponent, map);
            if (ValidationComponentUtils.isMandatoryAndBlank(jComponent)) {
                ValidationComponentUtils.setMandatoryBackground(jTextComponent);
            } else if (validationResult == null || validationResult.isEmpty()) {
                ValidationComponentUtils.restoreBackground(jTextComponent);
            } else if (validationResult.hasErrors()) {
                ValidationComponentUtils.setErrorBackground(jTextComponent);
            } else if (validationResult.hasWarnings()) {
                ValidationComponentUtils.setWarningBackground(jTextComponent);
            }
        }
    }

    private static final class MandatoryAndBlankBackgroundVisitor
    implements Visitor {
        private MandatoryAndBlankBackgroundVisitor() {
        }

        public void visit(JComponent jComponent, Map map) {
            JTextComponent jTextComponent = (JTextComponent)jComponent;
            if (ValidationComponentUtils.isMandatoryAndBlank(jTextComponent)) {
                ValidationComponentUtils.setMandatoryBackground(jTextComponent);
            } else {
                ValidationComponentUtils.restoreBackground(jTextComponent);
            }
        }
    }

    private static final class MandatoryBackgroundVisitor
    implements Visitor {
        private MandatoryBackgroundVisitor() {
        }

        public void visit(JComponent jComponent, Map map) {
            if (jComponent instanceof JTextComponent && ValidationComponentUtils.isMandatory(jComponent)) {
                ValidationComponentUtils.setMandatoryBackground((JTextComponent)jComponent);
            }
        }
    }

    public static interface Visitor {
        public void visit(JComponent var1, Map var2);
    }
}

