/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.SerialPortManager;
import com.ecmtuning.ecmlink.device.data.DataManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.UnitsModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import java.util.prefs.Preferences;

public class CmdLine {
    private DeviceManagerFactory deviceManagerFactory;
    private SerialPortManager serialPortManager;
    private FilenameModel filenameModel;

    private void usage() {
        System.err.println("Usage: CmdLine");
        System.err.println("    --port <portname> (e.g., /dev/ttySP1)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _main(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            this.usage();
            return;
        }
        String string = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("--port")) continue;
            string = stringArray[++n];
        }
        this.filenameModel = new FilenameModel();
        DataManager.setApplicationPreferencesNode(CmdLine.getAppPrefsNode());
        this.deviceManagerFactory = DeviceManagerFactory.getInstance();
        this.serialPortManager = SerialPortManager.getInstance();
        this.restoreState();
        DataManager.initialize();
        this.deviceManagerFactory.startUp();
        try {
            if (string != null) {
                this.serialPortManager.setForcedPortId(string);
                System.out.println("Forcing port ID: " + string);
            }
            for (n = 0; n < 10; ++n) {
                long l = System.currentTimeMillis();
                System.out.println("Attempting connection");
                ECMLinkDeviceManager eCMLinkDeviceManager = (ECMLinkDeviceManager)this.deviceManagerFactory.getMainDeviceManager();
                int n2 = eCMLinkDeviceManager.getConnectedDeviceId();
                System.out.println("Connected device: " + ECMLinkDeviceMap.getDeviceDisplayName(n2));
                System.out.println("Serial number: " + eCMLinkDeviceManager.constructSerialNumDisplayStr(eCMLinkDeviceManager.getConnectedSerialNum()));
                System.out.println("Firmware version: " + ECMLinkDeviceMap.getDeviceVersionString(n2, eCMLinkDeviceManager.getConnectedFirmwareId()));
                long l2 = System.currentTimeMillis();
                float f = (float)(l2 - l) / 1000.0f;
                System.out.println("Time: " + XFormatter.format(f, 1) + " secs");
                Thread.sleep(1000L);
                eCMLinkDeviceManager.setConnected(false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.storeState();
        }
    }

    public void restoreState() {
        Preferences preferences = CmdLine.getAppPrefsNode();
        this.deviceManagerFactory.restoreFrom(preferences);
        this.serialPortManager.restoreFrom(preferences);
        this.filenameModel.restoreFrom(preferences);
        UnitsModel.getInstance().restoreFrom(preferences);
    }

    public void storeState() {
        Preferences preferences = CmdLine.getAppPrefsNode();
        this.deviceManagerFactory.storeIn(preferences);
        this.serialPortManager.storeIn(preferences);
        this.filenameModel.storeIn(preferences);
        UnitsModel.getInstance().storeIn(preferences);
    }

    public static Preferences getAppPrefsNode() {
        return Preferences.userRoot().node("ecmtuning/cmdline");
    }

    public static void main(String[] stringArray) {
        new CmdLine()._main(stringArray);
    }
}

