/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.BasicStrings;
import com.ecmtuning.ecmlink.util.UserHomeClassLoader;
import com.ecmtuning.ecmlink.util.ui.ExternalLinkContentViewerUI;
import com.ecmtuning.ecmlink.view.main.MainFrame;
import com.ecmtuning.ecmlink.view.main.SetupWelcomePanel;
import com.install4j.api.launcher.StartupNotification;
import com.jgoodies.looks.LookUtils;
import com.jgoodies.uif.AbstractFrame;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.application.ApplicationConfiguration;
import com.jgoodies.uif.application.ApplicationDescription;
import com.jgoodies.uif.laf.ExtUIManager;
import com.jgoodies.uif.laf.LookChoiceStrategies;
import com.jgoodies.uif.laf.LookChoiceStrategy;
import com.jgoodies.uif.lazy.BackgroundLoader;
import com.jgoodies.uif.lazy.Preparables;
import com.jgoodies.uif.osx.OSXApplicationMenu;
import com.jgoodies.uif.splash.LogSplash;
import com.jgoodies.uif.splash.Splash;
import com.jgoodies.uif.splash.SplashProvider;
import com.jgoodies.uifextras.convenience.DefaultApplicationStarter;
import com.jgoodies.uifextras.convenience.SetupManager;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class ECMLink
extends DefaultApplicationStarter {
    private MainModel mainModel;
    static ApplicationConfiguration appConf = new ApplicationConfiguration("ecmtuning/ecmlink", "com/ecmtuning/ecmlink/view/main/", "Help.hs", null);
    static String[] appArgs;

    protected void configureLogging() {
    }

    protected void configureSplash() {
        Splash.setProvider((SplashProvider)new LogSplash());
    }

    protected AbstractFrame createMainFrame() {
        return new MainFrame();
    }

    protected void initializeActions() {
        OSXApplicationMenu.register((ActionListener)MainActions.getAction("openAboutDialog"), (ActionListener)MainActions.getAction("openPreferences"), (ActionListener)MainActions.getAction("exitApp"));
    }

    private void configurePreparation() {
        BackgroundLoader backgroundLoader = new BackgroundLoader();
        backgroundLoader.add(Preparables.createEagerActionReader());
        backgroundLoader.add(Preparables.createUIDefaultsInitializer());
        backgroundLoader.add(Preparables.createMenuInitializer());
        backgroundLoader.add(Preparables.createSupportedLafsReader());
        this.mainModel.addInitializers(backgroundLoader);
        backgroundLoader.start();
    }

    protected void launchApplication() {
        StartupNotification.Listener listener;
        Splash.setNote((String)"Creating Models", (int)30);
        this.mainModel = MainModel.getInstance();
        Application.fireApplicationStarting();
        Splash.setNote((String)"Initializing Actions\u2026", (int)50);
        this.initializeActions();
        AbstractFrame abstractFrame = this.createMainFrame();
        Application.setDefaultParentFrame((JFrame)abstractFrame);
        this.checkSetup();
        Splash.setNote((String)"Building UI\u2026", (int)60);
        abstractFrame.build();
        this.mainModel.startUp();
        Splash.setNote((String)"Finishing\u2026", (int)90);
        abstractFrame.open();
        if (appArgs != null && appArgs.length > 0) {
            listener = new File[appArgs.length];
            for (int i = 0; i < ((File[])listener).length; ++i) {
                listener[i] = new File(appArgs[i]);
            }
            SwingUtilities.invokeLater(new Runnable((File[])listener){
                final /* synthetic */ File[] val$files;
                {
                    this.val$files = fileArray;
                }

                @Override
                public void run() {
                    MainModel.getInstance().getMainActions().openFiles(this.val$files, true);
                }
            });
        }
        listener = new StartupNotification.Listener(){

            public synchronized void startupPerformed(String string) {
                string = BasicStrings.replace(string, "\"", "");
                final File file = new File(string);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainModel.getInstance().getMainActions().openFiles(new File[]{file}, true);
                    }
                });
            }
        };
        StartupNotification.registerStartupListener((StartupNotification.Listener)listener);
        this.configurePreparation();
    }

    public static void main(String[] stringArray) {
        Object object;
        try {
            object = new File(FilenameModel.buildUserResourcesPath()).toURL();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            UserHomeClassLoader userHomeClassLoader = new UserHomeClassLoader(new URL[]{object}, classLoader);
            Thread.currentThread().setContextClassLoader(userHomeClassLoader);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (LookUtils.IS_OS_MAC) {
            ExtUIManager.setLookChoiceStrategy((LookChoiceStrategy)LookChoiceStrategies.DEFAULT);
        } else {
            ExtUIManager.setLookChoiceStrategy((LookChoiceStrategy)LookChoiceStrategies.FIXED_XP);
        }
        appArgs = stringArray;
        ExternalLinkContentViewerUI.registerViewer();
        SetupManager.setWelcomePanel((SetupManager.WizardPanel)new SetupWelcomePanel());
        object = System.getProperty("ecmlink.version", "v3");
        try {
            int n;
            int n2 = ((String)object).indexOf(46);
            if (n2 != -1 && ((String)object).length() > n2 + 2 && (n = ((String)object).indexOf(46, n2 + 1)) != -1) {
                int n3 = Integer.parseInt(((String)object).substring(n2 + 1, n));
                int n4 = Integer.parseInt(((String)object).substring(n + 1));
                int n5 = n3 * 256 + n4;
                System.setProperty("ecmlink.versionnum", Integer.toHexString(n5));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        ApplicationDescription applicationDescription = new ApplicationDescription("ecmlink", "ECMLink", "v3", (String)object, "ECMLink application", "\u00a9 2002-2017", "ECMTuning", "http://www.ecmtuning.com", "contact@ecmtuning.com");
        new ECMLink().boot(applicationDescription, appConf);
    }
}

