/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control;

import com.ecmtuning.ecmlink.device.DeviceListener;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.SwingInvokeUtils;
import com.ecmtuning.ecmlink.view.main.tabs.MainTabPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Sizes;
import com.jgoodies.uif.util.ResourceUtils;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;

public abstract class AbstractDeviceInfoTab
extends MainTabPanel {
    protected int dluX2Pixels;
    protected JTextArea taStatusLog;
    protected JScrollPane spStatusLog;
    protected JTextField tfDatalogDirectory;
    protected JButton connectBtn;
    protected boolean isMainDevice = true;
    protected final DeviceManager deviceManager;
    PropertyChangeListener filenameModelListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AbstractDeviceInfoTab.this.updateDatalogFilename();
        }
    };
    DeviceListener deviceListener = new DeviceListener(){

        @Override
        public void commandSendEnd() {
        }

        @Override
        public void commandSendEndError() {
        }

        @Override
        public void commandSendStart() {
        }

        @Override
        public void connectAttemptEnd() {
        }

        @Override
        public void connectAttemptStart() {
        }

        @Override
        public void connectProgress(int n) {
            if (n == 100) {
                AbstractDeviceInfoTab.this.populateStatusLabels();
            }
        }

        @Override
        public void connectStatus(boolean bl) {
            AbstractDeviceInfoTab.this.connectStatusChanged(bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void statusTextUpdate(String string) {
            if (AbstractDeviceInfoTab.this.taStatusLog != null) {
                JTextArea jTextArea = AbstractDeviceInfoTab.this.taStatusLog;
                synchronized (jTextArea) {
                    AbstractDeviceInfoTab.this.taStatusLog.append(string + "\n");
                    AbstractDeviceInfoTab.this.taStatusLog.setCaretPosition(AbstractDeviceInfoTab.this.taStatusLog.getDocument().getLength());
                }
            }
        }

        @Override
        public void userRequestEnd() {
        }

        @Override
        public void userRequestStart() {
        }
    };
    boolean wasVisibleBefore = false;

    public AbstractDeviceInfoTab(DeviceManager deviceManager) {
        this.deviceManager = deviceManager;
        this.dluX2Pixels = Sizes.DLUX2.getPixelSize((Component)this);
        this.setTabName(this.getDeviceTabName());
        this.setToolTip(this.getDeviceTabToolTip());
        deviceManager.addDeviceListener(this.deviceListener);
    }

    protected abstract String getDeviceTabName();

    protected abstract String getDeviceTabToolTip();

    protected abstract JComponent buildBtnStackPanel();

    protected abstract JComponent buildDeviceStatusPanel();

    protected abstract void populateStatusLabels();

    protected void connectStatusChanged(boolean bl) {
        this.populateStatusLabels();
    }

    @Override
    public void setVisible(boolean bl) {
        if (!this.wasVisibleBefore && bl) {
            this.wasVisibleBefore = true;
            SwingInvokeUtils.requestFocusInWindowLater(this.connectBtn);
        }
        super.setVisible(bl);
    }

    @Override
    public void tabRemoved() {
        super.tabRemoved();
        if (this.isMainDevice) {
            this.mainModel.setMainDeviceTabShown(false);
        } else {
            this.mainModel.setAuxDeviceTabShown(false);
        }
        this.deviceManager.removeDeviceListener(this.deviceListener);
    }

    protected void build() {
        this.setLayout(new BorderLayout(0, 0));
        this.setBorder(Borders.TABBED_DIALOG_BORDER);
        this.add((Component)this.buildTopLevelCenterPanel(), "Center");
        this.add((Component)this.buildTopLevelSouthPanel(), "South");
        MainModel.getInstance().getFilenameModel().addPropertyChangeListener(this.filenameModelListener);
    }

    protected JComponent buildTopLevelSouthPanel() {
        FormLayout formLayout = new FormLayout("f:d:g, 3dlu, p", "p, 2dlu, f:d:g");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Device Status", cellConstraints.xyw(1, 1, 3));
        this.taStatusLog = new JTextArea();
        this.taStatusLog.setRows(8);
        this.taStatusLog.setTabSize(4);
        this.taStatusLog.setAutoscrolls(true);
        this.taStatusLog.setEditable(false);
        this.spStatusLog = new JScrollPane(this.taStatusLog);
        panelBuilder.add((Component)this.spStatusLog, cellConstraints.xy(1, 3));
        Logger.getLogger("").addHandler(new Handler(){

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void publish(LogRecord logRecord) {
                int n = logRecord.getLevel().intValue();
                if (n < Level.WARNING.intValue()) {
                    return;
                }
                JTextArea jTextArea = AbstractDeviceInfoTab.this.taStatusLog;
                synchronized (jTextArea) {
                    AbstractDeviceInfoTab.this.taStatusLog.append("LOG MSG: " + logRecord.getMessage() + "\n");
                }
            }
        });
        JComponent jComponent = this.buildDeviceStatusPanel();
        jComponent.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(this.dluX2Pixels, this.dluX2Pixels, this.dluX2Pixels, this.dluX2Pixels)));
        panelBuilder.add((Component)jComponent, cellConstraints.xy(3, 3));
        return panelBuilder.getPanel();
    }

    protected JComponent buildTopLevelCenterPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.buildButtonAndDatalogPanel(), "Center");
        return DialogUtil.createLayeredPane(this.buildIconPanel(), jPanel);
    }

    protected JComponent buildMainCenterPanel() {
        return this.buildDatalogPanel();
    }

    protected JComponent buildDatalogPanel() {
        FormLayout formLayout = new FormLayout("f:d:g", "p, 2dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Datalogs", cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.buildDatalogSubpanel(), cellConstraints.xy(1, 3));
        return panelBuilder.getPanel();
    }

    protected JComponent buildDatalogSubpanel() {
        FormLayout formLayout = new FormLayout("r:d, 3dlu, f:d:g", "d, 2dlu, f:d");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addLabel("Next file:", cellConstraints.xy(1, 1));
        this.tfDatalogDirectory = new JTextField();
        this.tfDatalogDirectory.setEnabled(false);
        panelBuilder.add((Component)this.tfDatalogDirectory, cellConstraints.xy(3, 1));
        this.updateDatalogFilename();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.getLayout().setRowSpec(1, new RowSpec("f:d"));
        buttonBarBuilder.addGridded((JComponent)DialogUtil.createListButton("openFilenamePreferences", false));
        buttonBarBuilder.addGridded((JComponent)DialogUtil.createListButton("startStream", false));
        buttonBarBuilder.addGridded((JComponent)DialogUtil.createListButton("startCapture", false));
        buttonBarBuilder.addGridded((JComponent)DialogUtil.createListButton("openFile", true));
        panelBuilder.add((Component)buttonBarBuilder.getPanel(), cellConstraints.xy(3, 3));
        return panelBuilder.getPanel();
    }

    protected void updateDatalogFilename() {
        FilenameModel filenameModel = MainModel.getInstance().getFilenameModel();
        File file = filenameModel.createNewAutoDatalogFile(false, "elg");
        this.tfDatalogDirectory.setText(file.getAbsolutePath());
    }

    protected JComponent buildButtonAndDatalogPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(Sizes.DLUX8.getPixelSize((Component)this), 0));
        JComponent jComponent = this.buildMainCenterPanel();
        jPanel.add((Component)jComponent, "Center");
        JComponent jComponent2 = this.buildBtnColumn();
        jPanel.add((Component)jComponent2, "West");
        return jPanel;
    }

    private JComponent buildBtnColumn() {
        JPanel jPanel = new JPanel(new BorderLayout(0, Sizes.DLUX8.getPixelSize((Component)this)));
        JComponent jComponent = this.buildBtnStackPanel();
        jComponent.setBorder(new CompoundBorder(new EtchedBorder(), new EmptyBorder(this.dluX2Pixels, this.dluX2Pixels, this.dluX2Pixels, this.dluX2Pixels)));
        jPanel.add((Component)jComponent, "West");
        return jPanel;
    }

    private JPanel buildIconPanel() {
        JPanel jPanel = new JPanel((LayoutManager)new FormLayout("f:d:g", "f:d:g"));
        jPanel.setOpaque(false);
        try {
            ImageIcon imageIcon = ResourceUtils.getIcon((String)"aboutDialog.icon");
            BufferedImage bufferedImage = new BufferedImage(imageIcon.getIconWidth(), imageIcon.getIconHeight(), 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.2f));
            graphics2D.drawImage(imageIcon.getImage(), 0, 0, null);
            graphics2D.dispose();
            JLabel jLabel = new JLabel(new ImageIcon(bufferedImage));
            jPanel.add((Component)jLabel, new CellConstraints(1, 1, CellConstraints.RIGHT, CellConstraints.BOTTOM));
        }
        catch (Exception exception) {
            jPanel.add((Component)new JLabel("iconerr"), new CellConstraints(1, 1, CellConstraints.RIGHT, CellConstraints.BOTTOM));
        }
        return jPanel;
    }
}

