/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control;

import com.ecmtuning.ecmlink.control.DeviceUIAdapterInterface;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceManagerFactory;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class DeviceUIController
implements PropertyChangeListener {
    private DeviceUIAdapterInterface mainAdapter;
    private DeviceUIAdapterInterface auxAdapter;
    private Logger logger = Logger.getLogger(DeviceUIController.class.getName());
    private static Collection knownAdapters = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addKnownUIAdapter(DeviceUIAdapterInterface deviceUIAdapterInterface) {
        Collection collection = knownAdapters;
        synchronized (collection) {
            if (!knownAdapters.contains(deviceUIAdapterInterface)) {
                knownAdapters.add(deviceUIAdapterInterface);
            }
        }
    }

    public void initEventHandling() {
        DeviceManagerFactory deviceManagerFactory = DeviceManagerFactory.getInstance();
        deviceManagerFactory.addPropertyChangeListener("mainDeviceManager", this);
        deviceManagerFactory.addPropertyChangeListener("auxDeviceManager", this);
    }

    public boolean openFile(File file) {
        boolean bl = false;
        Iterator iterator = knownAdapters.iterator();
        while (!bl && iterator.hasNext()) {
            DeviceUIAdapterInterface deviceUIAdapterInterface = (DeviceUIAdapterInterface)iterator.next();
            if (!deviceUIAdapterInterface.openFile(file)) continue;
            bl = true;
        }
        return bl;
    }

    public DeviceUIAdapterInterface getMainAdapter() {
        return this.mainAdapter;
    }

    public DeviceUIAdapterInterface getAuxAdapter() {
        return this.auxAdapter;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("mainDeviceManager".equals(propertyChangeEvent.getPropertyName())) {
            if (this.mainAdapter != null) {
                this.logger.warning("Set new main adapter while old still existed!");
                return;
            }
            this.mainAdapter = this.installNewAdapter((DeviceManager)((Object)propertyChangeEvent.getNewValue()));
        } else if ("auxDeviceManager".equals(propertyChangeEvent.getPropertyName())) {
            if (this.auxAdapter != null) {
                this.logger.warning("Set new aux adapter while old still existed!");
                return;
            }
            this.auxAdapter = this.installNewAdapter((DeviceManager)((Object)propertyChangeEvent.getNewValue()));
        }
    }

    public List getGraphViewEditActions(DatalogTab datalogTab, boolean bl) {
        ArrayList arrayList = new ArrayList();
        if (datalogTab.isLiveView()) {
            List list;
            if (this.mainAdapter != null && (list = this.mainAdapter.getGraphViewEditActions(datalogTab, bl)) != null) {
                arrayList.addAll(list);
            }
            if (this.auxAdapter != null && (list = this.auxAdapter.getGraphViewEditActions(datalogTab, bl)) != null) {
                arrayList.addAll(list);
            }
        } else {
            int n = this.getMainDeviceId(datalogTab);
            int n2 = this.getAuxDeviceId(datalogTab);
            for (DeviceUIAdapterInterface deviceUIAdapterInterface : knownAdapters) {
                List list;
                if (!deviceUIAdapterInterface.supportsDeviceId(n) && !deviceUIAdapterInterface.supportsDeviceId(n2) || (list = deviceUIAdapterInterface.getGraphViewEditActions(datalogTab, bl)) == null) continue;
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    private int getMainDeviceId(DatalogTab datalogTab) {
        DeviceConfigData deviceConfigData = datalogTab.getDataset().getMainConfigData();
        if (deviceConfigData == null) {
            return 0;
        }
        return deviceConfigData.getDeviceId();
    }

    private int getAuxDeviceId(DatalogTab datalogTab) {
        DeviceConfigData deviceConfigData = datalogTab.getDataset().getAuxConfigData();
        if (deviceConfigData == null) {
            return 0;
        }
        return deviceConfigData.getDeviceId();
    }

    public List getGraphViewExtActions(DatalogTab datalogTab) {
        ArrayList arrayList = new ArrayList();
        if (datalogTab.isLiveView()) {
            List list;
            if (this.mainAdapter != null && (list = this.mainAdapter.getGraphViewExtActions(datalogTab)) != null) {
                arrayList.addAll(list);
            }
            if (this.auxAdapter != null && (list = this.auxAdapter.getGraphViewExtActions(datalogTab)) != null) {
                arrayList.addAll(list);
            }
        } else {
            int n = this.getMainDeviceId(datalogTab);
            int n2 = this.getAuxDeviceId(datalogTab);
            for (DeviceUIAdapterInterface deviceUIAdapterInterface : knownAdapters) {
                List list;
                if (!deviceUIAdapterInterface.supportsDeviceId(n) && !deviceUIAdapterInterface.supportsDeviceId(n2) || (list = deviceUIAdapterInterface.getGraphViewExtActions(datalogTab)) == null) continue;
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    public static DeviceUIAdapterInterface findAdapterFor(DeviceManager deviceManager) {
        if (deviceManager == null) {
            return null;
        }
        DeviceUIAdapterInterface deviceUIAdapterInterface = null;
        Iterator iterator = knownAdapters.iterator();
        while (deviceUIAdapterInterface == null && iterator.hasNext()) {
            DeviceUIAdapterInterface deviceUIAdapterInterface2 = (DeviceUIAdapterInterface)iterator.next();
            if (!deviceUIAdapterInterface2.accept(deviceManager)) continue;
            deviceUIAdapterInterface = deviceUIAdapterInterface2;
        }
        return deviceUIAdapterInterface;
    }

    private DeviceUIAdapterInterface installNewAdapter(DeviceManager deviceManager) {
        DeviceUIAdapterInterface deviceUIAdapterInterface = DeviceUIController.findAdapterFor(deviceManager);
        if (SwingUtilities.isEventDispatchThread()) {
            this.swapAdapterIn(deviceUIAdapterInterface);
        } else {
            try {
                SwingUtilities.invokeAndWait(new SwapThread(deviceUIAdapterInterface));
            }
            catch (InterruptedException interruptedException) {
                this.logger.warning("Internal error: invokeAndWait interrupted");
            }
            catch (InvocationTargetException invocationTargetException) {
                this.logger.warning("Internal error: invokeAndWait " + (invocationTargetException.getCause() == null ? invocationTargetException : invocationTargetException.getCause()));
            }
        }
        return deviceUIAdapterInterface;
    }

    void swapAdapterIn(DeviceUIAdapterInterface deviceUIAdapterInterface) {
        if (deviceUIAdapterInterface != null) {
            deviceUIAdapterInterface.activate();
        }
    }

    class SwapThread
    implements Runnable {
        DeviceUIAdapterInterface newAdapter;

        SwapThread(DeviceUIAdapterInterface deviceUIAdapterInterface) {
            this.newAdapter = deviceUIAdapterInterface;
        }

        @Override
        public void run() {
            DeviceUIController.this.swapAdapterIn(this.newAdapter);
        }
    }
}

