/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control;

import com.ecmtuning.ecmlink.control.DeviceUIController;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DatasetManager;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.view.main.CapturedValuesDialog;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.ecmtuning.ecmlink.view.main.MainAboutToolPanel;
import com.ecmtuning.ecmlink.view.main.MainResources;
import com.ecmtuning.ecmlink.view.preferences.PreferencesDialog;
import com.jgoodies.binding.beans.PropertyAdapter;
import com.jgoodies.binding.value.ValueModel;
import com.jgoodies.uif.AbstractDialog;
import com.jgoodies.uif.action.ActionManager;
import com.jgoodies.uif.action.ToggleAction;
import com.jgoodies.uif.application.Application;
import com.jgoodies.uif.lazy.Preparable;
import com.jgoodies.uifextras.convenience.DefaultAboutDialog;
import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class MainActions {
    public static final String OPEN_FILE_ID = "openFile";
    public static final String EXPORT_FILE_ID = "exportFile";
    public static final String SAVE_FILE_ID = "saveFile";
    public static final String SAVE_FILE_AS_ID = "saveFileAs";
    public static final String CLOSE_FILE_ID = "closeFile";
    public static final String EXIT_APP_ID = "exitApp";
    public static final String CLIP_SELECTION_ID = "clipSelection";
    public static final String SELECT_ALL_ID = "selectAll";
    public static final String SELECT_NONE_ID = "selectNone";
    public static final String FIND_ID = "find";
    public static final String FIND_NEXT_ID = "findNext";
    public static final String OPEN_PREFERENCES_ID = "openPreferences";
    public static final String OPEN_FILENAME_PREFERENCES_ID = "openFilenamePreferences";
    public static final String OPEN_UNITS_PREFERENCES_ID = "openUnitsPreferences";
    public static final String EDIT_DISPLAY_VALUES_ID = "displayValues";
    public static final String EDIT_CAPTURED_VALUES_ID = "capturedValues";
    public static final String SHOW_MAIN_DEVICE_TAB_ID = "showMainDeviceTab";
    public static final String SHOW_AUX_DEVICE_TAB_ID = "showAuxDeviceTab";
    public static final String OPEN_HELP_CONTENTS_ID = "openHelpContents";
    public static final String OPEN_ABOUT_DIALOG_ID = "openAboutDialog";
    public static final String START_CAPTURE_ID = "startCapture";
    public static final String STOP_CAPTURE_ID = "stopCapture";
    public static final String START_STREAM_ID = "startStream";
    public static final String STOP_STREAM_ID = "stopStream";
    public static final String SHOW_LIVE_DATALOG_TAB_ID = "showLiveDatalogTab";
    public static final String SHOW_TOOLBAR_ID = "showToolbar";
    public static final String PREV_TAB_ID = "prevTab";
    public static final String NEXT_TAB_ID = "nextTab";
    public static final String CLOSE_TAB_ID = "closeTab";
    protected MainModel mainModel;
    private static final Logger logger = Logger.getLogger(MainActions.class.getName());
    Hashtable actionHooks = new Hashtable();
    Hashtable actionHooksRestoreText = new Hashtable();
    ChangeListener tabSelectionListener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            int n = MainActions.this.mainModel.getTabPanelSelectionModel().getSelectedIndex();
            MainActions.getAction(MainActions.CLOSE_TAB_ID).setEnabled(n != -1);
            boolean bl = MainActions.this.mainModel.getMainView().getTabbedPane().getTabCount() > 1;
            MainActions.getAction(MainActions.PREV_TAB_ID).setEnabled(bl);
            MainActions.getAction(MainActions.NEXT_TAB_ID).setEnabled(bl);
        }
    };
    PropertyChangeListener streamListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            String string = MainActions.START_STREAM_ID;
            String string2 = MainActions.START_CAPTURE_ID;
            if (bl) {
                string = MainActions.STOP_STREAM_ID;
                string2 = MainActions.STOP_CAPTURE_ID;
            }
            Action action = MainActions.getAction(MainActions.START_STREAM_ID);
            Action action2 = MainActions.getAction(MainActions.START_CAPTURE_ID);
            MainResources.configureAction(action, string);
            MainResources.configureAction(action2, string2);
            ((DispatchingAction)action).setId(string);
            ((DispatchingAction)action2).setId(string2);
            MainActions.getAction(MainActions.EDIT_CAPTURED_VALUES_ID).setEnabled(!bl);
        }
    };
    public static final Action CLOSE_TAB_ACTION = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainModel.getInstance().closeCurrentTab();
        }
    };
    String openDirectoryPropName = "lastAccessDirectory";
    JFileChooser chooser = null;

    public MainActions() {
        this.mainModel = MainModel.getInstance();
        this.mainModel.getTabPanelSelectionModel().addChangeListener(this.tabSelectionListener);
        DatasetManager.getInstance().addPropertyChangeListener("streaming", this.streamListener);
        this.registerActions();
    }

    public static Action getAction(String string) {
        return ActionManager.get((String)string);
    }

    public Preparable createInitializer() {
        return new EagerInitializer(this);
    }

    public String setOpenDirectoryPropName(String string) {
        String string2 = this.openDirectoryPropName;
        this.openDirectoryPropName = string;
        return string2;
    }

    public void installActionHook(String string, Action action, String string2) {
        if (action == null) {
            return;
        }
        this.actionHooks.put(string, action);
        Action action2 = MainActions.getAction(string);
        action2.setEnabled(true);
        Object object = action2.getValue("ShortDescription");
        if (object != null) {
            this.actionHooksRestoreText.put(string, object);
        }
        action2.putValue("ShortDescription", string2 == null ? "" : string2);
    }

    public void installActionHook(String string, Action action) {
        Action action2;
        String string2 = (String)action.getValue("ShortDescription");
        if ((string2 == null || string2.trim().length() == 0) && (action2 = MainActions.getAction(string)) != null) {
            string2 = (String)action2.getValue("ShortDescription");
        }
        this.installActionHook(string, action, string2 == null ? "" : string2);
    }

    public void uninstallActionHook(String string) {
        if (this.actionHooks.remove(string) != null) {
            Action action = MainActions.getAction(string);
            action.setEnabled(false);
            Object v = this.actionHooksRestoreText.remove(string);
            action.putValue("ShortDescription", v == null ? "" : v.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleTask(Task task, boolean bl, Component component) {
        DialogUtil.disableAllInput(component);
        try {
            if (bl) {
                Worker.post((Task)task);
            } else {
                task.run();
            }
        }
        catch (Exception exception) {
            if (exception instanceof ClassCastException) {
                logger.log(Level.WARNING, "Unexpected exception", exception);
                JOptionPane.showMessageDialog(component, "An unexpected error occurred: 100");
            } else if (exception instanceof NullPointerException) {
                logger.log(Level.WARNING, "Unexpected exception", exception);
                JOptionPane.showMessageDialog(component, "An unexpected error occurred: 101");
            } else if (exception instanceof IndexOutOfBoundsException) {
                logger.log(Level.WARNING, "Unexpected exception", exception);
                JOptionPane.showMessageDialog(component, "An unexpected error occurred: 102");
            } else if (exception instanceof EOFException) {
                logger.log(Level.WARNING, "Unexpected exception", exception);
                JOptionPane.showMessageDialog(component, "An unexpected end of file was reached.");
            } else {
                logger.log(Level.WARNING, "Action raised exception", exception);
                JOptionPane.showMessageDialog(component, exception.getLocalizedMessage());
            }
        }
        finally {
            DialogUtil.reenableAllInput(component);
        }
    }

    public static void handleMainFrameTask(Task task, boolean bl) {
        MainActions.handleTask(task, bl, MainModel.getDefaultParentFrame().getGlassPane());
    }

    public JFileChooser getSharedChooser(String string) {
        FileFilter[] fileFilterArray;
        if (this.chooser == null) {
            this.chooser = new JFileChooser(string);
            this.chooser.addChoosableFileFilter(this.chooser.getAcceptAllFileFilter());
            fileFilterArray = FilenameModel.getSupportedFileFilters();
            for (int i = 0; i < fileFilterArray.length; ++i) {
                this.chooser.addChoosableFileFilter(fileFilterArray[i]);
            }
            this.chooser.setDialogTitle("Load ECMLink File");
            this.chooser.setMultiSelectionEnabled(true);
            this.chooser.setSelectedFile(null);
        }
        fileFilterArray = this.chooser;
        this.chooser = null;
        return fileFilterArray;
    }

    protected void doOpenFile() {
        FilenameModel filenameModel = this.mainModel.getFilenameModel();
        String string = filenameModel.getLastAccessDirectory();
        JFileChooser jFileChooser = this.getSharedChooser(string);
        int n = jFileChooser.showOpenDialog(MainModel.getDefaultParentFrame());
        if (n == 0) {
            File[] fileArray = jFileChooser.getSelectedFiles();
            this.openFiles(fileArray, false);
        }
    }

    public void openFiles(File[] fileArray, boolean bl) {
        FilenameModel filenameModel = this.mainModel.getFilenameModel();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            String string = file.getName().trim().toLowerCase();
            boolean bl2 = false;
            if (string.endsWith("elg")) {
                MainActions.handleMainFrameTask(new OpenDatalogTask(file), false);
                bl2 = true;
            } else {
                DeviceUIController deviceUIController = this.mainModel.getDeviceUIController();
                if (deviceUIController.openFile(file)) {
                    bl2 = true;
                } else {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(file.getName());
                }
            }
            if (!bl2 || bl && !filenameModel.getRememberLastAutoOpen()) continue;
            filenameModel.setLastAccessDirectory(file.getParent());
        }
        if (stringBuffer.length() > 0) {
            if (stringBuffer.length() > 40) {
                stringBuffer.setLength(40);
                stringBuffer.append("...");
            }
            MainModel.showInfoMessage("Unrecognized: " + stringBuffer.toString());
        }
    }

    protected void doOpenPreferencesDialog() {
        new PreferencesDialog(Application.getDefaultParentFrame()).open();
    }

    protected void doOpenFilenamePreferencesDialog() {
        new PreferencesDialog(Application.getDefaultParentFrame(), 2).open();
    }

    protected void doOpenUnitsPreferencesDialog() {
        new PreferencesDialog(Application.getDefaultParentFrame(), 1).open();
    }

    protected void doEditCapturedValues() throws Exception {
        if (DatasetManager.getInstance().isStreaming()) {
            JOptionPane.showMessageDialog(MainModel.getDefaultParentFrame(), "Can't edit captured values while streaming data.");
            return;
        }
        AbstractDialog abstractDialog = (AbstractDialog)Worker.post((Task)new Task(){

            public Object run() throws Exception {
                return new CapturedValuesDialog(Application.getDefaultParentFrame());
            }
        });
        abstractDialog.open();
    }

    protected void doOpenAboutDialog() {
        this.buildAboutDialog().open();
    }

    protected DefaultAboutDialog buildAboutDialog() {
        MainAboutToolPanel mainAboutToolPanel = new MainAboutToolPanel(this.mainModel);
        mainAboutToolPanel.build();
        DefaultAboutDialog defaultAboutDialog = new DefaultAboutDialog(MainModel.getDefaultParentFrame(), (JComponent)((Object)mainAboutToolPanel)){

            public void close() {
                ((MainAboutToolPanel)((Object)this.toolTab)).stopAnimation();
                super.close();
            }

            protected void setResizable() {
                this.setResizable(true);
            }
        };
        return defaultAboutDialog;
    }

    protected void doUnknown(String string) {
        MainModel.showInfoMessage(this.getClass().getName() + "." + string);
    }

    protected void doStartStream() throws IOException, DeviceException {
        DatasetManager datasetManager = DatasetManager.getInstance();
        if (datasetManager.isStreaming()) {
            logger.warning("Start stream attempted while data was already streaming from device");
            return;
        }
        datasetManager.getLiveMainTOC();
        datasetManager.getLiveAuxTOC();
        this.mainModel.setLiveDatalogTabShown(true);
        datasetManager.setStreaming(true);
    }

    protected void doStopStream() throws IOException, DeviceException {
        DatasetManager datasetManager = DatasetManager.getInstance();
        datasetManager.setStreaming(false);
    }

    protected void doStopCapture() throws IOException, DeviceException {
        try {
            DatasetManager datasetManager = DatasetManager.getInstance();
            Dataset dataset = datasetManager.getLiveDataset();
            if (dataset.getLiveDatalog() == null) {
                this.establishNewStreamFile(this.createAndTestNewAutoDatalogFile());
            }
        }
        finally {
            this.doStopStream();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStartCapture() throws IOException, DeviceException {
        DatasetManager datasetManager = DatasetManager.getInstance();
        if (datasetManager.isStreaming()) {
            logger.warning("Start capture attempted while data was already streaming from device");
            return;
        }
        File file = this.createAndTestNewAutoDatalogFile();
        datasetManager.resetLiveDataset();
        this.establishNewStreamFile(file);
        this.mainModel.setLiveDatalogTabShown(true);
        boolean bl = false;
        try {
            datasetManager.setStreaming(true);
            bl = true;
        }
        finally {
            if (!bl) {
                Dataset dataset = datasetManager.getLiveDataset();
                dataset.closeFileStream();
            }
        }
    }

    private void establishNewStreamFile(File file) throws IOException {
        DatalogTab datalogTab = DatalogTab.getOrCreateLiveTab();
        DatalogFile datalogFile = datalogTab.createDatalogFile(file);
        datalogTab.setLastSavedDatalog(datalogFile);
        datalogFile.writeToFile(null);
    }

    private File createAndTestNewAutoDatalogFile() throws IOException {
        FilenameModel filenameModel = MainModel.getInstance().getFilenameModel();
        File file = filenameModel.createNewAutoDatalogFile(true, "elg");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IOException("Failed to create new file: " + fileNotFoundException.getLocalizedMessage());
        }
        try {
            file.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return file;
    }

    private void addNewTab(TrackedTabPanel trackedTabPanel) {
        this.mainModel.addTab(trackedTabPanel, true);
    }

    void registerActions() {
        this.registerEnabled(OPEN_FILE_ID);
        this.registerDisabled(EXPORT_FILE_ID);
        this.registerDisabled(SAVE_FILE_ID);
        this.registerDisabled(SAVE_FILE_AS_ID);
        this.registerDisabled(CLOSE_FILE_ID);
        this.registerEnabled(EXIT_APP_ID);
        this.registerDisabled(CLIP_SELECTION_ID);
        this.registerDisabled(SELECT_ALL_ID);
        this.registerDisabled(SELECT_NONE_ID);
        this.registerDisabled(FIND_ID);
        this.registerDisabled(FIND_NEXT_ID);
        this.registerEnabled(OPEN_PREFERENCES_ID);
        this.registerEnabled(OPEN_FILENAME_PREFERENCES_ID);
        this.registerEnabled(OPEN_UNITS_PREFERENCES_ID);
        this.registerDisabled(EDIT_DISPLAY_VALUES_ID);
        this.registerEnabled(EDIT_CAPTURED_VALUES_ID);
        this.registerEnabled(START_CAPTURE_ID, true);
        this.registerEnabled(STOP_CAPTURE_ID, true);
        this.registerEnabled(START_STREAM_ID, true);
        this.registerEnabled(STOP_STREAM_ID, true);
        this.registerEnabled(OPEN_HELP_CONTENTS_ID);
        PropertyAdapter propertyAdapter = new PropertyAdapter((Object)this.mainModel, "mainDeviceTabShown", true);
        ActionManager.register((String)SHOW_MAIN_DEVICE_TAB_ID, (Action)ToggleAction.createCheck((ValueModel)propertyAdapter));
        propertyAdapter = new PropertyAdapter((Object)this.mainModel, "auxDeviceTabShown", true);
        ActionManager.register((String)SHOW_AUX_DEVICE_TAB_ID, (Action)ToggleAction.createCheck((ValueModel)propertyAdapter));
        propertyAdapter = new PropertyAdapter((Object)this.mainModel, "liveDatalogTabShown", true);
        ActionManager.register((String)SHOW_LIVE_DATALOG_TAB_ID, (Action)ToggleAction.createCheck((ValueModel)propertyAdapter));
        propertyAdapter = new PropertyAdapter((Object)this.mainModel, SHOW_TOOLBAR_ID, true);
        ActionManager.register((String)SHOW_TOOLBAR_ID, (Action)ToggleAction.createCheck((ValueModel)propertyAdapter));
        this.registerEnabled(OPEN_ABOUT_DIALOG_ID);
        this.registerDisabled(PREV_TAB_ID);
        this.registerDisabled(NEXT_TAB_ID);
        this.registerDisabled(CLOSE_TAB_ID);
    }

    Action registerEnabled(String string) {
        return this.register(string, true, false);
    }

    Action registerDisabled(String string) {
        return this.register(string, false, false);
    }

    Action registerEnabled(String string, boolean bl) {
        return this.register(string, true, bl);
    }

    Action registerDisabled(String string, boolean bl) {
        return this.register(string, false, bl);
    }

    Action register(String string, boolean bl, boolean bl2) {
        Action action = ActionManager.register((String)string, (Action)new DispatchingAction(string, bl2), (ResourceBundle)MainResources.getActionBundle());
        action.setEnabled(bl);
        return action;
    }

    void dispatchActionEvent(String string, ActionEvent actionEvent) throws Exception {
        Action action = (Action)this.actionHooks.get(string);
        if (action != null) {
            action.actionPerformed(actionEvent);
            return;
        }
        if (string.equals(OPEN_FILE_ID)) {
            this.doOpenFile();
        } else if (string.equals(START_STREAM_ID)) {
            this.doStartStream();
        } else if (string.equals(STOP_STREAM_ID)) {
            this.doStopStream();
        } else if (string.equals(START_CAPTURE_ID)) {
            this.doStartCapture();
        } else if (string.equals(STOP_CAPTURE_ID)) {
            this.doStopCapture();
        } else if (string.equals(OPEN_PREFERENCES_ID)) {
            this.doOpenPreferencesDialog();
        } else if (string.equals(OPEN_FILENAME_PREFERENCES_ID)) {
            this.doOpenFilenamePreferencesDialog();
        } else if (string.equals(OPEN_UNITS_PREFERENCES_ID)) {
            this.doOpenUnitsPreferencesDialog();
        } else if (string.equals(EDIT_CAPTURED_VALUES_ID)) {
            this.doEditCapturedValues();
        } else if (string.equals(EXIT_APP_ID)) {
            this.mainModel.aboutToExitApplication();
        } else if (string.equals(OPEN_ABOUT_DIALOG_ID)) {
            this.doOpenAboutDialog();
        } else if (!string.equals(OPEN_HELP_CONTENTS_ID)) {
            if (string.equals(PREV_TAB_ID)) {
                this.mainModel.advanceTabSelection(false);
            } else if (string.equals(NEXT_TAB_ID)) {
                this.mainModel.advanceTabSelection(true);
            } else if (string.equals(CLOSE_TAB_ID)) {
                this.mainModel.closeCurrentTab();
            } else {
                this.doUnknown(string);
            }
        }
    }

    private final class DispatchingAction
    extends AbstractAction {
        private String id;
        private final boolean background;

        private DispatchingAction(String string, boolean bl) {
            this.id = string;
            this.background = bl;
        }

        public void setId(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new BackgroundTask(this.id, actionEvent), this.background);
        }

        public class BackgroundTask
        extends Task {
            final String id;
            final ActionEvent event;

            BackgroundTask(String string, ActionEvent actionEvent) {
                this.id = string;
                this.event = actionEvent;
            }

            public Object run() throws Exception {
                MainActions.this.dispatchActionEvent(this.id, this.event);
                return null;
            }
        }
    }

    class OpenDatalogTask
    extends Task {
        final File file;

        public OpenDatalogTask(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            DatalogFile datalogFile = DatalogFile.load(this.file);
            FilenameModel filenameModel = MainActions.this.mainModel.getFilenameModel();
            DatalogTab datalogTab = new DatalogTab(datalogFile);
            MainActions.this.addNewTab(datalogTab);
            return null;
        }
    }

    static class EagerInitializer
    implements Preparable {
        private final MainActions mainActions;
        private final MainModel mainModel;

        EagerInitializer(MainActions mainActions) {
            this.mainActions = mainActions;
            this.mainModel = mainActions.mainModel;
        }

        public void prepare() {
            try {
                this.mainModel.getHelpBroker().initPresentation();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            new PreferencesDialog(Application.getDefaultParentFrame()).initPresentation();
            this.mainActions.buildAboutDialog();
        }
    }
}

