/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control;

import com.ecmtuning.ecmlink.control.DeviceUIAdapterInterface;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class MainPanelController {
    private MainModel mainModel = MainModel.getInstance();
    protected TrackedTabPanel mainDeviceTab;
    protected TrackedTabPanel auxDeviceTab;

    public void initEventHandling() {
        this.mainModel.addPropertyChangeListener("mainDeviceTabShown", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (MainPanelController.this.mainModel.getMainDeviceTabShown()) {
                    MainPanelController.this.showMainDeviceTab();
                } else {
                    MainPanelController.this.closeMainDeviceTab();
                }
            }
        });
        this.mainModel.addPropertyChangeListener("auxDeviceTabShown", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (MainPanelController.this.mainModel.getAuxDeviceTabShown()) {
                    MainPanelController.this.showAuxDeviceTab();
                } else {
                    MainPanelController.this.closeAuxDeviceTab();
                }
            }
        });
        this.mainModel.addPropertyChangeListener("liveDatalogTabShown", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (MainPanelController.this.mainModel.getLiveDatalogTabShown()) {
                    MainPanelController.this.showLiveDatalogTab();
                } else {
                    MainPanelController.this.closeLiveDatalogTab();
                }
            }
        });
    }

    protected synchronized void showMainDeviceTab() {
        DeviceUIAdapterInterface deviceUIAdapterInterface = this.mainModel.getDeviceUIController().getMainAdapter();
        if (deviceUIAdapterInterface == null) {
            return;
        }
        if (this.mainDeviceTab == null) {
            this.mainDeviceTab = deviceUIAdapterInterface.createDeviceInfoTab();
        }
        this.mainModel.addOrMakeActiveTab(this.mainDeviceTab, true);
    }

    protected synchronized void closeMainDeviceTab() {
        this.mainModel.findAndCloseTab(this.mainDeviceTab);
        this.mainDeviceTab = null;
    }

    protected synchronized void showAuxDeviceTab() {
        DeviceUIAdapterInterface deviceUIAdapterInterface = this.mainModel.getDeviceUIController().getAuxAdapter();
        if (deviceUIAdapterInterface == null) {
            return;
        }
        if (this.auxDeviceTab == null) {
            this.auxDeviceTab = deviceUIAdapterInterface.createDeviceInfoTab();
        }
        this.mainModel.addOrMakeActiveTab(this.auxDeviceTab, true);
    }

    protected synchronized void closeAuxDeviceTab() {
        this.mainModel.findAndCloseTab(this.auxDeviceTab);
        this.auxDeviceTab = null;
    }

    protected synchronized void showLiveDatalogTab() {
        this.mainModel.addOrMakeActiveTab(DatalogTab.getOrCreateLiveTab(), false);
    }

    protected synchronized void closeLiveDatalogTab() {
        this.mainModel.findAndCloseTab(DatalogTab.getOrCreateLiveTab());
    }
}

