/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsUtils;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkUIAdapter;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceConfigData;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.ConfigRecordSet;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2DataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2RecordView;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV2Tab;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3DataAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3RecordView;
import com.ecmtuning.ecmlink.view.ecmlink.MAFV3Tab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;

class AdjustActionsMAFComp {
    static ECMLinkUIAdapter uiAdapter;
    static final int[] supportedMAFCompRecordIds;
    static final String MAF_FT_ADJ_REQ_NAMES = "CombinedFT, MAFRaw, and ClosedLoop";

    AdjustActionsMAFComp() {
    }

    static void addMafAdjActions(ECMLinkUIAdapter eCMLinkUIAdapter, DatalogTab datalogTab, List list) {
        Map map;
        ECMLinkDeviceConfigData eCMLinkDeviceConfigData;
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet;
        DeviceConfigData deviceConfigData;
        uiAdapter = eCMLinkUIAdapter;
        Dataset dataset = datalogTab.getDataset();
        if (dataset != null && (deviceConfigData = dataset.getMainConfigData()) != null && deviceConfigData instanceof ECMLinkDeviceConfigData && (eCMLinkConfigRecordSet = (eCMLinkDeviceConfigData = (ECMLinkDeviceConfigData)deviceConfigData).getConfigRecordSet()) != null && ConfigRecordSet.containsAnyRecordId(supportedMAFCompRecordIds, map = eCMLinkConfigRecordSet.getVolatileRecordMap())) {
            DoMafAdjCombFTAction doMafAdjCombFTAction = new DoMafAdjCombFTAction(datalogTab);
            ECMLinkResources.configureAction(doMafAdjCombFTAction, "ecmlinkMAFAdjCombFT");
            list.add(doMafAdjCombFTAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doMafFTAdj(DatalogTab datalogTab) throws IOException, DeviceException {
        Dataset dataset;
        if (!AdjustActionsUtils.showMessageAndContinue("ecmlink.mafadj.combft.msg")) {
            return;
        }
        Dataset dataset2 = dataset = datalogTab.getDataset();
        synchronized (dataset2) {
            List list = DisplayChain.generateDisplayChains(dataset.getMainDataTOC());
            DisplayChain displayChain = AdjustActionsUtils.findChainByLocalKeyOrShowError(list, "conv.sys.combinedft", MAF_FT_ADJ_REQ_NAMES);
            if (displayChain == null) {
                return;
            }
            DisplayChain displayChain2 = AdjustActionsUtils.findChainByLocalKeyOrShowError(list, "conv.ecmx.mafraw", MAF_FT_ADJ_REQ_NAMES);
            if (displayChain2 == null) {
                return;
            }
            DisplayChain displayChain3 = AdjustActionsUtils.findChainByLocalKeyOrShowError(list, "conv.ecmx.closedloop", MAF_FT_ADJ_REQ_NAMES);
            if (displayChain3 == null) {
                return;
            }
            SettingsTab settingsTab = uiAdapter.bringForthSettingsTab(datalogTab.getLastSavedDatalog(), datalogTab.isLiveView());
            if (settingsTab == null) {
                MainModel.showErrorMessage("Internal error: failed to find appropriate settings tab", "Error");
                return;
            }
            MAFV3Tab mAFV3Tab = (MAFV3Tab)settingsTab.bringTabForward(MAFV3Tab.class);
            MAFV2Tab mAFV2Tab = (MAFV2Tab)settingsTab.bringTabForward(MAFV2Tab.class);
            if (mAFV3Tab == null && mAFV2Tab == null) {
                MainModel.showErrorMessage("Internal error: failed to find V2 or V3 MAF compensation tab", "Error");
                return;
            }
            float[] fArray = null;
            fArray = mAFV3Tab != null ? AdjustActionsMAFComp.getV3MAFIndices(mAFV3Tab) : AdjustActionsMAFComp.getV2MAFIndices(mAFV2Tab);
            DisplaySet displaySet = new DisplaySet();
            float f = fArray[fArray.length - 1];
            int n = fArray.length;
            float[] fArray2 = new float[n];
            int[] nArray = new int[n];
            try {
                displaySet.registerModels(dataset, datalogTab.getConverterPrefs());
                ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
                arrayList.add(displayChain2);
                arrayList.add(displayChain);
                arrayList.add(displayChain3);
                displaySet.setDisplayChains(arrayList);
                ArrayList arrayList2 = displaySet.getDisplayPackets();
                for (int i = 0; i < n; ++i) {
                    fArray2[i] = 0.0f;
                    nArray[i] = 0;
                }
                MAFAdjRecord mAFAdjRecord = new MAFAdjRecord(fArray);
                for (TSDataPacket tSDataPacket : arrayList2) {
                    float[] fArray3 = tSDataPacket.data;
                    if (fArray3[2] == 1.0f) {
                        if (!mAFAdjRecord.loopStart(fArray3[0], fArray3[1])) continue;
                        if (mAFAdjRecord.getCombFTDirection() == 0) {
                            if (!mAFAdjRecord.hasConstFTStartTime()) {
                                mAFAdjRecord.setConstantFTStartTime(tSDataPacket.timestampMicros);
                                continue;
                            }
                            if (!(tSDataPacket.timestampMicros - mAFAdjRecord.getConstantFTStartTime() > 1000000.0)) continue;
                            AdjustActionsMAFComp.registerAdjustment(mAFAdjRecord, fArray2, nArray);
                            mAFAdjRecord.setConstantFTStartTime(tSDataPacket.timestampMicros);
                            continue;
                        }
                        mAFAdjRecord.clearConstantFTStartTime();
                        if (mAFAdjRecord.getLastCombFTDirection() == 0) {
                            mAFAdjRecord.setLastCombFTDirection(mAFAdjRecord.getCombFTDirection());
                            continue;
                        }
                        if (mAFAdjRecord.getLastCombFTDirection() == mAFAdjRecord.getCombFTDirection()) continue;
                        mAFAdjRecord.setLastCombFTDirection(mAFAdjRecord.getCombFTDirection());
                        mAFAdjRecord.incrSwitchCnt();
                        if (mAFAdjRecord.getSwitchCnt() <= 2) continue;
                        AdjustActionsMAFComp.registerAdjustment(mAFAdjRecord, fArray2, nArray);
                        continue;
                    }
                    mAFAdjRecord.reset();
                }
                for (int i = 0; i < n; ++i) {
                    if (nArray[i] <= 0) continue;
                    fArray2[i] = fArray2[i] / (float)nArray[i];
                }
            }
            finally {
                displaySet.deregisterModels();
            }
            if (mAFV3Tab != null) {
                AdjustActionsMAFComp.pushV3MAFAdjData(fArray2, mAFV3Tab);
            } else if (mAFV2Tab != null) {
                AdjustActionsMAFComp.pushV2MAFAdjData(fArray2, mAFV2Tab);
            } else {
                MainModel.showErrorMessage("Internal error: Failed to find MAFV3 tab", "Error");
                return;
            }
        }
    }

    private static void registerAdjustment(MAFAdjRecord mAFAdjRecord, float[] fArray, int[] nArray) {
        int n = mAFAdjRecord.getBucketIndex();
        fArray[n] = fArray[n] + mAFAdjRecord.getCurrCombFT();
        int n2 = mAFAdjRecord.getBucketIndex();
        nArray[n2] = nArray[n2] + 1;
    }

    static float[] getV3MAFIndices(MAFV3Tab mAFV3Tab) {
        MAFV3RecordView mAFV3RecordView = (MAFV3RecordView)mAFV3Tab.getBuiltView();
        return mAFV3RecordView.getDataAdapter().getXIndices();
    }

    static float[] getV2MAFIndices(MAFV2Tab mAFV2Tab) {
        MAFV2RecordView mAFV2RecordView = (MAFV2RecordView)mAFV2Tab.getBuiltView();
        return mAFV2RecordView.getDataAdapter().getXIndices();
    }

    static void pushV3MAFAdjData(float[] fArray, MAFV3Tab mAFV3Tab) {
        MAFV3RecordView mAFV3RecordView = (MAFV3RecordView)mAFV3Tab.getBuiltView();
        MAFV3DataAdapter mAFV3DataAdapter = mAFV3RecordView.getDataAdapter();
        float[] fArray2 = mAFV3DataAdapter.getPersistedValuesCopy();
        for (int i = 0; i < fArray.length; ++i) {
            float f = (fArray[i] + 100.0f) / 100.0f;
            fArray2[i] = (fArray2[i] + 100.0f) * f - 100.0f;
        }
        mAFV3DataAdapter.setGeneratedTemplateData(fArray2);
    }

    static void pushV2MAFAdjData(float[] fArray, MAFV2Tab mAFV2Tab) {
        MAFV2RecordView mAFV2RecordView = (MAFV2RecordView)mAFV2Tab.getBuiltView();
        MAFV2DataAdapter mAFV2DataAdapter = mAFV2RecordView.getDataAdapter();
        float[] fArray2 = mAFV2DataAdapter.getPersistedValuesCopy();
        for (int i = 0; i < fArray.length; ++i) {
            float f = (fArray[i] + 100.0f) / 100.0f;
            fArray2[i] = (fArray2[i] + 100.0f) * f - 100.0f;
        }
        mAFV2DataAdapter.setGeneratedTemplateData(fArray2);
    }

    static {
        supportedMAFCompRecordIds = new int[]{6, 15, 30, 38, 49};
    }

    static class MAFAdjRecord {
        private int bucketIndex;
        private int switchCnt;
        private int combFTDirection;
        private int lastCombFTDirection;
        private double constantFTStartTime;
        private float lastCombFT;
        private float currCombFT;
        private final float[] xIndices;
        private final int bucketCnt;

        public MAFAdjRecord(float[] fArray) {
            this.xIndices = fArray;
            this.bucketCnt = fArray.length;
            this.reset();
        }

        public void reset() {
            this.bucketIndex = -1;
            this.switchCnt = 0;
            this.lastCombFTDirection = 0;
            this.combFTDirection = 0;
            this.constantFTStartTime = 0.0;
            this.currCombFT = Float.MIN_VALUE;
            this.lastCombFT = Float.MIN_VALUE;
        }

        public boolean loopStart(float f, float f2) {
            int n = ListUtil.findClosestIndex(f, this.xIndices);
            if (n >= this.bucketCnt) {
                n = this.bucketCnt - 1;
            }
            if (this.bucketIndex == -1) {
                this.reset();
                this.bucketIndex = n;
                this.lastCombFT = this.currCombFT = f2;
                return false;
            }
            this.bucketIndex = n;
            this.lastCombFT = this.currCombFT;
            this.currCombFT = f2;
            this.combFTDirection = this.currCombFT > this.lastCombFT ? 1 : (this.currCombFT < this.lastCombFT ? -1 : 0);
            return true;
        }

        public boolean hasConstFTStartTime() {
            return this.constantFTStartTime > 0.0;
        }

        public int getBucketIndex() {
            return this.bucketIndex;
        }

        public int getSwitchCnt() {
            return this.switchCnt;
        }

        public void incrSwitchCnt() {
            ++this.switchCnt;
        }

        public int getCombFTDirection() {
            return this.combFTDirection;
        }

        public int getLastCombFTDirection() {
            return this.lastCombFTDirection;
        }

        public void setLastCombFTDirection(int n) {
            this.lastCombFTDirection = n;
        }

        public double getConstantFTStartTime() {
            return this.constantFTStartTime;
        }

        public void setConstantFTStartTime(double d) {
            this.constantFTStartTime = d;
        }

        public void clearConstantFTStartTime() {
            this.constantFTStartTime = 0.0;
        }

        public float getCurrCombFT() {
            return this.currCombFT;
        }

        public float getLastCombFT() {
            return this.lastCombFT;
        }
    }

    static class DoMafAdjCombFTAction
    extends AbstractAction {
        final DatalogTab datalogTab;

        DoMafAdjCombFTAction(DatalogTab datalogTab) {
            this.datalogTab = datalogTab;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new Task(){

                public Object run() throws Exception {
                    AdjustActionsMAFComp.doMafFTAdj(datalogTab);
                    return null;
                }
            }, false);
        }
    }
}

