/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsUtils;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkUIAdapter;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.DataPreferences;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.device.data.converter.ConverterPrefs;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceConfigData;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV3Record;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.SDRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.SDTab;
import com.ecmtuning.ecmlink.view.ecmlink.SDTableAdapter;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

class AdjustActionsSDVE {
    static ECMLinkUIAdapter uiAdapter;
    static final String VE_ADJ_SDRATIO_REQ_NAMES = "SDRatio, RPM, and MAP sensor";
    static final String VE_ADJ_COMBFT_REQ_NAMES = "CombinedFT, MAP sensor and ClosedLoop";

    AdjustActionsSDVE() {
    }

    static void addVEAdjActions(ECMLinkUIAdapter eCMLinkUIAdapter, DatalogTab datalogTab, List list) {
        ECMLinkDeviceConfigData eCMLinkDeviceConfigData;
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet;
        DeviceConfigData deviceConfigData;
        uiAdapter = eCMLinkUIAdapter;
        Dataset dataset = datalogTab.getDataset();
        if (dataset != null && (deviceConfigData = dataset.getMainConfigData()) != null && deviceConfigData instanceof ECMLinkDeviceConfigData && (eCMLinkConfigRecordSet = (eCMLinkDeviceConfigData = (ECMLinkDeviceConfigData)deviceConfigData).getConfigRecordSet()) != null && (eCMLinkConfigRecordSet.getVolatileRecord(42) != null || eCMLinkConfigRecordSet.getVolatileRecord(47) != null || eCMLinkConfigRecordSet.getVolatileRecord(48) != null)) {
            DoVEAdjSDRatioAction doVEAdjSDRatioAction = new DoVEAdjSDRatioAction(datalogTab, dataset);
            ECMLinkResources.configureAction(doVEAdjSDRatioAction, "ecmlinkVEAdjSDRatio");
            list.add(doVEAdjSDRatioAction);
            DoVEAdjCombFTAction doVEAdjCombFTAction = new DoVEAdjCombFTAction(datalogTab, dataset);
            ECMLinkResources.configureAction(doVEAdjCombFTAction, "ecmlinkVEAdjCombFT");
            list.add(doVEAdjCombFTAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doVEAdjSDRatio(DatalogTab datalogTab, Dataset dataset) throws IOException, DeviceException {
        if (!AdjustActionsUtils.showMessageAndContinue("ecmlink.veadj.sdratio.msg")) {
            return;
        }
        SDRecordModel sDRecordModel = AdjustActionsSDVE.showSDTab(datalogTab);
        if (sDRecordModel == null) {
            return;
        }
        Dataset dataset2 = dataset;
        synchronized (dataset2) {
            Object object;
            List list = DisplayChain.generateDisplayChains(dataset.getMainDataTOC(), false);
            DisplayChain displayChain = AdjustActionsUtils.findChainByOutputTypeOrShowError(list, "data.sys.rpm", VE_ADJ_SDRATIO_REQ_NAMES);
            if (displayChain == null) {
                return;
            }
            int n = ((Number)sDRecordModel.mdlPersistedMAPInputX.getValue()).intValue();
            if (n == 0) {
                MainModel.showErrorMessage("Input pin for MAP sensor has not been assigned.", "Error");
                return;
            }
            String string = MiscBitsV3Record.INPUT_X_TO_LOCNAME[n];
            if (string == null) {
                MainModel.showErrorMessage("Invalid input pin selected for MAP sensor.", "Error");
                return;
            }
            DisplayChain displayChain2 = null;
            List list2 = DisplayChain.findChainsByOutputType(list, "data.sys.airpsia");
            Object object2 = list2.iterator();
            while (object2.hasNext() && displayChain2 == null) {
                object = (DisplayChain)object2.next();
                if (!((DisplayChain)object).usesAssignedLocationName(string)) continue;
                displayChain2 = object;
            }
            if (displayChain2 == null) {
                MainModel.showErrorMessage("Can not find log item for MAP sensor in log file.", "Error");
                return;
            }
            object2 = AdjustActionsUtils.findChainByOutputTypeOrShowError(list, "data.sys.sdratio", VE_ADJ_SDRATIO_REQ_NAMES);
            if (object2 == null) {
                return;
            }
            object = datalogTab.getConverterPrefs();
            ConverterPrefs.setDisplacementLiters((DataPreferences)object, ((Number)sDRecordModel.persistedDisplacement.getValue()).floatValue());
            SDModelAdjTracker sDModelAdjTracker = new SDModelAdjTracker(sDRecordModel);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(displayChain);
            arrayList.add(displayChain2);
            arrayList.add(object2);
            DisplaySet displaySet = new DisplaySet();
            try {
                displaySet.registerModels(dataset, datalogTab.getConverterPrefs());
                displaySet.setDisplayChains(arrayList);
                ArrayList arrayList2 = displaySet.getDisplayPackets();
                for (TSDataPacket tSDataPacket : arrayList2) {
                    float[] fArray = tSDataPacket.data;
                    if (fArray[0] < 200.0f) continue;
                    float f = fArray[2];
                    float f2 = fArray[0];
                    float f3 = fArray[1];
                    sDModelAdjTracker.applyAdjustment(f2, f3, f, true);
                }
            }
            finally {
                displaySet.deregisterModels();
            }
            sDModelAdjTracker.applyNewVEToVolatile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doVEAdjCombFT(DatalogTab datalogTab, Dataset dataset) throws IOException, DeviceException {
        if (!AdjustActionsUtils.showMessageAndContinue("ecmlink.veadj.combft.msg")) {
            return;
        }
        SDRecordModel sDRecordModel = AdjustActionsSDVE.showSDTab(datalogTab);
        if (sDRecordModel == null) {
            return;
        }
        Dataset dataset2 = dataset;
        synchronized (dataset2) {
            Object object;
            List list = DisplayChain.generateDisplayChains(dataset.getMainDataTOC(), false);
            DisplayChain displayChain = AdjustActionsUtils.findChainByOutputTypeOrShowError(list, "data.sys.rpm", VE_ADJ_COMBFT_REQ_NAMES);
            if (displayChain == null) {
                return;
            }
            DisplayChain displayChain2 = AdjustActionsUtils.findChainByLocalKeyOrShowError(list, "conv.sys.combinedft", VE_ADJ_COMBFT_REQ_NAMES);
            if (displayChain2 == null) {
                return;
            }
            DisplayChain displayChain3 = AdjustActionsUtils.findChainByLocalKeyOrShowError(list, "conv.ecmx.closedloop", VE_ADJ_COMBFT_REQ_NAMES);
            if (displayChain3 == null) {
                return;
            }
            int n = ((Number)sDRecordModel.mdlPersistedMAPInputX.getValue()).intValue();
            if (n == 0) {
                MainModel.showErrorMessage("Input pin for MAP sensor has not been assigned.", "Error");
                return;
            }
            String string = MiscBitsV3Record.INPUT_X_TO_LOCNAME[n];
            if (string == null) {
                MainModel.showErrorMessage("Invalid input pin selected for MAP sensor.", "Error");
                return;
            }
            DisplayChain displayChain4 = null;
            List list2 = DisplayChain.findChainsByOutputType(list, "data.sys.airpsia");
            Object object2 = list2.iterator();
            while (object2.hasNext() && displayChain4 == null) {
                object = (DisplayChain)object2.next();
                if (!((DisplayChain)object).usesAssignedLocationName(string)) continue;
                displayChain4 = object;
            }
            if (displayChain4 == null) {
                MainModel.showErrorMessage("Can not find log item for MAP sensor in log file.", "Error");
                return;
            }
            object2 = new SDModelAdjTracker(sDRecordModel);
            object = new ArrayList();
            object.add(displayChain);
            object.add(displayChain4);
            object.add(displayChain2);
            object.add(displayChain3);
            DisplaySet displaySet = new DisplaySet();
            try {
                displaySet.registerModels(dataset, datalogTab.getConverterPrefs());
                displaySet.setDisplayChains((List)object);
                MAFAdjRecord mAFAdjRecord = new MAFAdjRecord();
                ArrayList arrayList = displaySet.getDisplayPackets();
                for (TSDataPacket tSDataPacket : arrayList) {
                    float[] fArray = tSDataPacket.data;
                    if (fArray[0] < 200.0f) continue;
                    if (fArray[3] == 1.0f) {
                        if (!mAFAdjRecord.loopStart((fArray[2] + 100.0f) / 100.0f)) continue;
                        float f = fArray[0];
                        float f2 = fArray[1];
                        if (mAFAdjRecord.getCombFTDirection() == 0) {
                            if (!mAFAdjRecord.hasConstFTStartTime()) {
                                mAFAdjRecord.setConstantFTStartTime(tSDataPacket.timestampMicros);
                                continue;
                            }
                            if (!(tSDataPacket.timestampMicros - mAFAdjRecord.getConstantFTStartTime() > 1000000.0)) continue;
                            ((SDModelAdjTracker)object2).applyAdjustment(f, f2, mAFAdjRecord.getCurrCombFT(), false);
                            mAFAdjRecord.setConstantFTStartTime(tSDataPacket.timestampMicros);
                            continue;
                        }
                        mAFAdjRecord.clearConstantFTStartTime();
                        if (mAFAdjRecord.getLastCombFTDirection() == 0) {
                            mAFAdjRecord.setLastCombFTDirection(mAFAdjRecord.getCombFTDirection());
                            continue;
                        }
                        if (mAFAdjRecord.getLastCombFTDirection() == mAFAdjRecord.getCombFTDirection()) continue;
                        mAFAdjRecord.setLastCombFTDirection(mAFAdjRecord.getCombFTDirection());
                        mAFAdjRecord.incrSwitchCnt();
                        if (mAFAdjRecord.getSwitchCnt() <= 3) continue;
                        ((SDModelAdjTracker)object2).applyAdjustment(f, f2, mAFAdjRecord.getCurrCombFT(), false);
                        continue;
                    }
                    mAFAdjRecord.reset();
                }
            }
            finally {
                displaySet.deregisterModels();
            }
            ((SDModelAdjTracker)object2).applyNewVEToVolatile();
        }
    }

    private static SDRecordModel showSDTab(DatalogTab datalogTab) throws IOException, DeviceException {
        SettingsTab settingsTab = uiAdapter.bringForthSettingsTab(datalogTab.getLastSavedDatalog(), datalogTab.isLiveView());
        if (settingsTab == null) {
            MainModel.showErrorMessage("Internal error: failed to find appropriate settings tab", "Error");
            return null;
        }
        SDTab sDTab = (SDTab)settingsTab.bringTabForward(SDTab.class);
        if (sDTab == null) {
            MainModel.showErrorMessage("Internal error: failed to find speed density tab", "Error");
            return null;
        }
        SDRecordModel sDRecordModel = (SDRecordModel)sDTab.getRecordModel();
        return sDRecordModel;
    }

    static class MAFAdjRecord {
        private boolean firstTimeLoop;
        private int switchCnt;
        private int combFTDirection;
        private int lastCombFTDirection;
        private double constantFTStartTime;
        private float lastCombFT;
        private float currCombFT;

        public MAFAdjRecord() {
            this.reset();
        }

        public void reset() {
            this.firstTimeLoop = false;
            this.switchCnt = 0;
            this.lastCombFTDirection = 0;
            this.combFTDirection = 0;
            this.constantFTStartTime = 0.0;
            this.currCombFT = Float.MIN_VALUE;
            this.lastCombFT = Float.MIN_VALUE;
        }

        public boolean loopStart(float f) {
            if (this.firstTimeLoop) {
                this.reset();
                this.lastCombFT = this.currCombFT = f;
                return false;
            }
            this.lastCombFT = this.currCombFT;
            this.currCombFT = f;
            this.combFTDirection = this.currCombFT > this.lastCombFT ? 1 : (this.currCombFT < this.lastCombFT ? -1 : 0);
            return true;
        }

        public boolean hasConstFTStartTime() {
            return this.constantFTStartTime > 0.0;
        }

        public int getSwitchCnt() {
            return this.switchCnt;
        }

        public void incrSwitchCnt() {
            ++this.switchCnt;
        }

        public int getCombFTDirection() {
            return this.combFTDirection;
        }

        public int getLastCombFTDirection() {
            return this.lastCombFTDirection;
        }

        public void setLastCombFTDirection(int n) {
            this.lastCombFTDirection = n;
        }

        public double getConstantFTStartTime() {
            return this.constantFTStartTime;
        }

        public void setConstantFTStartTime(double d) {
            this.constantFTStartTime = d;
        }

        public void clearConstantFTStartTime() {
            this.constantFTStartTime = 0.0;
        }

        public float getCurrCombFT() {
            return this.currCombFT;
        }

        public float getLastCombFT() {
            return this.lastCombFT;
        }
    }

    static class SDModelAdjTracker {
        final SDRecordModel sdModel;
        final List persistedVEList;
        final float[] origVEArray;
        final float[] newVEArray;
        final float[] rpmIndices;
        final float[] psiaIndices;
        final int numCols;
        final int maxColumn;
        final int maxRow;

        SDModelAdjTracker(SDRecordModel sDRecordModel) {
            this.sdModel = sDRecordModel;
            this.persistedVEList = sDRecordModel.persistedVETableList;
            this.origVEArray = ListUtil.convertToFloatArray(this.persistedVEList);
            this.newVEArray = ListUtil.convertToFloatArray(this.persistedVEList);
            this.rpmIndices = SDTableAdapter.getRPMIndices(sDRecordModel);
            this.psiaIndices = SDTableAdapter.getPsiaIndices(sDRecordModel);
            this.numCols = this.rpmIndices.length;
            this.maxColumn = this.rpmIndices.length - 1;
            this.maxRow = this.psiaIndices.length - 1;
        }

        void applyAdjustment(float f, float f2, float f3, boolean bl) {
            if (bl && f3 < 0.001f) {
                f3 = 0.001f;
            }
            int n = ListUtil.findClosestIndex(f, this.rpmIndices);
            int n2 = ListUtil.findClosestIndex(f2, this.psiaIndices);
            float f4 = this.rpmIndices[n];
            float f5 = this.psiaIndices[n2];
            int n3 = n;
            int n4 = n2;
            if (n > 0 && f < f4 * 3.0f / 5.0f + this.rpmIndices[n - 1] * 2.0f / 5.0f) {
                --n;
            } else if (n < this.maxColumn && f > f4 * 3.0f / 5.0f + this.rpmIndices[n + 1] * 2.0f / 5.0f) {
                ++n3;
            }
            if (n2 > 0 && f2 < f5 * 3.0f / 5.0f + this.psiaIndices[n2 - 1] * 2.0f / 5.0f) {
                --n2;
            } else if (n2 < this.maxRow && f2 > f5 * 3.0f / 5.0f + this.psiaIndices[n2 + 1] * 2.0f / 5.0f) {
                ++n4;
            }
            for (int i = n; i <= n3; ++i) {
                for (int j = n2; j <= n4; ++j) {
                    int n5 = j * this.numCols + i;
                    float f6 = this.newVEArray[n5];
                    float f7 = bl ? this.origVEArray[n5] / f3 : this.origVEArray[n5] * f3;
                    this.newVEArray[n5] = f6 * 0.97f + f7 * 0.03f;
                }
            }
        }

        void applyNewVEToVolatile() {
            for (int i = 0; i < this.newVEArray.length; ++i) {
                this.sdModel.volatileVETableList.set(i, new Float(this.newVEArray[i]));
            }
        }
    }

    static class DoVEAdjCombFTAction
    extends AbstractAction {
        final DatalogTab datalogTab;
        final Dataset dataset;

        DoVEAdjCombFTAction(DatalogTab datalogTab, Dataset dataset) {
            this.datalogTab = datalogTab;
            this.dataset = dataset;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new Task(){

                public Object run() throws Exception {
                    AdjustActionsSDVE.doVEAdjCombFT(datalogTab, dataset);
                    return null;
                }
            }, false);
        }
    }

    static class DoVEAdjSDRatioAction
    extends AbstractAction {
        final DatalogTab datalogTab;
        final Dataset dataset;

        DoVEAdjSDRatioAction(DatalogTab datalogTab, Dataset dataset) {
            this.datalogTab = datalogTab;
            this.dataset = dataset;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new Task(){

                public Object run() throws Exception {
                    AdjustActionsSDVE.doVEAdjSDRatio(datalogTab, dataset);
                    return null;
                }
            }, false);
        }
    }
}

