/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsUtils;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkUIAdapter;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.device.ecmlink.records.TPSV1Record;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.RPMTPSRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.RPMTPSRecordView;
import com.ecmtuning.ecmlink.view.ecmlink.RPMTPSTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

class AdjustActionsTPS {
    static ECMLinkUIAdapter uiAdapter;
    static final String TPS_ADJ_REQ_NAMES = "TPSVolts";

    AdjustActionsTPS() {
    }

    static void addTPSAdjActions(ECMLinkUIAdapter eCMLinkUIAdapter, DatalogTab datalogTab, List list) {
        DeviceConfigData deviceConfigData;
        uiAdapter = eCMLinkUIAdapter;
        Dataset dataset = datalogTab.getDataset();
        if (dataset != null && (deviceConfigData = dataset.getMainConfigData()) != null) {
            DoTPSAdjAction doTPSAdjAction = new DoTPSAdjAction(datalogTab);
            ECMLinkResources.configureAction(doTPSAdjAction, "ecmlinkTPSAdj");
            list.add(doTPSAdjAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doTPSAdj(DatalogTab datalogTab) throws IOException, DeviceException {
        Dataset dataset;
        if (!AdjustActionsUtils.showMessageAndContinue("ecmlink.tpsadj.msg")) {
            return;
        }
        Dataset dataset2 = dataset = datalogTab.getDataset();
        synchronized (dataset2) {
            Object object2;
            List list = DisplayChain.generateDisplayChains(dataset.getMainDataTOC());
            DisplayChain displayChain = AdjustActionsUtils.findChainByLocalKeyOrShowError(list, "conv.ecmx.tpsvolts", TPS_ADJ_REQ_NAMES);
            if (displayChain == null) {
                return;
            }
            DisplaySet displaySet = new DisplaySet();
            float f = Float.MAX_VALUE;
            float f2 = Float.MIN_VALUE;
            try {
                displaySet.registerModels(dataset, datalogTab.getConverterPrefs());
                ArrayList<DisplayChain> arrayList = new ArrayList<DisplayChain>();
                arrayList.add(displayChain);
                displaySet.setDisplayChains(arrayList);
                ArrayList arrayList2 = displaySet.getDisplayPackets();
                for (Object object2 : arrayList2) {
                    float[] fArray = ((TSDataPacket)object2).data;
                    float f3 = fArray[0];
                    if (f3 > f2) {
                        f2 = f3;
                    }
                    if (!(f3 < f)) continue;
                    f = f3;
                }
            }
            finally {
                displaySet.deregisterModels();
            }
            float f4 = f2 - f;
            if ((double)(f2 - f) < 3.25) {
                MainModel.showErrorMessage("TPS voltage swing in data is from " + XFormatter.format(f, 2) + "v to " + XFormatter.format(f2, 2) + "v.\nThis is a difference of only " + XFormatter.format(f4, 2) + "v, which is below the required min\nvalue of 3.25v.  You will need to manually adjust or capture new data\nwith a full swing of the throttle from fully closed to fully open.", "TPS volts range error");
                return;
            }
            float f5 = f * 51.0f;
            float f6 = f2 * 51.0f;
            SettingsTab settingsTab = uiAdapter.bringForthSettingsTab(datalogTab.getLastSavedDatalog(), datalogTab.isLiveView());
            if (settingsTab == null) {
                MainModel.showErrorMessage("Internal error: failed to find appropriate settings tab", "Error");
                return;
            }
            object2 = (RPMTPSTab)settingsTab.bringTabForward(RPMTPSTab.class);
            AdjustActionsTPS.pushTPSData(f5, f6, (RPMTPSTab)object2);
        }
    }

    static void pushTPSData(float f, float f2, RPMTPSTab rPMTPSTab) {
        RPMTPSRecordView rPMTPSRecordView = (RPMTPSRecordView)rPMTPSTab.getBuiltView();
        RPMTPSRecordModel rPMTPSRecordModel = rPMTPSRecordView.getRecordModel();
        TPSV1Record tPSV1Record = rPMTPSRecordModel.getPersistedTPSRecord();
        float f3 = tPSV1Record.getField("TPSScale").floatValue() / 100.0f;
        float f4 = tPSV1Record.getField("TPSOffset").floatValue();
        int n = tPSV1Record.getField("TPSCtl").intValue();
        if ((n & 8) == 0) {
            f3 = 1.0f;
            f4 = 0.0f;
        }
        f = f / f3 - f4;
        f2 = f2 / f3 - f4;
        float f5 = 223.0f / (f2 - f);
        float f6 = 32.0f / f5 - f;
        tPSV1Record = rPMTPSRecordModel.getVolatileTPSRecord();
        tPSV1Record.getField("TPSScale").setValue(f5 * 100.0f);
        tPSV1Record.getField("TPSOffset").setValue(f6);
        n = tPSV1Record.getField("TPSCtl").intValue();
        tPSV1Record.getField("TPSCtl").setValue(n | 8);
    }

    static class DoTPSAdjAction
    extends AbstractAction {
        final DatalogTab datalogTab;

        DoTPSAdjAction(DatalogTab datalogTab) {
            this.datalogTab = datalogTab;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new Task(){

                public Object run() throws Exception {
                    AdjustActionsTPS.doTPSAdj(datalogTab);
                    return null;
                }
            }, false);
        }
    }
}

