/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import java.util.List;

class AdjustActionsUtils {
    static final int MIN_REQ_CONSTANT_FT_MICROS = 1000000;

    AdjustActionsUtils() {
    }

    static boolean showMessageAndContinue(String string) {
        if (OptionalMessageDialog.isShowingMsg(string)) {
            OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), string, ECMLinkResources.getResourceBundle());
            optionalMessageDialog.setDoCancel(true);
            optionalMessageDialog.setOkText("Continue");
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
            if (optionalMessageDialog.hasBeenCanceled()) {
                return false;
            }
        }
        return true;
    }

    static DisplayChain findChainByLocalKeyOrShowError(List list, String string, String string2) {
        List list2 = DisplayChain.findChainsByLocalKey(list, string);
        if (list2.size() == 1) {
            return (DisplayChain)list2.get(0);
        }
        if (list2.size() > 1) {
            MainModel.showErrorMessage("Found multiple instances of '" + string + "'", "Data lookup error");
            return null;
        }
        MainModel.showErrorMessage("Unable to find required data elements.  To use this function, the datalog must include:\n" + string2, "Data lookup error");
        return null;
    }

    static DisplayChain findChainByOutputTypeOrShowError(List list, String string, String string2) {
        List list2 = DisplayChain.findChainsByOutputType(list, string);
        if (list2.size() == 1) {
            return (DisplayChain)list2.get(0);
        }
        if (list2.size() > 1) {
            MainModel.showErrorMessage("Found multiple instances of '" + string + "'", "Data lookup error");
            return null;
        }
        MainModel.showErrorMessage("Unable to find required data elements.  To use this function, the datalog must include:\n    " + string2, "Data lookup error");
        return null;
    }
}

