/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsUtils;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkUIAdapter;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.data.DisplayChain;
import com.ecmtuning.ecmlink.device.data.DisplaySet;
import com.ecmtuning.ecmlink.device.data.TSDataPacket;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceConfigData;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.ecmlink.records.MiscBitsV3Record;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ListUtil;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.ecmlink.WGSRecordModel;
import com.ecmtuning.ecmlink.view.ecmlink.WGSTab;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;

class AdjustActionsWGS {
    static ECMLinkUIAdapter uiAdapter;
    static final String WGS_ADJ_REQ_NAMES = "WGSDuty, WGSGear, ThrotPos, RPM, and MAP sensor";

    AdjustActionsWGS() {
    }

    static void addWGSAdjActions(ECMLinkUIAdapter eCMLinkUIAdapter, DatalogTab datalogTab, List list) {
        ECMLinkDeviceConfigData eCMLinkDeviceConfigData;
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet;
        DeviceConfigData deviceConfigData;
        uiAdapter = eCMLinkUIAdapter;
        Dataset dataset = datalogTab.getDataset();
        if (dataset != null && (deviceConfigData = dataset.getMainConfigData()) != null && deviceConfigData instanceof ECMLinkDeviceConfigData && (eCMLinkConfigRecordSet = (eCMLinkDeviceConfigData = (ECMLinkDeviceConfigData)deviceConfigData).getConfigRecordSet()) != null && eCMLinkConfigRecordSet.getVolatileRecord(50) != null) {
            DoWGSAdjAction doWGSAdjAction = new DoWGSAdjAction(datalogTab, dataset);
            ECMLinkResources.configureAction(doWGSAdjAction, "ecmlinkWGSAdj");
            list.add(doWGSAdjAction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doWGSAdjust(DatalogTab datalogTab, Dataset dataset) throws IOException, DeviceException {
        if (!AdjustActionsUtils.showMessageAndContinue("ecmlink.wgsadj.msg")) {
            return;
        }
        WGSRecordModel wGSRecordModel = AdjustActionsWGS.showWGSTab(datalogTab);
        if (wGSRecordModel == null) {
            MainModel.showErrorMessage("Unsupported ECU feature.  No WGS table found.", "Error");
            return;
        }
        float f = Math.max(((Number)wGSRecordModel.persistedZeroPntPsia.getValue()).floatValue(), ((Number)wGSRecordModel.persistedFullPntPsia.getValue()).floatValue());
        Dataset dataset2 = dataset;
        synchronized (dataset2) {
            DisplayChain displayChain;
            List list = DisplayChain.generateDisplayChains(dataset.getMainDataTOC(), false);
            DisplayChain displayChain2 = AdjustActionsUtils.findChainByOutputTypeOrShowError(list, "data.sys.rpm", WGS_ADJ_REQ_NAMES);
            if (displayChain2 == null) {
                return;
            }
            DisplayChain displayChain3 = AdjustActionsUtils.findChainByOutputTypeOrShowError(list, "data.ecmx.wgsgear", WGS_ADJ_REQ_NAMES);
            if (displayChain3 == null) {
                return;
            }
            int n = ((Number)wGSRecordModel.mdlPersistedMAPInputX.getValue()).intValue();
            if (n == 0) {
                MainModel.showErrorMessage("Input pin for MAP sensor has not been assigned.", "Error");
                return;
            }
            String string = MiscBitsV3Record.INPUT_X_TO_LOCNAME[n];
            if (string == null) {
                MainModel.showErrorMessage("Invalid input pin selected for MAP sensor.", "Error");
                return;
            }
            List list2 = DisplayChain.findChainsByOutputType(list, "data.sys.airpsia");
            DisplayChain displayChain4 = null;
            Object object = list2.iterator();
            while (object.hasNext() && displayChain4 == null) {
                displayChain = (DisplayChain)object.next();
                if (!displayChain.usesAssignedLocationName(string)) continue;
                displayChain4 = displayChain;
            }
            if (displayChain4 == null) {
                MainModel.showErrorMessage("Can not find log item for MAP sensor in log file.", "Error");
                return;
            }
            object = AdjustActionsUtils.findChainByOutputTypeOrShowError(list, "data.ecmx.wgsduty", WGS_ADJ_REQ_NAMES);
            if (object == null) {
                return;
            }
            displayChain = AdjustActionsUtils.findChainByOutputTypeOrShowError(list, "data.sys.throtpos", WGS_ADJ_REQ_NAMES);
            if (displayChain == null) {
                return;
            }
            WGSModelAdjTracker wGSModelAdjTracker = new WGSModelAdjTracker(wGSRecordModel);
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(displayChain2);
            arrayList.add(displayChain3);
            arrayList.add(displayChain4);
            arrayList.add(object);
            arrayList.add(displayChain);
            DisplaySet displaySet = new DisplaySet();
            int n2 = 0;
            try {
                displaySet.registerModels(dataset, datalogTab.getConverterPrefs());
                displaySet.setDisplayChains(arrayList);
                ArrayList arrayList2 = displaySet.getDisplayPackets();
                for (TSDataPacket tSDataPacket : arrayList2) {
                    float[] fArray = tSDataPacket.data;
                    if (fArray[0] < 1750.0f || fArray[4] < 90.0f || fArray[2] < 16.7f || fArray[2] <= f) continue;
                    ++n2;
                    wGSModelAdjTracker.recordCurrent(fArray[0], (int)fArray[1], fArray[2], fArray[3]);
                }
            }
            finally {
                displaySet.deregisterModels();
            }
            if (n2 == 0) {
                MainModel.showErrorMessage("Failed to find any areas with TPS > 90%, RPM > 1750 and positive boost.", "Error");
                return;
            }
            if (n2 < 15) {
                MainModel.showInfoMessage("Limited data found.  Will proceed, but results may not be very useful.");
            }
            wGSModelAdjTracker.setNewValues();
        }
    }

    private static WGSRecordModel showWGSTab(DatalogTab datalogTab) throws IOException, DeviceException {
        SettingsTab settingsTab = uiAdapter.bringForthSettingsTab(datalogTab.getLastSavedDatalog(), datalogTab.isLiveView());
        if (settingsTab == null) {
            MainModel.showErrorMessage("Internal error: failed to find appropriate settings tab", "Error");
            return null;
        }
        WGSTab wGSTab = (WGSTab)settingsTab.bringTabForward(WGSTab.class);
        if (wGSTab == null) {
            MainModel.showErrorMessage("Internal error: failed to find WGS tab", "Error");
            return null;
        }
        WGSRecordModel wGSRecordModel = (WGSRecordModel)wGSTab.getRecordModel();
        return wGSRecordModel;
    }

    static class WGSModelAdjTracker {
        final WGSRecordModel wgsModel;
        final double[] psiaTargetSum;
        final double[] baseDutySum;
        final int[] counts;
        final float[] rpmIndices;
        final int numCols;
        final int maxColumn;

        WGSModelAdjTracker(WGSRecordModel wGSRecordModel) {
            this.wgsModel = wGSRecordModel;
            this.rpmIndices = new float[]{2000.0f, 2500.0f, 3000.0f, 3500.0f, 4000.0f, 4500.0f, 5000.0f, 5500.0f, 6000.0f, 6500.0f, 7000.0f, 7500.0f, 8000.0f, 8500.0f, 9000.0f, 9500.0f, 10000.0f};
            this.numCols = this.rpmIndices.length;
            this.psiaTargetSum = new double[this.rpmIndices.length * 3];
            this.baseDutySum = new double[this.rpmIndices.length * 3];
            this.counts = new int[this.rpmIndices.length * 3];
            Arrays.fill(this.counts, 0);
            this.maxColumn = this.rpmIndices.length - 1;
        }

        void recordCurrent(float f, int n, float f2, float f3) {
            int n2;
            int n3 = ListUtil.findClosestIndex(f, this.rpmIndices);
            int n4 = Math.max(1, Math.min(3, n)) - 1;
            int n5 = n2 = n4 * this.numCols + n3;
            this.psiaTargetSum[n5] = this.psiaTargetSum[n5] + (double)f2;
            int n6 = n2;
            this.baseDutySum[n6] = this.baseDutySum[n6] + (double)f3;
            int n7 = n2;
            this.counts[n7] = this.counts[n7] + 1;
        }

        void setNewValues() {
            for (int i = 0; i < this.psiaTargetSum.length; ++i) {
                if (this.counts[i] <= 0) continue;
                this.wgsModel.volatileTargetPsiaList.set(i, new Float(this.psiaTargetSum[i] / (double)this.counts[i]));
                this.wgsModel.volatileBaseDCList.set(i, new Float(this.baseDutySum[i] / (double)this.counts[i]));
            }
        }
    }

    static class DoWGSAdjAction
    extends AbstractAction {
        final DatalogTab datalogTab;
        final Dataset dataset;

        DoWGSAdjAction(DatalogTab datalogTab, Dataset dataset) {
            this.datalogTab = datalogTab;
            this.dataset = dataset;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new Task(){

                public Object run() throws Exception {
                    AdjustActionsWGS.doWGSAdjust(datalogTab, dataset);
                    return null;
                }
            }, false);
        }
    }
}

