/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkFlashOps;
import com.ecmtuning.ecmlink.device.ecmlink.exception.DeviceReflashConfigException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidStateException;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.ProgressTask;
import com.ecmtuning.ecmlink.util.ui.ProgressTaskMonitor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class BaseFirmwareTask
implements ProgressTask {
    protected static final int PROGRESS_ENTERED_REFLASH_MODE = 48;
    protected static final int PROGRESS_REBOOT = 32;
    protected static final int PROGRESS_RECONNECT = 16;
    protected static final String PROGRESS_MESSAGE = "Reprogramming ECMLink device";
    protected static final String STATUS_REQUESTING_MODE = "Establishing connection";
    protected static final String STATUS_SAVING_CONFIG = "Storing configuration data first";
    protected static final String STATUS_REBOOTING = "Rebooting ECU";
    protected static final String STATUS_RECONNECTING = "Reconnecting and testing";
    protected final MainModel mainModel = MainModel.getInstance();
    protected final ECMLinkDeviceManager deviceManager;
    protected final ECMLinkFlashOps flashOps;
    protected ProgressTaskMonitor monitor;
    protected int activeBank;
    protected int inactiveBank;
    protected int rebootBank;
    protected int blockAddr_activeBankStart;
    protected int blockAddr_inactiveBankStart;
    protected int sectorAddr_activeBankStart;
    protected int sectorAddr_inactiveBankStart;
    protected String progressStatusText = "";
    protected int currentProgress = 0;
    protected int totalProgress = 100;
    protected boolean taskDone;
    protected boolean stopRequested;
    private static final Logger logger = Logger.getLogger(BaseFirmwareTask.class.getName());

    protected BaseFirmwareTask(ECMLinkDeviceManager eCMLinkDeviceManager) {
        this.deviceManager = eCMLinkDeviceManager;
        this.flashOps = this.deviceManager.getFlashOps();
    }

    protected int getDefaultProgressAmount() {
        return 96;
    }

    protected void initializeProgress() throws IOException {
        this.progressStatusText = STATUS_REQUESTING_MODE;
        this.currentProgress = 0;
        try {
            this.monitor = ProgressTaskMonitor.createProgressTaskMonitor(MainModel.getDefaultParentFrame(), this);
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("Internal error: exception raised while creating progress monitor.");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("Internal error: exception raised while creating progress monitor.");
        }
        this.monitor.setMillisToDecideToPopup(300);
        this.monitor.setMillisToPopup(300);
    }

    protected void enterReflashMode() throws IOException, DeviceException {
        block7: {
            try {
                logger.fine("Requesting reflash mode");
                this.activeBank = this.flashOps.requestReflashMode() & 1;
            }
            catch (DeviceReflashConfigException deviceReflashConfigException) {
                logger.fine("Saving configuration data first");
                this.progressStatusText = STATUS_SAVING_CONFIG;
                boolean bl = false;
                this.currentProgress = 8;
                try {
                    for (int i = 0; !bl && i < 20; ++i) {
                        Thread.sleep(500L);
                        try {
                            this.currentProgress += 2;
                            this.activeBank = this.flashOps.requestReflashMode() & 1;
                            bl = true;
                            continue;
                        }
                        catch (DeviceReflashConfigException deviceReflashConfigException2) {
                            // empty catch block
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (bl) break block7;
                this.activeBank = this.flashOps.requestReflashMode() & 1;
            }
        }
        this.inactiveBank = this.activeBank ^ 1;
        this.blockAddr_activeBankStart = this.activeBank * 256;
        this.blockAddr_inactiveBankStart = this.inactiveBank * 256;
        this.sectorAddr_activeBankStart = this.activeBank * 16;
        this.sectorAddr_inactiveBankStart = this.inactiveBank * 16;
        this.rebootBank = this.activeBank;
        logger.fine("Active bank " + this.activeBank + ", flash bank " + this.inactiveBank);
        this.currentProgress = 48;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rebootAndReconnect(boolean bl) throws IOException, DeviceException {
        this.progressStatusText = STATUS_REBOOTING;
        logger.fine("Requesting ECU reboot, reboot bank = " + this.rebootBank);
        this.flashOps.flashReboot(this.rebootBank, bl);
        this.currentProgress += 16;
        BaseFirmwareTask.safeSleep(400L);
        this.currentProgress += 16;
        this.progressStatusText = STATUS_RECONNECTING;
        logger.fine("Attempting to reconnect");
        boolean bl2 = false;
        try {
            this.tryReconnect();
            bl2 = true;
        }
        catch (DeviceException deviceException) {
            BaseFirmwareTask.safeSleep(500L);
            try {
                this.tryReconnect();
                bl2 = true;
            }
            catch (Throwable throwable) {
                throw deviceException;
            }
        }
        catch (IOException iOException) {
            BaseFirmwareTask.safeSleep(500L);
            try {
                this.tryReconnect();
                bl2 = true;
            }
            catch (Throwable throwable) {
                throw iOException;
            }
        }
        finally {
            if (!bl2) {
                this.flashOps.clearLocalCacheKeys();
            }
        }
        this.flashOps.requestConfigSave();
    }

    private static void safeSleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void tryReconnect() throws IOException, DeviceException {
        this.deviceManager.setConnected(true);
        if (this.deviceManager.getConnectedBank() != -1) {
            if (this.deviceManager.getConnectedBank() != this.rebootBank) {
                throw new DeviceInvalidStateException("Reboot failed!  Your changes were not saved.");
            }
            logger.fine("Rebooted to bank " + this.deviceManager.getConnectedBank());
        }
    }

    protected void fillCRCArray(int n, int[] nArray, int n2) throws IOException, DeviceException {
        for (int i = 0; i < 16 && !this.stopRequested; ++i) {
            int[] nArray2 = this.flashOps.getCRCBlocks(n + i);
            System.arraycopy(nArray2, 0, nArray, i * 16, 16);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Read address data for segment 0x" + XFormatter.toHex4(n + i));
                for (int j = 0; j < nArray2.length; ++j) {
                    logger.fine(" CRC for 0x" + XFormatter.toHex4(i * 4096 + j * 256) + " = 0x" + XFormatter.toHex4(nArray2[j]));
                }
            }
            this.currentProgress += n2 / 16;
        }
    }

    void copyUnchangedBlocks(boolean[] blArray, int n) throws IOException, DeviceException {
        int n2 = -1;
        for (int i = 0; i < 65; ++i) {
            if (i < 64 && blArray[i]) {
                if (n2 != -1) continue;
                n2 = i;
                continue;
            }
            if (n2 == -1) continue;
            this.flashOps.copyToInactiveBlock(n + n2, i - n2);
            if (this.stopRequested) break;
            n2 = -1;
        }
    }

    @Override
    public int getProgress() {
        return this.currentProgress;
    }

    @Override
    public String getNote() {
        return this.progressStatusText;
    }

    @Override
    public int getMinimumProgress() {
        return 0;
    }

    @Override
    public String getMessage() {
        return PROGRESS_MESSAGE;
    }

    @Override
    public int getMaximumProgress() {
        return this.totalProgress;
    }

    @Override
    public boolean isDone() {
        return this.taskDone;
    }

    @Override
    public void stop() {
        this.stopRequested = true;
    }
}

