/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.ecmlink.BaseFirmwareTask;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.firmware.CRCCCITT;
import com.ecmtuning.ecmlink.device.exception.DeviceInterruptedException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidStateException;
import com.ecmtuning.ecmlink.device.exception.DeviceUnsupportedOperationException;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectAccessUpdateTask
extends BaseFirmwareTask {
    private static final int WRITE_INDICATOR = 32768;
    private static final String STATUS_INITIAL_CRC = "Downloading initial data";
    private static final String STATUS_MAIN = "Reprogramming device";
    private static final String STATUS_FINAL_CRC = "Verifying new data";
    private static final int PROGRESS_CHECKSUM = 48;
    private static final int PROGRESS_MAIN = 144;
    private List dataToSend;
    private static final Logger logger = Logger.getLogger(DirectAccessUpdateTask.class.getName());

    public DirectAccessUpdateTask(ECMLinkDeviceManager eCMLinkDeviceManager, List list) {
        super(eCMLinkDeviceManager);
        this.dataToSend = list;
    }

    public void doReflash() throws IOException, DeviceException {
        OptionalMessageDialog optionalMessageDialog;
        if (OptionalMessageDialog.isShowingMsg("ecmlink.direct.access.process.msg")) {
            optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.direct.access.process.msg", ECMLinkResources.getResourceBundle());
            optionalMessageDialog.setDoCancel(true);
            optionalMessageDialog.setOkText("Continue");
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
            if (optionalMessageDialog.hasBeenCanceled()) {
                return;
            }
        }
        if (!ECMLinkDeviceMap.isV3Device(this.deviceManager.getConnectedDeviceId())) {
            throw new DeviceUnsupportedOperationException("This ECU does not support direct access updates.");
        }
        DirectAccessUpdateTask.doReflash(this, this.dataToSend);
        if (OptionalMessageDialog.isShowingMsg("ecmlink.direct.access.final.msg")) {
            optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.direct.access.final.msg", ECMLinkResources.getResourceBundle());
            optionalMessageDialog.setDoCancel(false);
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doReflash(BaseFirmwareTask baseFirmwareTask, List list) throws IOException, DeviceException {
        baseFirmwareTask.totalProgress = baseFirmwareTask.getDefaultProgressAmount();
        baseFirmwareTask.totalProgress += 48;
        baseFirmwareTask.totalProgress += 144;
        baseFirmwareTask.totalProgress += 48;
        boolean bl = false;
        baseFirmwareTask.initializeProgress();
        try {
            int n;
            int n2;
            int n3;
            baseFirmwareTask.enterReflashMode();
            baseFirmwareTask.progressStatusText = STATUS_INITIAL_CRC;
            logger.fine("Grabbing initial CRC data");
            int[] nArray = new int[256];
            baseFirmwareTask.fillCRCArray(baseFirmwareTask.sectorAddr_activeBankStart, nArray, 48);
            int[] nArray2 = new int[256];
            System.arraycopy(nArray, 0, nArray2, 0, 256);
            baseFirmwareTask.progressStatusText = STATUS_MAIN;
            logger.fine("Initializing memory map");
            int[] nArray3 = new int[65536];
            Arrays.fill(nArray3, 0);
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    n3 = ((Number)iterator.next()).intValue();
                    n2 = ((Number)iterator.next()).intValue();
                    nArray3[n3] = 32768 + (n2 & 0xFF);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.fine("Putting 0x" + XFormatter.toHex2(n2) + " at 0x" + XFormatter.toHex4(n3));
                }
            }
            boolean bl2 = true;
            n3 = 9;
            for (n2 = 0; n2 < 65536 && !baseFirmwareTask.stopRequested; n2 += 256) {
                int n4;
                int n5;
                n = n2 & 0xC000;
                int n6 = (n2 & 0xFF00) / 256 + baseFirmwareTask.blockAddr_activeBankStart;
                int n7 = (n2 & 0xFF00) / 256 + baseFirmwareTask.blockAddr_inactiveBankStart;
                int n8 = n / 4096 + baseFirmwareTask.sectorAddr_activeBankStart;
                int n9 = n / 4096 + baseFirmwareTask.sectorAddr_inactiveBankStart;
                int n10 = n / 256 + baseFirmwareTask.blockAddr_activeBankStart;
                int n11 = n / 256 + baseFirmwareTask.blockAddr_inactiveBankStart;
                int n12 = 0;
                for (n5 = 0; n5 < 256; ++n5) {
                    if (nArray3[n2 + n5] == 0) continue;
                    ++n12;
                }
                if (n12 > 0) {
                    bl2 = false;
                    if (n12 == 256) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("No need to read data from ECU for block 0x" + XFormatter.toHex4(n6));
                        }
                    } else {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("Reading data for active block 0x" + XFormatter.toHex4(n6));
                        }
                        int[] nArray4 = baseFirmwareTask.flashOps.readBlock(n6);
                        if (baseFirmwareTask.stopRequested) break;
                        for (n4 = 0; n4 < 256; ++n4) {
                            if ((nArray3[n2 + n4] & 0x8000) != 0) continue;
                            nArray3[n2 + n4] = 32768 + nArray4[n4];
                        }
                    }
                    nArray2[n6 & 0xFF] = CRCCCITT.calcCRC(nArray3, n2, 256);
                }
                if ((n5 = n2 + 256) != (n5 & 0x1C000)) continue;
                baseFirmwareTask.currentProgress += n3;
                if (bl2) {
                    n4 = baseFirmwareTask.flashOps.compareSector(n8) ? 1 : 0;
                    if (baseFirmwareTask.stopRequested) break;
                    baseFirmwareTask.currentProgress += n3;
                    if (n4 != 0) {
                        logger.fine("Inactive and active sectors are equal; nothing to do.");
                        baseFirmwareTask.currentProgress += n3;
                        baseFirmwareTask.currentProgress += n3;
                    } else {
                        logger.fine("Inactive and active sectors are not equal.  Copying active to inactive.");
                        baseFirmwareTask.flashOps.eraseInactiveSector(n9);
                        baseFirmwareTask.currentProgress += n3;
                        if (baseFirmwareTask.stopRequested) break;
                        baseFirmwareTask.flashOps.copyToInactiveBlock(n11, 64);
                        baseFirmwareTask.currentProgress += n3;
                    }
                } else {
                    logger.fine("We have data to put into this sector.");
                    baseFirmwareTask.flashOps.eraseInactiveSector(n9);
                    baseFirmwareTask.currentProgress += n3;
                    if (baseFirmwareTask.stopRequested) break;
                    boolean[] blArray = DirectAccessUpdateTask.calcSectorCopyMap(nArray3, n);
                    baseFirmwareTask.copyUnchangedBlocks(blArray, n11);
                    baseFirmwareTask.currentProgress += n3;
                    if (baseFirmwareTask.stopRequested) break;
                    DirectAccessUpdateTask.flashChangedBlocks(baseFirmwareTask, nArray3, n, n11);
                    baseFirmwareTask.currentProgress += n3;
                }
                bl2 = true;
            }
            baseFirmwareTask.progressStatusText = STATUS_FINAL_CRC;
            logger.fine("Grabbing final CRC data");
            int[] nArray5 = new int[256];
            if (!baseFirmwareTask.stopRequested) {
                baseFirmwareTask.fillCRCArray(baseFirmwareTask.sectorAddr_inactiveBankStart, nArray5, 48);
                for (n = 0; n < 256 && !baseFirmwareTask.stopRequested; ++n) {
                    if (nArray5[n] == nArray2[n]) continue;
                    logger.info("Failed verification of block " + n + " (0-255).");
                    logger.info("ECU claimed CRC of 0x" + XFormatter.toHex4(nArray5[n]) + ", while expected had CRC of 0x" + XFormatter.toHex4(nArray2[n]));
                    throw new DeviceInvalidStateException("Final verification failed!");
                }
            }
            boolean bl3 = bl = !baseFirmwareTask.stopRequested;
            if (baseFirmwareTask.stopRequested) {
                throw new DeviceInterruptedException("Operation canceled by request!");
            }
            baseFirmwareTask.rebootBank = baseFirmwareTask.inactiveBank;
        }
        finally {
            if (!bl) {
                logger.info("Reprogramming operation has been stopped due either to error or cancellation request from user");
                baseFirmwareTask.taskDone = true;
                baseFirmwareTask.monitor.close();
                baseFirmwareTask.deviceManager.setConnected(false);
            }
        }
        boolean bl4 = false;
        try {
            baseFirmwareTask.rebootAndReconnect(true);
            bl4 = true;
        }
        finally {
            if (bl4 && list != null) {
                baseFirmwareTask.deviceManager.applyUpdatedBytes(list);
            }
            if (!baseFirmwareTask.taskDone) {
                baseFirmwareTask.taskDone = true;
                baseFirmwareTask.monitor.close();
            }
        }
    }

    private static void flashChangedBlocks(BaseFirmwareTask baseFirmwareTask, int[] nArray, int n, int n2) throws IOException, DeviceException {
        int n3 = n;
        for (int i = 0; i < 64; ++i) {
            if ((nArray[n3] & 0x8000) != 0) {
                int n4;
                int[] nArray2 = new int[256];
                for (n4 = 0; n4 < 256; ++n4) {
                    nArray2[n4] = nArray[n3 + n4] & 0xFF;
                }
                n4 = CRCCCITT.calcCRC(nArray2);
                baseFirmwareTask.flashOps.flashBlock(false, n2 + i, nArray2, n4);
            }
            n3 += 256;
        }
    }

    private static final boolean[] calcSectorCopyMap(int[] nArray, int n) {
        boolean[] blArray = new boolean[64];
        Arrays.fill(blArray, true);
        int n2 = n;
        for (int i = 0; i < 64; ++i) {
            blArray[i] = (nArray[n2] & 0x8000) == 0;
            n2 += 256;
        }
        return blArray;
    }
}

