/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkUIAdapter;
import com.ecmtuning.ecmlink.control.ecmlink.UpgradeFirmwareTask;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkFlashOps;
import com.ecmtuning.ecmlink.device.ecmlink.exception.DeviceReflashConfigException;
import com.ecmtuning.ecmlink.device.ecmlink.firmware.FirmwareUpgradeRequest;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.ConfigRecord;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ActivateableInterface;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.util.ui.ProgressTask;
import com.ecmtuning.ecmlink.util.ui.ProgressTaskMonitor;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkConfigDialog;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.jgoodies.uif.action.ActionManager;
import foxtrot.Task;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ECMLinkActions
implements ActivateableInterface {
    public static final String ECMLINK_CONNECT_ID = "ecmlinkConnect";
    public static final String ECMLINK_DISCONNECT_ID = "ecmlinkDisconnect";
    public static final String ECMLINK_LIVE_SETTINGS_ID = "ecmlinkLiveSettings";
    public static final String ECMLINK_LIVE_DIRECT_ACCESS_ID = "ecmlinkLiveDirectAccess";
    public static final String ECMLINK_OFFLINE_SETTINGS_ID = "ecmlinkOfflineSettings";
    public static final String ECMLINK_OFFLINE_DIRECT_ACCESS_ID = "ecmlinkOfflineDirectAccess";
    public static final String ECMLINK_LIVE_SETTINGS_SHORT_ID = "ecmlinkLiveSettingsShort";
    public static final String ECMLINK_LIVE_DIRECT_ACCESS_SHORT_ID = "ecmlinkLiveDirectAccessShort";
    public static final String ECMLINK_OFFLINE_SETTINGS_SHORT_ID = "ecmlinkOfflineSettingsShort";
    public static final String ECMLINK_OFFLINE_DIRECT_ACCESS_SHORT_ID = "ecmlinkOfflineDirectAccessShort";
    public static final String ECMLINK_RESET_LTFT_ID = "ecmlinkResetLTFT";
    public static final String ECMLINK_MAF_ADJ_COMBFT_ID = "ecmlinkMAFAdjCombFT";
    public static final String ECMLINK_TPS_ADJ_ID = "ecmlinkTPSAdj";
    public static final String ECMLINK_VE_ADJ_SDRATIO_ID = "ecmlinkVEAdjSDRatio";
    public static final String ECMLINK_VE_ADJ_COMBFT_ID = "ecmlinkVEAdjCombFT";
    public static final String ECMLINK_WGS_ADJ_ID = "ecmlinkWGSAdj";
    public static final String ECMLINK_CONFIGURE_ID = "ecmlinkConfigure";
    public static final String ECMLINK_FIRMWARE_REQUEST_ID = "ecmlinkFirmwareRequest";
    public static final String ECMLINK_FIRMWARE_ID = "ecmlinkFirmware";
    public static final String ECMLINK_MEMORY_DUMP_ID = "ecmlinkMemoryDump";
    public static final String ECMLINK_REFLASH_STRESS_ID = "ecmlinkReflashStress";
    final MainModel mainModel = MainModel.getInstance();
    final ECMLinkUIAdapter uiAdapter;
    private boolean actionsRegistered;
    private static final Logger logger = Logger.getLogger(ECMLinkActions.class.getName());
    private Action connectAction;

    ECMLinkActions(ECMLinkUIAdapter eCMLinkUIAdapter) {
        this.uiAdapter = eCMLinkUIAdapter;
    }

    public static Action getAction(String string) {
        return ActionManager.get((String)string);
    }

    public static void configureAction(Action action, String string) {
        ECMLinkResources.configureAction(action, string);
    }

    private void doConnect(boolean bl) throws IOException, DeviceException {
        ECMLinkDeviceManager eCMLinkDeviceManager = this.uiAdapter.getAdaptedManager();
        eCMLinkDeviceManager.setConnected(bl);
    }

    private void doConfigure() {
        ECMLinkDeviceManager eCMLinkDeviceManager = this.uiAdapter.getAdaptedManager();
        JFrame jFrame = this.uiAdapter.getApplicationFrame();
        ECMLinkConfigDialog eCMLinkConfigDialog = ECMLinkConfigDialog.getInstance(jFrame, eCMLinkDeviceManager);
        eCMLinkConfigDialog.open();
    }

    private void doMemoryDump() throws Exception {
        ECMLinkDeviceManager eCMLinkDeviceManager = this.uiAdapter.getAdaptedManager();
        if (!ECMLinkDeviceMap.isV3Device(eCMLinkDeviceManager.getConnectedDeviceId())) {
            JOptionPane.showMessageDialog(MainModel.getDefaultParentFrame(), "Only supported for V3 ECUs.", "Memory Dump Error", 0);
            return;
        }
        new MemoryDumpTask().doTask();
    }

    private void doReflashStress() throws Exception {
        ECMLinkDeviceManager eCMLinkDeviceManager = this.uiAdapter.getAdaptedManager();
        if (!ECMLinkDeviceMap.isV3Device(eCMLinkDeviceManager.getConnectedDeviceId())) {
            JOptionPane.showMessageDialog(MainModel.getDefaultParentFrame(), "Only supported for V3 ECUs.", "Stress Reflash Error", 0);
            return;
        }
        new ReflashStressTask().doTask();
    }

    private void doReflash() throws Exception {
        UpgradeFirmwareTask upgradeFirmwareTask = new UpgradeFirmwareTask(this.uiAdapter.getAdaptedManager());
        upgradeFirmwareTask.doReflash();
    }

    private void doFirmwareRequest() throws Exception {
        Object object;
        if (OptionalMessageDialog.isShowingMsg("ecmlink.firmware.request.process.msg")) {
            object = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.firmware.request.process.msg", ECMLinkResources.getResourceBundle());
            ((OptionalMessageDialog)((Object)object)).setDoCancel(true);
            ((OptionalMessageDialog)((Object)object)).setOkText("Continue");
            DialogUtil.safeDispatchThreadCall(object, "open");
            if (object.hasBeenCanceled()) {
                return;
            }
        }
        object = this.uiAdapter.getAdaptedManager();
        FirmwareUpgradeRequest firmwareUpgradeRequest = new FirmwareUpgradeRequest((ECMLinkDeviceManager)((Object)object));
        FilenameModel filenameModel = this.mainModel.getFilenameModel();
        File file = filenameModel.createNewFirmwareRequestFile("'serial" + XFormatter.toHex4(firmwareUpgradeRequest.serialNum) + "-'");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setSelectedFile(file);
        jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
        jFileChooser.addChoosableFileFilter(FilenameModel.getFirmwareRequestFilter());
        jFileChooser.setDialogTitle("Save Firmware Upgrade Request File");
        File file2 = DialogUtil.invokeSaveAsChooser(jFileChooser, MainModel.getDefaultParentFrame(), "fwr");
        if (file2 == null) {
            return;
        }
        firmwareUpgradeRequest.write(file2);
        JOptionPane.showMessageDialog(MainModel.getDefaultParentFrame(), "Your firmware request file has been saved.", "Firmware Request Saved", 1);
    }

    private void displayLiveConfigRecords() throws IOException, DeviceException {
        this.uiAdapter.displayLiveConfigRecordTab();
    }

    private void displayLiveDirectAccess() throws IOException, DeviceException {
        this.uiAdapter.displayLiveDirectAccessTab();
    }

    private void resetLTFT() throws IOException, DeviceException {
        this.uiAdapter.resetLTFT();
    }

    private void doUnkown(String string) {
        MainModel.showInfoMessage(this.getClass().getName() + "." + string);
    }

    @Override
    public void activate() {
        if (!this.actionsRegistered) {
            this.actionsRegistered = true;
            this.register(ECMLINK_CONNECT_ID, true);
            this.register(ECMLINK_DISCONNECT_ID, false);
            this.register(ECMLINK_LIVE_SETTINGS_ID, true);
            this.register(ECMLINK_LIVE_DIRECT_ACCESS_ID, true);
            this.register(ECMLINK_LIVE_SETTINGS_SHORT_ID, true);
            this.register(ECMLINK_LIVE_DIRECT_ACCESS_SHORT_ID, true);
            this.register(ECMLINK_RESET_LTFT_ID, true);
            this.register(ECMLINK_CONFIGURE_ID, false);
            this.register(ECMLINK_FIRMWARE_REQUEST_ID, true);
            this.register(ECMLINK_FIRMWARE_ID, true);
            this.register(ECMLINK_MEMORY_DUMP_ID, true);
            this.register(ECMLINK_REFLASH_STRESS_ID, true);
        }
    }

    private Action register(String string, boolean bl) {
        return ActionManager.register((String)string, (Action)new DispatchingAction(string, bl), (ResourceBundle)ECMLinkResources.getActionBundle());
    }

    public Action createActionCopy(String string, boolean bl) {
        DispatchingAction dispatchingAction = new DispatchingAction(string, bl);
        ECMLinkResources.configureAction(dispatchingAction, string);
        return dispatchingAction;
    }

    public Action getConnectAction() {
        if (this.connectAction == null) {
            this.connectAction = ActionManager.get((String)ECMLINK_CONNECT_ID);
        }
        return this.connectAction;
    }

    void setConnectedState(boolean bl) {
        if (!bl) {
            ECMLinkResources.configureAction(this.connectAction, ECMLINK_CONNECT_ID);
            ((DispatchingAction)this.connectAction).setId(ECMLINK_CONNECT_ID);
        } else {
            ECMLinkResources.configureAction(this.connectAction, ECMLINK_DISCONNECT_ID);
            ((DispatchingAction)this.connectAction).setId(ECMLINK_DISCONNECT_ID);
        }
    }

    void dispatchActionEvent(String string) throws Exception {
        if (string.equals(ECMLINK_CONNECT_ID)) {
            this.doConnect(true);
        } else if (string.equals(ECMLINK_DISCONNECT_ID)) {
            this.doConnect(false);
        } else if (string.equals(ECMLINK_CONFIGURE_ID)) {
            this.doConfigure();
        } else if (string.equals(ECMLINK_FIRMWARE_REQUEST_ID)) {
            this.doFirmwareRequest();
        } else if (string.equals(ECMLINK_FIRMWARE_ID)) {
            this.doReflash();
        } else if (string.equals(ECMLINK_LIVE_SETTINGS_ID) || string.equals(ECMLINK_LIVE_SETTINGS_SHORT_ID)) {
            this.displayLiveConfigRecords();
        } else if (string.equals(ECMLINK_LIVE_DIRECT_ACCESS_ID) || string.equals(ECMLINK_LIVE_DIRECT_ACCESS_SHORT_ID)) {
            this.displayLiveDirectAccess();
        } else if (string.equals(ECMLINK_RESET_LTFT_ID)) {
            this.resetLTFT();
        } else if (string.equals(ECMLINK_MEMORY_DUMP_ID)) {
            this.doMemoryDump();
        } else if (string.equals(ECMLINK_REFLASH_STRESS_ID)) {
            this.doReflashStress();
        } else {
            this.doUnkown(string);
        }
    }

    private final class DispatchingAction
    extends AbstractAction {
        private String id;
        private boolean background;

        private DispatchingAction(String string, boolean bl) {
            this.id = string;
            this.background = bl;
        }

        private void setId(String string) {
            this.id = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MainActions.handleMainFrameTask(new BackgroundTask(this.id), this.background);
        }

        public class BackgroundTask
        extends Task {
            String id;

            BackgroundTask(String string) {
                this.id = string;
            }

            public Object run() throws Exception {
                ECMLinkActions.this.dispatchActionEvent(this.id);
                return null;
            }
        }
    }

    private class ReflashStressTask
    implements ProgressTask {
        int loopCount = 0;
        static final int LOOP_TIMES = 100;
        String note = "";
        boolean stopRequested = false;

        private ReflashStressTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doTask() throws Exception {
            ProgressTaskMonitor progressTaskMonitor = ProgressTaskMonitor.createProgressTaskMonitor(MainModel.getDefaultParentFrame(), this);
            progressTaskMonitor.setMillisToDecideToPopup(0);
            progressTaskMonitor.setMillisToPopup(0);
            ECMLinkDeviceManager eCMLinkDeviceManager = ECMLinkActions.this.uiAdapter.getAdaptedManager();
            ECMLinkFlashOps eCMLinkFlashOps = eCMLinkDeviceManager.getFlashOps();
            ECMLinkConfigRecordSet eCMLinkConfigRecordSet = eCMLinkDeviceManager.getConfigRecordSet();
            Map map = eCMLinkConfigRecordSet.getPersistentRecordMapCopy();
            try {
                for (int i = 1; i <= 100 && !this.stopRequested; ++i) {
                    boolean bl = false;
                    this.loopCount = i;
                    this.note = "Requesting config save for loop #" + i;
                    eCMLinkFlashOps.requestConfigSave();
                    boolean bl2 = false;
                    try {
                        for (int j = 1; !bl2 && j <= 10; ++j) {
                            Thread.sleep(500L);
                            try {
                                this.note = "Reflash req #" + j + ", loop #" + i;
                                eCMLinkFlashOps.requestReflashMode();
                                bl2 = true;
                                continue;
                            }
                            catch (DeviceReflashConfigException deviceReflashConfigException) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl2) {
                        eCMLinkFlashOps.requestReflashMode();
                    }
                    this.note = "Waiting for reflash mode to time out";
                    Thread.sleep(4000L);
                    this.note = "Reconnecting to ECU and reading config set";
                    eCMLinkDeviceManager.setConnected(false);
                    eCMLinkConfigRecordSet = eCMLinkDeviceManager.getConfigRecordSet();
                    Map map2 = eCMLinkConfigRecordSet.getPersistentRecordMapCopy();
                    for (Integer n : map.keySet()) {
                        String string = ConfigRecord.getRecordDescription(eCMLinkDeviceManager.getConnectedDeviceId(), n);
                        ConfigRecord configRecord = (ConfigRecord)map.get(n);
                        ConfigRecord configRecord2 = (ConfigRecord)map2.get(n);
                        if (configRecord2 == null) {
                            logger.warning("MISSING '" + string + "'.  WAS PRESENT IN ORIGINAL MAP.");
                            continue;
                        }
                        int n2 = configRecord.getByteLength();
                        int[] nArray = new int[n2];
                        configRecord.putToBytes(nArray, 0);
                        int n3 = configRecord2.getByteLength();
                        int[] nArray2 = new int[n3];
                        configRecord2.putToBytes(nArray2, 0);
                        if (n2 != n3) {
                            logger.warning("MISMATCH ON RECORD LENGTH FOR '" + string + "'.  ORIGINAL WAS " + n2 + ", NEW WAS " + n3);
                            continue;
                        }
                        for (int j = 0; j < n2; ++j) {
                            if (nArray[j] == nArray2[j]) continue;
                            logger.warning(string + ": origBytes[" + j + "]=0x" + XFormatter.toHex2(nArray[j]) + ", newBytes[" + j + "]=0x" + XFormatter.toHex2(nArray2[j]));
                            bl = true;
                        }
                    }
                    if (!bl) continue;
                    logger.warning("RESETING ORIGINAL VALUES TO NEW VALUES FOR FUTURE ATTEMPTS");
                    map = map2;
                }
            }
            finally {
                this.stopRequested = true;
            }
        }

        @Override
        public int getMaximumProgress() {
            return 101;
        }

        @Override
        public String getMessage() {
            return "Reflash stress";
        }

        @Override
        public int getMinimumProgress() {
            return 0;
        }

        @Override
        public String getNote() {
            return this.note;
        }

        @Override
        public int getProgress() {
            return this.loopCount;
        }

        @Override
        public boolean isDone() {
            return this.stopRequested || this.loopCount > 100;
        }

        @Override
        public void stop() {
            this.stopRequested = true;
        }
    }

    private class MemoryDumpTask
    implements ProgressTask {
        int bytesRead = 0;
        int bytesToRead = 100;
        boolean stopRequested = false;

        private MemoryDumpTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doTask() throws Exception {
            BufferedOutputStream bufferedOutputStream;
            ProgressTaskMonitor progressTaskMonitor = ProgressTaskMonitor.createProgressTaskMonitor(MainModel.getDefaultParentFrame(), this);
            progressTaskMonitor.setMillisToDecideToPopup(300);
            progressTaskMonitor.setMillisToPopup(300);
            ECMLinkDeviceManager eCMLinkDeviceManager = ECMLinkActions.this.uiAdapter.getAdaptedManager();
            try {
                File file = new File(FilenameModel.getDefaultHome(), "memorydump.bin");
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (Exception exception) {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream("./memorydump.bin"));
            }
            try {
                int n = 64;
                int n2 = 448;
                int n3 = 25600;
                int n4 = 27616;
                if (ECMLinkDeviceMap.is2GDSMDevice(eCMLinkDeviceManager.getConnectedDeviceId())) {
                    n2 = 1600;
                    n3 = 5120;
                    n4 = 7136;
                }
                byte[] byArray = new byte[n4];
                Arrays.fill(byArray, (byte)-1);
                this.bytesToRead = n2 - n + (n4 - n3);
                this.readData(eCMLinkDeviceManager, byArray, n, n2);
                this.readData(eCMLinkDeviceManager, byArray, n3, n4);
                bufferedOutputStream.write(byArray, 0, n4);
            }
            finally {
                this.stopRequested = true;
                bufferedOutputStream.close();
            }
        }

        private void readData(ECMLinkDeviceManager eCMLinkDeviceManager, byte[] byArray, int n, int n2) throws Exception {
            int n3 = 32;
            for (int i = n; i < n2; i += n3) {
                int[] nArray = eCMLinkDeviceManager.readDataBlock(i, n3);
                for (int j = 0; j < n3; ++j) {
                    byArray[i + j] = (byte)(nArray[j] & 0xFF);
                }
                this.bytesRead += n3;
            }
        }

        @Override
        public int getMaximumProgress() {
            return this.bytesToRead;
        }

        @Override
        public String getMessage() {
            return "Reading data from ECU";
        }

        @Override
        public int getMinimumProgress() {
            return 0;
        }

        @Override
        public String getNote() {
            return null;
        }

        @Override
        public int getProgress() {
            return this.bytesRead;
        }

        @Override
        public boolean isDone() {
            return this.stopRequested || this.bytesRead >= this.bytesToRead;
        }

        @Override
        public void stop() {
            this.stopRequested = true;
        }
    }
}

