/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.AbstractDeviceInfoTab;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkUIAdapter;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ECMLinkDeviceInfoTab
extends AbstractDeviceInfoTab {
    JLabel lblConnectionStatus;
    JLabel lblDeviceDesc;
    JLabel lblSerialNum;
    JLabel lblFirmwareVersion;
    JLabel lblBootID;
    final ECMLinkUIAdapter uiAdapter;
    final ECMLinkDeviceManager deviceManager;

    public ECMLinkDeviceInfoTab(ECMLinkUIAdapter eCMLinkUIAdapter, ECMLinkDeviceManager eCMLinkDeviceManager) {
        super(eCMLinkDeviceManager);
        this.uiAdapter = eCMLinkUIAdapter;
        this.deviceManager = eCMLinkDeviceManager;
        this.build();
    }

    @Override
    protected String getDeviceTabName() {
        return "ECMLink Info";
    }

    @Override
    protected String getDeviceTabToolTip() {
        return "Basic status and control functionality for the ECMLink device manager";
    }

    @Override
    protected JComponent buildBtnStackPanel() {
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        this.connectBtn = DialogUtil.createListButton(this.uiAdapter.getActions().getConnectAction(), null, true);
        buttonStackBuilder.addGridded((JComponent)this.connectBtn);
        buttonStackBuilder.addGridded((JComponent)DialogUtil.createListButton("ecmlinkConfigure", false));
        buttonStackBuilder.addGridded((JComponent)DialogUtil.createListButton("ecmlinkLiveSettings", false));
        buttonStackBuilder.addGridded((JComponent)DialogUtil.createListButton("ecmlinkLiveDirectAccess", false));
        return buttonStackBuilder.getPanel();
    }

    @Override
    protected JComponent buildDeviceStatusPanel() {
        this.lblConnectionStatus = new JLabel();
        this.lblDeviceDesc = new JLabel();
        this.lblSerialNum = new JLabel();
        this.lblFirmwareVersion = new JLabel();
        this.lblBootID = new JLabel();
        this.populateStatusLabels();
        FormLayout formLayout = new FormLayout("r:d, 3dlu, l:max(80dlu;d):g", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        int n = 1;
        panelBuilder.addLabel("Connection status:", cellConstraints.xy(1, n));
        panelBuilder.add((Component)this.lblConnectionStatus, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Device type:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.lblDeviceDesc, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Serial number:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.lblSerialNum, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Firmware version:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.lblFirmwareVersion, cellConstraints.xy(3, n));
        panelBuilder.addLabel("Boot version:", cellConstraints.xy(1, n += 2));
        panelBuilder.add((Component)this.lblBootID, cellConstraints.xy(3, n));
        return panelBuilder.getPanel();
    }

    @Override
    protected void populateStatusLabels() {
        block5: {
            if (this.deviceManager.isConnected()) {
                this.lblConnectionStatus.setText("CONNECTED");
                try {
                    int n = this.deviceManager.getConnectedDeviceId();
                    this.lblDeviceDesc.setText(ECMLinkDeviceMap.getDeviceDisplayName(n));
                    this.lblSerialNum.setText(this.deviceManager.constructSerialNumDisplayStr(this.deviceManager.getConnectedSerialNum()));
                    this.lblFirmwareVersion.setText(ECMLinkDeviceMap.getDeviceVersionString(n, this.deviceManager.getConnectedFirmwareId()));
                    if (ECMLinkDeviceMap.isV1V2Device(n)) {
                        this.lblBootID.setText("N/A");
                        break block5;
                    }
                    this.lblBootID.setText(ECMLinkDeviceMap.getDeviceVersionString(n, this.deviceManager.getConnectedBootId()));
                }
                catch (Exception exception) {
                    this.lblDeviceDesc.setText("ERROR");
                    this.lblSerialNum.setText("ERROR");
                    this.lblFirmwareVersion.setText("ERROR");
                    this.lblBootID.setText("ERROR");
                }
            } else {
                this.lblConnectionStatus.setText("NOT CONNECTED");
                this.lblDeviceDesc.setText("N/A");
                this.lblSerialNum.setText("N/A");
                this.lblFirmwareVersion.setText("N/A");
                this.lblBootID.setText("N/A");
            }
        }
    }
}

