/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.DeviceUIAdapterInterface;
import com.ecmtuning.ecmlink.control.MainActions;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsMAFComp;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsSDVE;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsTPS;
import com.ecmtuning.ecmlink.control.ecmlink.AdjustActionsWGS;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkActions;
import com.ecmtuning.ecmlink.control.ecmlink.ECMLinkDeviceInfoTab;
import com.ecmtuning.ecmlink.control.ecmlink.UpgradeFirmwareTask;
import com.ecmtuning.ecmlink.device.DeviceException;
import com.ecmtuning.ecmlink.device.DeviceListener;
import com.ecmtuning.ecmlink.device.DeviceManager;
import com.ecmtuning.ecmlink.device.DeviceMap;
import com.ecmtuning.ecmlink.device.data.DatalogFile;
import com.ecmtuning.ecmlink.device.data.Dataset;
import com.ecmtuning.ecmlink.device.data.DeviceConfigData;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceConfigData;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.firmware.FirmwareHeader;
import com.ecmtuning.ecmlink.device.ecmlink.firmware.FirmwareUpgradeRequest;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSet;
import com.ecmtuning.ecmlink.device.ecmlink.records.ECMLinkConfigRecordSetFile;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidDataException;
import com.ecmtuning.ecmlink.device.records.ByteRecordSet;
import com.ecmtuning.ecmlink.device.records.ByteRecordSetFile;
import com.ecmtuning.ecmlink.device.records.ConfigRecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSet;
import com.ecmtuning.ecmlink.device.records.RecordSetFile;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.util.ui.TrackedTabPanel;
import com.ecmtuning.ecmlink.view.ecmlink.DirectAccessTab;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import com.ecmtuning.ecmlink.view.ecmlink.RecordSetTab;
import com.ecmtuning.ecmlink.view.ecmlink.SettingsTab;
import com.ecmtuning.ecmlink.view.main.DatalogTab;
import com.ecmtuning.ecmlink.view.main.MainView;
import com.ecmtuning.ecmlink.view.main.MenuBarView;
import com.ecmtuning.ecmlink.view.main.ToolBarView;
import com.jgoodies.uif.builder.MenuBuilder;
import com.jgoodies.uif.component.ToolBarButton;
import foxtrot.Task;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JToolBar;

public class ECMLinkUIAdapter
extends DeviceUIAdapterInterface
implements DeviceListener {
    private MainModel mainModel;
    private ECMLinkDeviceManager deviceManager;
    private ECMLinkActions actions;
    private JMenu ecuMenu;
    private SettingsTab liveSettingsTab;
    private DirectAccessTab liveDirectAccessTab;
    private Logger logger = Logger.getLogger(ECMLinkUIAdapter.class.getName());
    private final PropertyChangeListener tabDropListener = new PropertyChangeListener(){

        @Override
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ECMLinkUIAdapter.this.liveSettingsTab != null && propertyChangeEvent.getSource() == ECMLinkUIAdapter.this.liveSettingsTab) {
                if (propertyChangeEvent.getNewValue() == TrackedTabPanel.STATE_TAB_REMOVED) {
                    ECMLinkUIAdapter.this.liveSettingsTab.removePropertyChangeListener(this);
                    ECMLinkUIAdapter.this.liveSettingsTab = null;
                }
            } else if (ECMLinkUIAdapter.this.liveDirectAccessTab != null && propertyChangeEvent.getSource() == ECMLinkUIAdapter.this.liveDirectAccessTab) {
                if (propertyChangeEvent.getNewValue() == TrackedTabPanel.STATE_TAB_REMOVED) {
                    ECMLinkUIAdapter.this.liveDirectAccessTab.removePropertyChangeListener(this);
                    ECMLinkUIAdapter.this.liveDirectAccessTab = null;
                }
            } else if (propertyChangeEvent.getPropertyName() == "deviceCacheData") {
                if (ECMLinkUIAdapter.this.liveSettingsTab != null) {
                    ECMLinkUIAdapter.this.liveSettingsTab.setLiveView(false);
                }
                if (ECMLinkUIAdapter.this.liveDirectAccessTab != null) {
                    ECMLinkUIAdapter.this.liveDirectAccessTab.setLiveView(false);
                }
                ECMLinkUIAdapter.this.liveSettingsTab = null;
                ECMLinkUIAdapter.this.liveDirectAccessTab = null;
            }
        }
    };

    public ECMLinkUIAdapter() {
        this.mainModel = MainModel.getInstance();
        this.actions = new ECMLinkActions(this);
    }

    @Override
    public boolean accept(DeviceManager deviceManager) {
        if (deviceManager instanceof ECMLinkDeviceManager) {
            this.deviceManager = (ECMLinkDeviceManager)deviceManager;
            this.deviceManager.addPropertyChangeListener("deviceCacheData", this.tabDropListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsDeviceId(int n) {
        return ECMLinkDeviceManager.isSupportedDeviceId(n);
    }

    @Override
    public boolean openFile(File file) {
        String string = file.getName().trim().toLowerCase();
        if (string.endsWith("ecm")) {
            return this.openSettings(file);
        }
        if (string.endsWith("eda")) {
            return this.openDirectAccess(file);
        }
        if (string.endsWith("fwr")) {
            return this.openFirmwareRequest(file);
        }
        if (string.endsWith("efw")) {
            return this.openFirmwareFile(file);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean openFirmwareFile(File file) {
        boolean bl = false;
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            FirmwareHeader firmwareHeader = (FirmwareHeader)objectInputStream.readObject();
            if (ECMLinkDeviceMap.isECMLinkDevice(firmwareHeader.deviceId)) {
                bl = true;
                FirmwareUpgradeTask firmwareUpgradeTask = new FirmwareUpgradeTask(file);
                MainActions.handleMainFrameTask(firmwareUpgradeTask, true);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (objectInputStream != null) {
                try {
                    objectInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openSettings(File file) {
        boolean bl = false;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int n = ECMLinkConfigRecordSetFile.readDeviceId((DataInputStream)filterInputStream);
            filterInputStream.close();
            if (ECMLinkDeviceMap.isECMLinkDevice(n)) {
                bl = true;
                OpenSettingsTask openSettingsTask = new OpenSettingsTask(file);
                MainActions.handleMainFrameTask(openSettingsTask, false);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openDirectAccess(File file) {
        boolean bl = false;
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int n = ByteRecordSetFile.readDeviceId((DataInputStream)filterInputStream);
            if (ECMLinkDeviceMap.isECMLinkDevice(n)) {
                bl = true;
                OpenDirectAccessTask openDirectAccessTask = new OpenDirectAccessTask(file);
                MainActions.handleMainFrameTask(openDirectAccessTask, false);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    public boolean openFirmwareRequest(File file) {
        OpenFirmwareRequestTask openFirmwareRequestTask = new OpenFirmwareRequestTask(file);
        MainActions.handleMainFrameTask(openFirmwareRequestTask, false);
        return true;
    }

    public JFrame getApplicationFrame() {
        return MainModel.getDefaultParentFrame();
    }

    public ECMLinkDeviceManager getAdaptedManager() {
        return this.deviceManager;
    }

    public ECMLinkActions getActions() {
        return this.actions;
    }

    public void displayLiveConfigRecordTab() throws IOException, DeviceException {
        ECMLinkConfigRecordSet eCMLinkConfigRecordSet = this.deviceManager.getConfigRecordSet();
        if (this.liveSettingsTab == null || !this.liveSettingsTab.isLiveView()) {
            this.liveSettingsTab = new SettingsTab(eCMLinkConfigRecordSet, null);
            this.liveSettingsTab.addPropertyChangeListener(this.tabDropListener);
            this.addNewTab(this.liveSettingsTab);
        } else {
            ArrayList arrayList = this.mainModel.getTabPanelArrayList();
            int n = arrayList.indexOf(this.liveSettingsTab);
            if (n != -1) {
                this.mainModel.getTabPanelSelectionModel().setSelectedIndex(n);
            } else {
                this.addNewTab(this.liveSettingsTab);
            }
        }
    }

    public void displayLiveDirectAccessTab() throws IOException, DeviceException {
        Object object;
        if (OptionalMessageDialog.isShowingMsg("ecmlink.direct.access.usage.msg")) {
            object = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.direct.access.usage.msg", ECMLinkResources.getResourceBundle());
            ((OptionalMessageDialog)((Object)object)).setDoCancel(true);
            ((OptionalMessageDialog)((Object)object)).setOkText("Continue");
            DialogUtil.safeDispatchThreadCall(object, "open");
            if (object.hasBeenCanceled()) {
                return;
            }
        }
        if (this.liveDirectAccessTab == null || !this.liveDirectAccessTab.isLiveView()) {
            object = this.deviceManager.getByteRecordSet();
            this.liveDirectAccessTab = new DirectAccessTab((RecordSet)object, null);
            this.liveDirectAccessTab.addPropertyChangeListener(this.tabDropListener);
            this.addNewTab(this.liveDirectAccessTab);
        } else {
            object = this.mainModel.getTabPanelArrayList();
            int n = ((ArrayList)object).indexOf(this.liveDirectAccessTab);
            if (n != -1) {
                this.mainModel.getTabPanelSelectionModel().setSelectedIndex(n);
            } else {
                this.addNewTab(this.liveDirectAccessTab);
            }
        }
    }

    private void addNewTab(RecordSetTab recordSetTab) {
        this.mainModel.addTab(recordSetTab, true);
    }

    public void resetLTFT() throws IOException, DeviceException {
        if (OptionalMessageDialog.isShowingMsg("ecmlink.reset.ltft.msg")) {
            OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.reset.ltft.msg", ECMLinkResources.getResourceBundle());
            optionalMessageDialog.setDoCancel(true);
            optionalMessageDialog.setOkText("Continue");
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
            if (optionalMessageDialog.hasBeenCanceled()) {
                return;
            }
        }
        this.deviceManager.setLoc8ByName("LTFuelTrim1", 128);
        this.deviceManager.setLoc8ByName("LTFuelTrim2", 128);
        try {
            this.deviceManager.setLoc8ByName("LTFuelTrim3", 128);
        }
        catch (DeviceInvalidDataException deviceInvalidDataException) {
            // empty catch block
        }
        MainModel.showInfoMessage("Fuel trims have been reset.");
    }

    @Override
    public TrackedTabPanel createDeviceInfoTab() {
        return new ECMLinkDeviceInfoTab(this, this.deviceManager);
    }

    @Override
    public Action getConnectionConfigurationAction() {
        return ECMLinkActions.getAction("ecmlinkConfigure");
    }

    @Override
    public List getGraphViewEditActions(DatalogTab datalogTab, boolean bl) {
        Dataset dataset;
        ArrayList<Action> arrayList = new ArrayList<Action>();
        if (datalogTab.isLiveView()) {
            arrayList.add(ECMLinkActions.getAction(bl ? "ecmlinkLiveSettingsShort" : "ecmlinkLiveSettings"));
            arrayList.add(ECMLinkActions.getAction(bl ? "ecmlinkLiveDirectAccessShort" : "ecmlinkLiveDirectAccess"));
        } else if (datalogTab.getLastSavedDatalog() != null && (dataset = datalogTab.getLastSavedDatalog().getDataset()) != null) {
            this.addGraphViewEditActions(datalogTab.getLastSavedDatalog(), dataset.getMainConfigData(), bl, arrayList);
            this.addGraphViewEditActions(datalogTab.getLastSavedDatalog(), dataset.getAuxConfigData(), bl, arrayList);
        }
        return arrayList;
    }

    @Override
    public List getGraphViewExtActions(DatalogTab datalogTab) {
        ArrayList arrayList = new ArrayList();
        AdjustActionsMAFComp.addMafAdjActions(this, datalogTab, arrayList);
        AdjustActionsSDVE.addVEAdjActions(this, datalogTab, arrayList);
        AdjustActionsWGS.addWGSAdjActions(this, datalogTab, arrayList);
        AdjustActionsTPS.addTPSAdjActions(this, datalogTab, arrayList);
        return arrayList;
    }

    private void addGraphViewEditActions(DatalogFile datalogFile, DeviceConfigData deviceConfigData, boolean bl, List list) {
        if (deviceConfigData != null && deviceConfigData instanceof ECMLinkDeviceConfigData) {
            ECMLinkDeviceConfigData eCMLinkDeviceConfigData = (ECMLinkDeviceConfigData)deviceConfigData;
            ECMLinkConfigRecordSet eCMLinkConfigRecordSet = eCMLinkDeviceConfigData.getConfigRecordSet();
            ByteRecordSet byteRecordSet = eCMLinkDeviceConfigData.getByteRecordSet();
            EditRecordSetAction editRecordSetAction = new EditRecordSetAction(datalogFile, eCMLinkConfigRecordSet);
            ECMLinkResources.configureAction(editRecordSetAction, bl ? "ecmlinkOfflineSettingsShort" : "ecmlinkOfflineSettings");
            list.add(editRecordSetAction);
            if (byteRecordSet != null) {
                editRecordSetAction = new EditRecordSetAction(datalogFile, byteRecordSet);
                ECMLinkResources.configureAction(editRecordSetAction, bl ? "ecmlinkOfflineDirectAccessShort" : "ecmlinkOfflineDirectAccess");
                list.add(editRecordSetAction);
            }
        }
    }

    RecordSetTab bringForthRecordSetTab(DatalogFile datalogFile, RecordSet recordSet) {
        boolean bl = recordSet instanceof ConfigRecordSet;
        ArrayList arrayList = this.mainModel.getTabPanelArrayList();
        for (int i = 0; i < arrayList.size(); ++i) {
            RecordSetTab recordSetTab;
            Object e = arrayList.get(i);
            if ((!bl || !(e instanceof SettingsTab)) && (bl || !(e instanceof DirectAccessTab)) || (recordSetTab = (RecordSetTab)e).getParentDatalogFile() != datalogFile) continue;
            this.mainModel.getTabPanelSelectionModel().setSelectedIndex(i);
            return recordSetTab;
        }
        RecordSetTab recordSetTab = bl ? new SettingsTab(recordSet, datalogFile) : new DirectAccessTab(recordSet, datalogFile);
        this.addNewTab(recordSetTab);
        return recordSetTab;
    }

    public SettingsTab bringForthSettingsTab(DatalogFile datalogFile, boolean bl) throws IOException, DeviceException {
        DeviceConfigData deviceConfigData;
        Dataset dataset;
        if (bl) {
            this.displayLiveConfigRecordTab();
            return this.liveSettingsTab;
        }
        SettingsTab settingsTab = null;
        if (datalogFile != null && (dataset = datalogFile.getDataset()) != null && (deviceConfigData = dataset.getMainConfigData()) instanceof ECMLinkDeviceConfigData) {
            ECMLinkDeviceConfigData eCMLinkDeviceConfigData = (ECMLinkDeviceConfigData)deviceConfigData;
            ECMLinkConfigRecordSet eCMLinkConfigRecordSet = eCMLinkDeviceConfigData.getConfigRecordSet();
            settingsTab = (SettingsTab)this.bringForthRecordSetTab(datalogFile, eCMLinkConfigRecordSet);
        }
        return settingsTab;
    }

    @Override
    public void activate() {
        this.deviceManager.addDeviceListener(this);
        this.actions.activate();
        MainView mainView = this.mainModel.getMainView();
        MenuBarView menuBarView = mainView.getMenuBarView();
        JMenuBar jMenuBar = menuBarView.getMenuBar();
        int n = jMenuBar.getComponentIndex(menuBarView.getHelpMenu());
        jMenuBar.add((Component)this.getECUMenu(), n);
        jMenuBar.validate();
        ToolBarView toolBarView = mainView.getToolBarView();
        JToolBar jToolBar = toolBarView.getToolBar();
        int n2 = jToolBar.getComponentIndex(toolBarView.getLastToolbarComponent()) - 1;
        JToolBar.Separator separator = new JToolBar.Separator(null);
        separator.setOrientation(1);
        jToolBar.add((Component)separator, n2++);
        jToolBar.add((Component)new ToolBarButton(ECMLinkActions.getAction("ecmlinkLiveSettings")), n2++);
        jToolBar.add((Component)new ToolBarButton(ECMLinkActions.getAction("ecmlinkLiveDirectAccess")), n2++);
        jToolBar.add((Component)new ToolBarButton(this.actions.getConnectAction()), n2++);
    }

    private JMenu getECUMenu() {
        if (this.ecuMenu == null) {
            this.ecuMenu = this.buildECUMenu();
        }
        return this.ecuMenu;
    }

    private JMenu buildECUMenu() {
        MenuBuilder menuBuilder = new MenuBuilder("ECU", 'C');
        menuBuilder.add(this.actions.getConnectAction());
        menuBuilder.add(ECMLinkActions.getAction("ecmlinkLiveSettings"));
        menuBuilder.add(ECMLinkActions.getAction("ecmlinkLiveDirectAccess"));
        menuBuilder.addSeparator();
        menuBuilder.add(ECMLinkActions.getAction("ecmlinkResetLTFT"));
        menuBuilder.addSeparator();
        menuBuilder.add(MainActions.getAction("capturedValues"));
        menuBuilder.add(MainActions.getAction("startStream"));
        menuBuilder.add(MainActions.getAction("startCapture"));
        menuBuilder.addSeparator();
        menuBuilder.add(ECMLinkActions.getAction("ecmlinkConfigure"));
        menuBuilder.add(ECMLinkActions.getAction("ecmlinkFirmwareRequest"));
        menuBuilder.add(ECMLinkActions.getAction("ecmlinkFirmware"));
        return menuBuilder.getMenu();
    }

    @Override
    public void commandSendEnd() {
    }

    @Override
    public void commandSendEndError() {
    }

    @Override
    public void commandSendStart() {
    }

    @Override
    public void connectAttemptEnd() {
    }

    @Override
    public void connectAttemptStart() {
    }

    @Override
    public void connectProgress(int n) {
    }

    @Override
    public void connectStatus(boolean bl) {
        this.actions.setConnectedState(bl);
    }

    @Override
    public void statusTextUpdate(String string) {
    }

    @Override
    public void userRequestEnd() {
    }

    @Override
    public void userRequestStart() {
    }

    class EditRecordSetAction
    extends AbstractAction {
        final DatalogFile file;
        final RecordSet set;

        public EditRecordSetAction(DatalogFile datalogFile, ECMLinkConfigRecordSet eCMLinkConfigRecordSet) {
            this.file = datalogFile;
            this.set = new ECMLinkConfigRecordSet(eCMLinkConfigRecordSet);
        }

        public EditRecordSetAction(DatalogFile datalogFile, ByteRecordSet byteRecordSet) {
            this.file = datalogFile;
            this.set = new ByteRecordSet(byteRecordSet);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ECMLinkUIAdapter.this.bringForthRecordSetTab(this.file, this.set);
        }
    }

    class OpenFirmwareRequestTask
    extends Task {
        File file;

        OpenFirmwareRequestTask(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            FirmwareUpgradeRequest firmwareUpgradeRequest = FirmwareUpgradeRequest.read(this.file);
            MainModel.showInfoMessage("Opening firmware request.\n      Device type: " + DeviceMap.getDeviceDisplayName(firmwareUpgradeRequest.deviceId) + "\n      Serial number: " + ECMLinkDeviceManager._constructSerialNumDisplayStr(firmwareUpgradeRequest.serialNum) + "\n      Firmware version: " + ECMLinkDeviceMap.getDeviceVersionString(firmwareUpgradeRequest.deviceId, firmwareUpgradeRequest.firmwareId));
            FilenameModel filenameModel = ECMLinkUIAdapter.this.mainModel.getFilenameModel();
            filenameModel.setLastDeviceSettingsDirectory(this.file.getParent());
            SettingsTab settingsTab = new SettingsTab(firmwareUpgradeRequest.configRS);
            ECMLinkUIAdapter.this.addNewTab(settingsTab);
            DirectAccessTab directAccessTab = new DirectAccessTab(firmwareUpgradeRequest.byteRS);
            ECMLinkUIAdapter.this.addNewTab(directAccessTab);
            return null;
        }
    }

    class OpenDirectAccessTask
    extends Task {
        File file;

        OpenDirectAccessTask(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            RecordSetFile recordSetFile = ByteRecordSetFile.load(this.file);
            FilenameModel filenameModel = ECMLinkUIAdapter.this.mainModel.getFilenameModel();
            filenameModel.setLastDeviceSettingsDirectory(this.file.getParent());
            DirectAccessTab directAccessTab = new DirectAccessTab(recordSetFile);
            ECMLinkUIAdapter.this.addNewTab(directAccessTab);
            return null;
        }
    }

    class OpenSettingsTask
    extends Task {
        File file;

        OpenSettingsTask(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            RecordSetFile recordSetFile = ECMLinkConfigRecordSetFile.load(this.file);
            FilenameModel filenameModel = ECMLinkUIAdapter.this.mainModel.getFilenameModel();
            filenameModel.setLastDeviceSettingsDirectory(this.file.getParent());
            SettingsTab settingsTab = new SettingsTab(recordSetFile);
            ECMLinkUIAdapter.this.addNewTab(settingsTab);
            return null;
        }
    }

    class FirmwareUpgradeTask
    extends Task {
        File file;

        public FirmwareUpgradeTask(File file) {
            this.file = file;
        }

        public Object run() throws Exception {
            UpgradeFirmwareTask upgradeFirmwareTask = new UpgradeFirmwareTask(ECMLinkUIAdapter.this.getAdaptedManager());
            upgradeFirmwareTask.doReflash(this.file);
            return null;
        }
    }
}

