/*
 * Decompiled with CFR 0.152.
 */
package com.ecmtuning.ecmlink.control.ecmlink;

import com.ecmtuning.ecmlink.control.ecmlink.BaseFirmwareTask;
import com.ecmtuning.ecmlink.control.ecmlink.DirectAccessUpdateTask;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceManager;
import com.ecmtuning.ecmlink.device.ecmlink.ECMLinkDeviceMap;
import com.ecmtuning.ecmlink.device.ecmlink.firmware.FirmwareDataBlock;
import com.ecmtuning.ecmlink.device.ecmlink.firmware.FirmwareHeader;
import com.ecmtuning.ecmlink.device.exception.DeviceIncompatibleException;
import com.ecmtuning.ecmlink.device.exception.DeviceInterruptedException;
import com.ecmtuning.ecmlink.device.exception.DeviceInvalidStateException;
import com.ecmtuning.ecmlink.device.exception.DeviceUnsupportedOperationException;
import com.ecmtuning.ecmlink.model.FilenameModel;
import com.ecmtuning.ecmlink.model.MainModel;
import com.ecmtuning.ecmlink.util.XFormatter;
import com.ecmtuning.ecmlink.util.ui.DialogUtil;
import com.ecmtuning.ecmlink.util.ui.OptionalMessageDialog;
import com.ecmtuning.ecmlink.view.ecmlink.ECMLinkResources;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;

class UpgradeFirmwareTask
extends BaseFirmwareTask {
    private static final String STATUS_INITIAL_CRC = "Downloading initial data";
    private static final String STATUS_ERASING = "Erasing";
    private static final String STATUS_REPROGRAMMING_PREFIX = "Upgrade done: ";
    private static final String STATUS_FINAL_CRC = "Verifying new data";
    private static final int PROGRESS_ERASE = 24;
    private static final int PROGRESS_CHECKSUM = 48;
    private static final int PROGRESS_REFLASH = 256;
    private static final Logger logger = Logger.getLogger(UpgradeFirmwareTask.class.getName());

    UpgradeFirmwareTask(ECMLinkDeviceManager eCMLinkDeviceManager) {
        super(eCMLinkDeviceManager);
    }

    void doReflash() throws Exception {
        FileChooserRunner fileChooserRunner = new FileChooserRunner();
        SwingUtilities.invokeAndWait(fileChooserRunner);
        if (fileChooserRunner.wasCanceled) {
            return;
        }
        this.doReflash(fileChooserRunner.chosenFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doReflash(File file) throws Exception {
        Object object;
        int n;
        if (OptionalMessageDialog.isShowingMsg("ecmlink.initial.firmware.msg")) {
            OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.initial.firmware.msg", ECMLinkResources.getResourceBundle());
            optionalMessageDialog.setDoCancel(true);
            optionalMessageDialog.setOkText("Continue");
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
            if (optionalMessageDialog.hasBeenCanceled()) {
                return;
            }
        }
        logger.fine("Loading firmware data from " + file.getAbsolutePath());
        int n2 = this.deviceManager.getConnectedDeviceId();
        if (!ECMLinkDeviceMap.isV3Device(n2)) {
            throw new DeviceUnsupportedOperationException("This ECU does not support firmware upgrades.");
        }
        ObjectInputStream objectInputStream = null;
        FirmwareHeader firmwareHeader = null;
        FirmwareDataBlock[] firmwareDataBlockArray = null;
        boolean bl = true;
        try {
            objectInputStream = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(new FileInputStream(file))));
            firmwareHeader = (FirmwareHeader)objectInputStream.readObject();
            firmwareDataBlockArray = new FirmwareDataBlock[256];
            for (n = 0; n < 256; ++n) {
                try {
                    firmwareDataBlockArray[n] = (FirmwareDataBlock)objectInputStream.readObject();
                    continue;
                }
                catch (Exception exception) {
                    logger.log(Level.INFO, "Firmware file data exception", exception);
                    throw new IOException("Unable to read firmware data from specified file.");
                }
            }
            bl = false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFoundException("Failed to locate firmware file named " + file.getName());
        }
        catch (IOException iOException) {
            logger.log(Level.INFO, "Firmware file IO exception", iOException);
            throw new IOException("Failed to open " + file.getName());
        }
        catch (Exception exception) {
            logger.log(Level.INFO, "Firmware file header exception", exception);
            throw new IOException("Unable to read firmware header from specified file.");
        }
        finally {
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            if (bl) {
                logger.info("Failed to load firmware data from " + file.getAbsolutePath());
            } else {
                logger.fine("Firmware data loaded successfully");
            }
        }
        this.mainModel.getFilenameModel().setLastUserFirmwareDirectory(file.getParent());
        n = this.deviceManager.getConnectedFirmwareId();
        int n3 = firmwareHeader.firmwareId;
        String string = ECMLinkDeviceMap.getDeviceVersionString(n2, n);
        String string2 = ECMLinkDeviceMap.getDeviceVersionString(firmwareHeader.deviceId, n3);
        logger.fine("Device firmware ID: " + string);
        logger.fine("File firmware ID: " + string);
        if (!ECMLinkDeviceMap.isSameFamilyDevice(firmwareHeader.deviceId, n2)) {
            logger.info("Loaded deviceId = " + firmwareHeader.deviceId + ", ECU deviceId = " + n2);
            throw new DeviceIncompatibleException("Chosen file is not compatible with your ECU.");
        }
        OptionalMessageDialog optionalMessageDialog = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.confirm.firmware.msg", ECMLinkResources.getResourceBundle());
        optionalMessageDialog.setDoCancel(true);
        optionalMessageDialog.setOkText("Continue");
        optionalMessageDialog.setOptionDisplayed(false);
        optionalMessageDialog.setMessageArgs(new Object[]{string2, string});
        DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog, "open");
        if (optionalMessageDialog.hasBeenCanceled()) {
            logger.fine("User canceled firmware upgrade in confirm phase");
            return;
        }
        this.totalProgress = this.getDefaultProgressAmount();
        this.totalProgress += 24;
        this.totalProgress += 48;
        this.totalProgress += 256;
        this.totalProgress += 48;
        boolean bl2 = false;
        this.initializeProgress();
        try {
            int n4;
            int n5;
            this.enterReflashMode();
            this.progressStatusText = STATUS_ERASING;
            logger.fine("Erasing old data");
            for (int i = 0; i < 16 && !this.stopRequested; i += 4) {
                n5 = this.sectorAddr_inactiveBankStart + i;
                logger.fine("Erasing sector 0x" + XFormatter.toHex2(n5));
                this.flashOps.eraseInactiveSector(n5);
                this.currentProgress += 6;
            }
            this.progressStatusText = STATUS_INITIAL_CRC;
            logger.fine("Grabbing initial CRC data");
            int[] nArray = new int[256];
            this.fillCRCArray(this.sectorAddr_activeBankStart, nArray, 48);
            this.progressStatusText = "Upgrade done: 0%";
            logger.fine("Starting reprogram operation");
            n5 = -1;
            for (int i = 0; i < 256 && !this.stopRequested; ++i) {
                int n6;
                n4 = this.blockAddr_inactiveBankStart + i;
                if (this.deviceManager.doFastUpgrade() && nArray[i] == firmwareDataBlockArray[i].crc) {
                    if (n5 == -1) {
                        n5 = n4;
                    }
                    n6 = n4 - n5 + 1;
                    if (i == 255 || n6 >= 16) {
                        logger.fine("copyToInactiveBlock(blockAddress = 0x" + XFormatter.toHex4(n5) + ", blockLen = 0x" + XFormatter.toHex2(n6));
                        this.flashOps.copyToInactiveBlock(n5, n6);
                        n5 = -1;
                    }
                } else {
                    if (n5 != -1) {
                        n6 = n4 - n5;
                        logger.fine("copyToInactiveBlock(blockAddress = 0x" + XFormatter.toHex4(n5) + ", blockLen = 0x" + XFormatter.toHex2(n6));
                        this.flashOps.copyToInactiveBlock(n5, n6);
                        n5 = -1;
                    }
                    logger.fine("flashBlock(blockAddress = 0x" + XFormatter.toHex4(n4));
                    this.flashOps.flashBlock(true, n4, firmwareDataBlockArray[i].data, firmwareDataBlockArray[i].crc);
                }
                this.progressStatusText = STATUS_REPROGRAMMING_PREFIX + Math.round((float)i / 256.0f * 100.0f) + "%";
                ++this.currentProgress;
            }
            this.progressStatusText = STATUS_FINAL_CRC;
            logger.fine("Grabbing final CRC data");
            object = new int[256];
            this.fillCRCArray(this.sectorAddr_inactiveBankStart, (int[])object, 48);
            for (n4 = 0; n4 < 256 && !this.stopRequested; ++n4) {
                if (object[n4] == firmwareDataBlockArray[n4].crc) continue;
                logger.info("Failed verification of block " + n4 + " (0-255).");
                logger.info("ECU claimed CRC of 0x" + XFormatter.toHex4(object[n4]) + ", while file had CRC of 0x" + XFormatter.toHex4(firmwareDataBlockArray[n4].crc));
                throw new DeviceInvalidStateException("Final verification failed!");
            }
            boolean bl3 = bl2 = !this.stopRequested;
            if (this.stopRequested) {
                throw new DeviceInterruptedException("Operation canceled by request!");
            }
            this.rebootBank = this.inactiveBank;
        }
        finally {
            if (!bl2) {
                logger.info("Reprogramming operation has been stopped due either to error or cancellation request from user");
                this.taskDone = true;
                this.monitor.close();
                this.deviceManager.setConnected(false);
            }
        }
        try {
            this.rebootAndReconnect(false);
            int n7 = this.deviceManager.getConnectedFirmwareId();
            if (n7 != n3) {
                this.taskDone = true;
                this.monitor.close();
                String string3 = ECMLinkDeviceMap.getDeviceVersionString(n2, n7);
                logger.info("FirmwareId mismatch after reflash operation, new device ID=" + string3 + ", ID from file=" + string2 + ", original device ID=" + string);
                object = (Object)new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.final.firmware.id.mismatch.msg", ECMLinkResources.getResourceBundle());
                ((OptionalMessageDialog)((Object)object)).setDoCancel(false);
                ((OptionalMessageDialog)((Object)object)).setOkText("Bummer");
                ((OptionalMessageDialog)((Object)object)).setOptionDisplayed(false);
                ((OptionalMessageDialog)((Object)object)).setMessageArgs(new Object[]{string2, string3, string});
                DialogUtil.safeDispatchThreadCall(object, "open");
                return;
            }
            this.currentProgress += 16;
        }
        finally {
            if (!this.taskDone) {
                try {
                    if (this.deviceManager.isTestMode()) {
                        DirectAccessUpdateTask.doReflash(this, null);
                    }
                }
                finally {
                    if (!this.taskDone) {
                        this.taskDone = true;
                        this.monitor.close();
                    }
                }
            }
        }
        if (OptionalMessageDialog.isShowingMsg("ecmlink.final.firmware.msg")) {
            OptionalMessageDialog optionalMessageDialog2 = new OptionalMessageDialog(MainModel.getDefaultParentFrame(), "ecmlink.final.firmware.msg", ECMLinkResources.getResourceBundle());
            optionalMessageDialog2.setDoCancel(false);
            DialogUtil.safeDispatchThreadCall((Object)optionalMessageDialog2, "open");
        }
    }

    class FileChooserRunner
    implements Runnable {
        boolean wasCanceled = false;
        File chosenFile;

        FileChooserRunner() {
        }

        @Override
        public void run() {
            FilenameModel filenameModel = UpgradeFirmwareTask.this.mainModel.getFilenameModel();
            String string = filenameModel.getLastUserFirmwareDirectory();
            JFileChooser jFileChooser = new JFileChooser(string);
            jFileChooser.addChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.addChoosableFileFilter(FilenameModel.getFirmwareFileFilter());
            jFileChooser.setDialogTitle("Load ECMLink Firmware File");
            int n = jFileChooser.showOpenDialog(MainModel.getDefaultParentFrame());
            boolean bl = this.wasCanceled = n != 0;
            if (!this.wasCanceled) {
                this.chosenFile = jFileChooser.getSelectedFile();
            }
        }
    }
}

